#ifndef LYCURSES_H
#define LYCURSES_H

#ifdef TRUE
#undef TRUE  /* to prevent parse error :( */
#endif /* TRUE */
#ifdef FALSE
#undef FALSE  /* to prevent parse error :( */
#endif /* FALSE */

#ifdef USE_SLANG
#if defined(UNIX) && !defined(unix)
#define unix
#endif /* UNIX && !unix */
#ifdef va_start
#undef va_start
#endif /* va_start */
#include <slang.h>

#else /* Using curses: */

#ifdef VMS
#define FANCY_CURSES
#endif /* VMS */

/*
 *	CR may be defined before the curses.h include occurs.
 *	There is a conflict between the termcap char *CR and the define.
 *	Assuming that the definition of CR will always be carriage return.
 *	06-09-94 Lynx 2-3-1 Garrett Arch Blythe
 */
#ifdef CR
#undef CR  /* to prevent parse error :( */
#define REDEFINE_CR
#endif /* CR */

#ifdef NCURSES
# ifndef NCURSESHEADER
#  include <ncurses/curses.h>
# else
#  ifdef __NetBSD__
#    include <ncurses/ncurses.h>
#  else
#    include <ncurses.h>
#  endif /* __NetBSD__ */
# endif /* NCURSESINCDIR */
#else
# ifdef CURSES16
#  include <curses16.h>
# else
#  ifdef ULTRIX
#   include <cursesX.h>  /* ultrix */
#  else
#   if defined(SUN) || defined(sun) || defined(SGI) || defined(SCO) || defined(ISC) || defined(PTX2)
#    include "curses.h"
#   else
#    if defined(VMS) && defined(__GNUC__)
#     include "LYGCurses.h"
#    else
#     if defined(sony_news)
#      include "/usr/sony/include/jcurses.h"  /* sony_news */
#     else
#      include <curses.h>  /* everything else */
#     endif /* sony_news */
#    endif /* VMS && __GNUC__ */
#   endif /* SUN || sun || SGI || SCO || ISC || PTX2 */
#  endif /* ULTRIX */
# endif /* CURSES16 */
#endif /* NCURSES */
#ifdef VMS
extern void VMSbox PARAMS((WINDOW *win, int height, int width));
#else
extern void LYbox PARAMS((WINDOW *win));
#endif /* VMS */
#endif /* USE_SLANG */


/* Both slang and curses: */
#ifndef TRUE
#define TRUE  1
#endif /* !TRUE */
#ifndef FALSE
#define FALSE 0
#endif /* !FALSE */

#ifdef REDEFINE_CR
#define CR FROMASCII('\015')
#endif /* REDEFINE_CR */

extern int LYlines;  /* replaces LINES */
extern int LYcols;   /* replaces COLS */

#ifndef HTUTILS_H
#include "HTUtils.h"
#endif /* HTUTILS_H */

extern void start_curses NOPARAMS;
extern void stop_curses NOPARAMS;
extern BOOLEAN setup PARAMS((char *terminal));
extern void LYstartTargetEmphasis NOPARAMS;
extern void LYstopTargetEmphasis NOPARAMS;

#ifdef VMS
extern void VMSexit();
extern int ttopen();
extern int ttclose();
extern int ttgetc();
extern void *VMSsignal PARAMS((int sig, void (*func)()));
#endif /* VMS */


#ifdef USE_SLANG
extern void sl_add_attr PARAMS((int a));
extern void sl_sub_attr PARAMS((int a));
extern void lynx_setup_colors NOPARAMS;

#define start_bold()      sl_add_attr(1)
#define start_reverse()   sl_add_attr(2)
#define start_underline() sl_add_attr(4)
#define stop_bold()       sl_sub_attr(1)
#define stop_reverse()    sl_sub_attr(2)
#define stop_underline()  sl_sub_attr(4)

extern unsigned int Lynx_Color_Flags;
#define SL_LYNX_USE_COLOR	1
#define SL_LYNX_USE_BLINK	2

#ifdef FANCY_CURSES
#undef FANCY_CURSES
#endif /* FANCY_CURSES */
#ifndef NO_KEYPAD
#define NO_KEYPAD
#endif /* !NO_KEYPAD */
#ifndef NO_TTYTYPE
#define NO_TTYTYPE
#endif /* !NO_TTYTYPE */

/*
 *  Map some curses functions to slang functions.
 */
#define stdscr NULL
#ifdef SLANG_MBCS_HACK
extern int PHYSICAL_SLtt_Screen_Cols;
#define COLS PHYSICAL_SLtt_Screen_Cols
#else
#define COLS SLtt_Screen_Cols
#endif /* SLANG_MBCS_HACK */
#define LINES SLtt_Screen_Rows
#define move SLsmg_gotorc
#define addstr SLsmg_write_string
extern void LY_SLclear NOPARAMS;
#define clear LY_SLclear
#define erase LY_SLclear
#define standout SLsmg_reverse_video
#define standend  SLsmg_normal_video
#define clrtoeol SLsmg_erase_eol

/*  The following logic has been provided by John Davis <davis@space.mit.edu>
 *  to support different slang versions. - MS
 */
#ifdef SLSMG_NEWLINE_SCROLLS
#define scrollok(a,b) SLsmg_Newline_Behavior \
   = ((b) ? SLSMG_NEWLINE_SCROLLS : SLSMG_NEWLINE_MOVES)
#else
#define scrollok(a,b) SLsmg_Newline_Moves = ((b) ? 1 : -1)
#endif

#define addch SLsmg_write_char
#define echo()
#define printw SLsmg_printf
 
extern int curscr;
extern BOOLEAN FullRefresh;
#ifdef clearok
#undef clearok
#endif /* clearok */
#define clearok(a,b) { FullRefresh = (BOOLEAN)b; }
extern void LY_SLrefresh NOPARAMS;
#ifdef refresh
#undef refresh
#endif /* refresh */
#define refresh LY_SLrefresh

#ifdef VMS
extern void VTHome NOPARAMS;
#define endwin() clear(),refresh(),SLsmg_reset_smg(),VTHome()
#else
#define endwin SLsmg_reset_smg(),SLang_reset_tty
#endif /* VMS */

#else /* Define curses functions: */

#if defined(FANCY_CURSES) || defined(CURSES16)

#ifdef VMS
/*
 *  For VMS curses, [w]setattr() and [w]clrattr()
 *  add and subtract, respectively, the attributes
 *  _UNDERLINE, _BOLD, _REVERSE, and _BLINK. - FM
 */
#ifdef UNDERLINE_LINKS
#define start_bold()		setattr(_UNDERLINE)
#define stop_bold()		clrattr(_UNDERLINE)
#define start_underline()	setattr(_BOLD)
#define stop_underline()	clrattr(_BOLD)
#else /* not UNDERLINE_LINKS */
#define start_bold()		setattr(_BOLD)
#define stop_bold()		clrattr(_BOLD)
#define start_underline()	setattr(_UNDERLINE)
#define stop_underline()	clrattr(_UNDERLINE)
#endif /* UNDERLINE_LINKS */
#define start_reverse()		setattr(_REVERSE)
#define wstart_reverse(a)	wsetattr(a, _REVERSE)
#define wstop_underline(a)	wclrattr(a, _UNDERLINE)
#define stop_reverse()		clrattr(_REVERSE)
#define wstop_reverse(a)	wclrattr(a, _REVERSE)

#else /* Not VMS: */

/*
 *  For Unix FANCY_FANCY curses we interpose
 *  our own functions to add or subtract the
 *  A_foo attributes. - FM
 */
extern void LYaddWAttr PARAMS((WINDOW *win, int a));
extern void LYaddAttr PARAMS((int a));
extern void LYsubWAttr PARAMS((WINDOW *win, int a));
extern void LYsubAttr PARAMS((int a));

#ifdef UNDERLINE_LINKS
#define start_bold()		LYaddAttr(A_UNDERLINE)
#define stop_bold()		LYsubAttr(A_UNDERLINE)
#define start_underline()	LYaddAttr(A_BOLD)
#define stop_underline()	LYsubAttr(A_BOLD)
#else /* not UNDERLINE_LINKS: */
#define start_bold()		LYaddAttr(A_BOLD)
#define stop_bold()		LYsubAttr(A_BOLD)
#define start_underline()	LYaddAttr(A_UNDERLINE)
#define stop_underline()	LYsubAttr(A_UNDERLINE)
#endif /* UNDERLINE_LINKS */
#if defined(SNAKE) && defined(HP_TERMINAL)
#define start_reverse()		LYaddWAttr(stdscr, A_DIM)
#define wstart_reverse(a)	LYaddWAttr(a, A_DIM)
#define stop_reverse()		LYsubWAttr(stdscr, A_DIM)
#define wstop_reverse(a)	LYsubWAttr(a, A_DIM)
#else
#define start_reverse()		LYaddAttr(A_REVERSE)
#define wstart_reverse(a)	LYaddWAttr(a, A_REVERSE)
#define stop_reverse()		LYsubAttr(A_REVERSE)
#define wstop_reverse(a)	LYsubWAttr(a, A_REVERSE)
#endif /* SNAKE && HP_TERMINAL */
#endif /* VMS */

#else /* Not FANCY_CURSES: */

/*
 *  We only have [w]standout() and [w]standin(),
 *  so we'll use them synonymously for bold and
 *  reverse, and ignore underline. - FM
 */
#define start_bold()		standout()  
#define start_underline()	1  /* nothing */
#define start_reverse()		standout()
#define wstart_reverse(a)	wstandout(a)
#define stop_bold()		standend()  
#define stop_underline()	1  /* nothing */
#define stop_reverse()		standend()
#define wstop_reverse(a)	wstandend(a)

#endif /* FANCY_CURSES */
#endif /* USE_SLANG */

#ifdef USE_SLANG
#define LYGetYX(y, x)   y = SLsmg_get_row(), x = SLsmg_get_column()
#else
#ifdef getyx
#define LYGetYX(y, x)   getyx(stdscr, y, x)
#else
#define LYGetYX(y, x)   y = stdscr->_cury, x = stdscr->_curx
#endif /* getyx */
#endif /* USE_SLANG */

#endif /* LYCURSES_H */
