/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * sendjob -- send a job to the remote daemon
 */

#include "lp.h"

int	pfd;			/* printer file descriptor */

/*
 * Send a data file to the remote machine and spool it.
 * Return positive if we should try resending.
 */
sendfile(type, file, f)
	char type, *file;
	register int f;
{
	register int i, amt;
	struct stat stb;
	char buf[BUFSIZ];
	int sizerr;

	fstat(f, &stb);
	lseek(f, 0L, L_SET);
	amt = sprintf(buf, "%c%d %s\n", type, stb.st_size, file);
	if (write(pfd, buf, amt) != amt) {
		perror(lprserver);
		exit(1);
	}
	response();
	sizerr = 0;
	for (i = 0; i < stb.st_size; i += BUFSIZ) {
		amt = BUFSIZ;
		if (i + amt > stb.st_size)
			amt = stb.st_size - i;
		if (sizerr == 0 && read(f, buf, amt) != amt)
			sizerr = 1;
		if (write(pfd, buf, amt) != amt) {
			perror(lprserver);
			exit(1);
		}
	}
	if (sizerr)
		fputs("Warning: file changed size while sending!\n", stderr);
	if (write(pfd, "", 1) != 1) {
		perror(lprserver);
		exit(1);
	}
	response();
	return(0);
}

/*
 * Check to make sure there have been no errors and that both programs
 * are in sync with eachother.
 */
response()
{
	char resp;
	register int i;

	i = read(pfd, &resp, 1);
	if (i < 0) {
		perror(lprserver);
		exit(1);
	}
	if (i == 0) {
		fprintf(stderr, "%s: EOF without response\n", lprserver);
		exit(1);
	}
	if (resp == '\0')
		return(0);
	if (resp < 0x20)
		fprintf(stderr, "%s: numeric error response: %03o", lprserver,
			resp);
	else {
		putc(resp, stderr);
		copyreply(pfd, stderr);
	}
	exit(1);
}

/*
 * Acquire line printer or remote connection.
 */
openpr()
{
	register int n;

	pfd = getport();
	n = sprintf(line, "\2%s\n", printer);
	if (write(pfd, line, n) != n) {
		perror(lprserver);
		exit(1);
	}
	response();
}
