/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/*
 * lprm - remove the current user's spool entry
 *
 * lprm [-] [[job #] [user] ...]
 */

#include "lp.h"

/*
 * Stuff for handling job specifications
 */
char	*user[MAXUSERS];	/* users to process */
int	users;			/* # of users in user array */
int	requ[MAXREQUESTS];	/* job number of spool entries */
int	requests;		/* # of spool requests */
char	*person;		/* name of person doing lprm */
int	all = 0;		/* eliminate all files (root only) */

static char	luser[16];	/* buffer for person */

struct passwd *getpwuid();

main(argc, argv)
	char *argv[];
{
	register char *arg, *cp;
	struct passwd *p;

	cp = rindex(argv[0], '/');
	if (cp)
		name = cp + 1;
	else
		name = argv[0];
	gethostname(host, sizeof(host));
	if ((p = getpwuid(getuid())) == NULL) {
		fputs("Who are you?\n", stderr);
		exit(1);
	}
	if (strlen(p->pw_name) >= sizeof(luser)) {
		fputs("Your name is too long\n", stderr);
		exit(1);
	}
	strcpy(luser, p->pw_name);
	person = luser;
	while (--argc) {
		if ((arg = *++argv)[0] == '-')
			switch (arg[1]) {
			case 'S':
				if (arg[2])
					lprserver = &arg[2];
				else if (argc > 1) {
					argc--;
					lprserver = *++argv;
				}
				break;
			case 'P':
				if (arg[2])
					printer = &arg[2];
				else if (argc > 1) {
					argc--;
					printer = *++argv;
				}
				break;
			case '\0':
				if (!users) {
					users = -1;
					break;
				}
			default:
				usage();
			}
		else {
			if (users < 0)
				usage();
			if (isdigit(arg[0])) {
				if (requests >= MAXREQUESTS) {
					fprintf(stderr,
						"%s: Too many requests\n",
						name);
					exit(1);
				}
				requ[requests++] = atoi(arg);
			} else {
				if (users >= MAXUSERS) {
					fprintf(stderr, "%s: Too many users\n",
						name);
					exit(1);
				}
				user[users++] = arg;
			}
		}
	}
	if (lprserver == NULL && (lprserver = getenv("LPRSERVER")) == NULL) {
		fprintf(stderr,
			"%s: must specify LPR server with LPRSERVER or -S\n",
			name);
		exit(1);
	}
	if (printer == NULL && (printer = getenv("PRINTER")) == NULL)
		printer = DEFLP;

	rmjob();
}

rmjob()
{
	register char *cp;
	register int i, rem;
	char buf[BUFSIZ];

	/*
	 * If the format was `lprm -' and the user isn't the super-user,
	 *  then fake things to look like he said `lprm user'.
	 */
	if (users < 0) {
		if (getuid() == 0)
			all = 1;	/* all files in queue */
		else {
			user[0] = person;
			users = 1;
		}
	}
	sprintf(buf, "\5%s %s", printer, all ? "-all" : person);
	cp = buf;
	for (i = 0; i < users; i++) {
		cp += strlen(cp);
		*cp++ = ' ';
		strcpy(cp, user[i]);
	}
	for (i = 0; i < requests; i++) {
		cp += strlen(cp);
		(void) sprintf(cp, " %d", requ[i]);
	}
	strcat(cp, "\n");
	rem = getport();
	i = strlen(buf);
	if (write(rem, buf, i) != i) {
		perror(lprserver);
		exit(1);
	}
	copyreply(rem, stdout);
	(void) close(rem);
}

static
usage()
{
	printf("usage: lprm [-] [-Pprinter] [-Sserver] [[job #] [user] ...]\n");
	exit(2);
}
