/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/*
 * Client LPR: send the job to a remote LPR server without local lpd facilities
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pwd.h>
#include <ctype.h>
#include <strings.h>
#include "lp.local.h"

char    *tfname;		/* tmp copy of cf before linking */
char    *cfname;		/* daemon control files, linked from tf's */
char    *dfname;		/* data files */

int	nact;			/* number of jobs to act on */
int	tfd;			/* control file descriptor */
int     mailflg;		/* send mail */
char	format = 'f';		/* format char for printing files */
int	inchar;			/* location to increment char in file names */
int     ncopies = 1;		/* # of copies to make */
int	iflag;			/* indentation wanted */
int	indent;			/* amount to indent */
int	hdr = 1;		/* print header or not (default is yes) */
int     userid;			/* user id */
char	*person;		/* user name */
char	*title;			/* pr'ing title */
char	*fonts[4];		/* troff font names */
char	*width;			/* width for versatec printing */
char	host[32];		/* host name */
char	*class = host;		/* class title on header page */
char    *jobname;		/* job name on header page */
char	*name;			/* program name */
char	*lprserver;		/* LPR server name */
char	*printer;		/* printer name */
struct	stat statb;

char	*getenv();

/*ARGSUSED*/
main(argc, argv)
	int argc;
	char *argv[];
{
	extern struct passwd *getpwuid();
	struct passwd *pw;
	extern char *itoa();
	register char *arg, *cp;
	char buf[BUFSIZ];
	int i, f;
	struct stat stb;

	cp = rindex(argv[0], '/');
	if (cp)
		name = cp + 1;
	else
		name = argv[0];
	gethostname(host, sizeof (host));

	while (argc > 1 && argv[1][0] == '-') {
		argc--;
		arg = *++argv;
		switch (arg[1]) {

		case 'S':		/* specifiy LPR server name */
			if (arg[2])
				lprserver = &arg[2];
			else if (argc > 1) {
				argc--;
				lprserver = *++argv;
			}
			break;

		case 'P':		/* specifiy printer name */
			if (arg[2])
				printer = &arg[2];
			else if (argc > 1) {
				argc--;
				printer = *++argv;
			}
			break;

		case 'C':		/* classification spec */
			hdr++;
			if (arg[2])
				class = &arg[2];
			else if (argc > 1) {
				argc--;
				class = *++argv;
			}
			break;

		case 'J':		/* job name */
			hdr++;
			if (arg[2])
				jobname = &arg[2];
			else if (argc > 1) {
				argc--;
				jobname = *++argv;
			}
			break;

		case 'T':		/* pr's title line */
			if (arg[2])
				title = &arg[2];
			else if (argc > 1) {
				argc--;
				title = *++argv;
			}
			break;

		case 'l':		/* literal output */
		case 'p':		/* print using ``pr'' */
		case 't':		/* print troff output (cat files) */
		case 'n':		/* print ditroff output */
		case 'd':		/* print tex output (dvi files) */
		case 'g':		/* print graph(1G) output */
		case 'c':		/* print cifplot output */
		case 'v':		/* print vplot output */
			format = arg[1];
			break;

		case 'f':		/* print fortran output */
			format = 'r';
			break;

		case '4':		/* troff fonts */
		case '3':
		case '2':
		case '1':
			if (argc > 1) {
				argc--;
				fonts[arg[1] - '1'] = *++argv;
			}
			break;

		case 'w':		/* versatec page width */
			width = arg+2;
			break;

		case 'm':		/* send mail when done */
			mailflg++;
			break;

		case 'h':		/* toggle want of header page */
			hdr = !hdr;
			break;

		case 'i':		/* indent output */
			iflag++;
			indent = arg[2] ? atoi(&arg[2]) : 8;
			break;

		case '#':		/* n copies */
			if (isdigit(arg[2])) {
				i = atoi(&arg[2]);
				if (i > 0)
					ncopies = i;
			}
		}
	}
	if (lprserver == NULL && (lprserver = getenv("LPRSERVER")) == NULL) {
		fprintf(stderr,
			"%s: must specify LPR server with LPRSERVER or -S\n",
			name);
		exit(1);
	}
	if (printer == NULL && (printer = getenv("PRINTER")) == NULL)
		printer = DEFLP;
	/*
	 * Get the identity of the person doing the lpr using the same
	 * algorithm as lprm. 
	 */
	userid = getuid();
	if ((pw = getpwuid(userid)) == NULL) {
		fputs("Who are you?\n", stderr);
		exit(1);
	}
	person = pw->pw_name;
	/*
	 * Initialize the control file.
	 */
	mktemps();
	tfd = gettemp();
	card('H', host);
	card('P', person);
	if (hdr) {
		if (jobname == NULL) {
			if (argc == 1)
				jobname = "stdin";
			else
				jobname = (arg = rindex(argv[1], '/')) ? arg+1 : argv[1];
		}
		card('J', jobname);
		card('C', class);
		card('L', person);
	}
	if (iflag)
		card('I', itoa(indent));
	if (mailflg)
		card('M', person);
	if (format == 't' || format == 'n' || format == 'd')
		for (i = 0; i < 4; i++)
			if (fonts[i] != NULL)
				card('1'+i, fonts[i]);
	if (width != NULL)
		card('W', width);

	/*
	 * Read the files and spool them.
	 */
	if (argc == 1) {
		f = copystdin();
		openpr();
		sendfile('\3', dfname, f);
		(void) close(f);
		cardfile(" ");
		nact++;
	} else while (--argc) {
		if ((f = test(arg = *++argv)) < 0)
			continue;	/* file unreasonable */
		if (!nact)
			openpr();
		if (dfname[0] == 't') {
			fputs("too many files - break up the job\n", stderr);
			break;
		}
		sendfile('\3', dfname, f);
		(void) close(f);
		cardfile(arg);
		nact++;
		dfname[2]++;
		if (dfname[2] == '[')
			dfname[2] = 'a';
		else if (dfname[2] == '{') {
			dfname[2] = 'A';
			dfname[0]++;
		}
	}

	if (nact) {
		sendfile('\2', cfname, tfd);
		(void) close(tfd);
		exit(0);
	}
	exit(1);
}

/*
 * Copy stdin into a temporary file.
 */
copystdin()
{
	register int fd, i, nc;
	char buf[BUFSIZ];

	fd = gettemp();
	nc = 0;
	while ((i = read(0, buf, BUFSIZ)) > 0) {
		if (write(fd, buf, i) != i) {
			perror("temp file write error");
			exit(1);
		}
		nc += i;
	}
	if (nc==0) {
		fprintf(stderr, "%s: stdin: empty input file\n", name);
		exit(1);
	}
	return(fd);
}

/*
 * Put the right magic info about file n in cf.
 */
cardfile(n)
	char n[];
{
	register int i;

	if (format == 'p')
		card('T', title ? title : n);
	for (i = 0; i < ncopies; i++)
		card(format, &dfname[inchar-2]);
	card('U', &dfname[inchar-2]);
	card('N', n);
}

/*
 * Put a line into the control file.
 */
card(c, p2)
	register char c, *p2;
{
	char buf[BUFSIZ];
	register char *p1 = buf;
	register int len = 2;

	*p1++ = c;
	while ((c = *p2++) != '\0') {
		*p1++ = c;
		len++;
	}
	*p1++ = '\n';
	write(tfd, buf, len);
}

/*
 * Test to see if this is a printable file.
 * Return -1 if it is not, open fd if it's printable.
 */
test(file)
	char *file;
{
#ifndef SLOWARIS
	struct exec execb;
#endif
	register int fd;

	if (access(file, 4) < 0) {
		printf("%s: cannot access %s\n", name, file);
		return(-1);
	}
	if (stat(file, &statb) < 0) {
		printf("%s: cannot stat %s\n", name, file);
		return(-1);
	}
	if ((statb.st_mode & S_IFMT) == S_IFDIR) {
		printf("%s: %s is a directory\n", name, file);
		return(-1);
	}
	if ((statb.st_mode & S_IFMT) == S_IFCHR ||
	    (statb.st_mode & S_IFMT) == S_IFBLK) {
		printf("%s: %s is a special file\n", name, file);
		return(-1);
	}
	if (statb.st_size == 0) {
		printf("%s: %s is an empty file\n", name, file);
		return(-1);
 	}
	if ((fd = open(file, O_RDONLY)) < 0) {
		printf("%s: cannot open %s\n", name, file);
		return(-1);
	}
#ifndef SLOWARIS
	if (read(fd, &execb, sizeof(execb)) == sizeof(execb))
		switch(execb.a_magic) {
		case A_MAGIC1:
		case A_MAGIC2:
		case A_MAGIC3:
#ifdef A_MAGIC4
		case A_MAGIC4:
#endif
			printf("%s: %s is an executable program", name, file);
			goto error1;

		case ARMAG:
			printf("%s: %s is an archive file", name, file);
			goto error1;
		}
#endif	/* !SLOWARIS */
	return(fd);

error1:
	printf(" and is unprintable\n");
	(void) close(fd);
	return(-1);
}

/*
 * itoa - integer to string conversion
 */
char *
itoa(i)
	register int i;
{
	static char b[10] = "########";
	register char *p;

	p = &b[8];
	do
		*p-- = i%10 + '0';
	while (i /= 10);
	return(++p);
}

/*
 * Make the temp files.
 */
mktemps()
{
	register int n, len;
	char *mktempnam();

	n = getpid() % 1000;
	len = strlen(host) + 7;
	tfname = mktempnam("tf", n, len);
	cfname = mktempnam("cf", n, len);
	dfname = mktempnam("df", n, len);
	inchar = 2;
}

/*
 * Make a temp file name.
 */
char *
mktempnam(id, num, len)
	char	*id;
	int	num, len;
{
	register char *s;
	extern char *malloc();

	if ((s = malloc(len)) == NULL) {
		fprintf(stderr, "%s: out of memory\n", name);
		exit(1);
	}
	(void) sprintf(s, "%sA%03d%s", id, num, host);
	return(s);
}

gettemp()
{
	char tmpname[16];
	register int fd;

	strcpy(tmpname, "/tmp/clprXXXXXX");
	fd = mkstemp(tmpname);
	if (fd < 0) {
		fprintf(stderr, "%s: unable to create a temporary file\n",
			name);
		exit(1);
	}
	unlink(tmpname);
	return(fd);
}
