/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/*
 * Spool Queue examination program
 *
 * lpq [-l] [-Pprinter] [user...] [job...]
 *
 * -l long output
 * -P used to identify printer as per lpr/lprm
 */

#include "lp.h"

char	*user[MAXUSERS];	/* users to process */
int	users;			/* # of users in user array */
int	requ[MAXREQUESTS];	/* job number of spool entries */
int	requests;		/* # of spool requests */

main(argc, argv)
	register int	argc;
	register char	**argv;
{
	extern char	*optarg;
	extern int	optind;
	int	ch, lflag;		/* long output option */
	register char *cp;

	cp = rindex(argv[0], '/');
	if (cp)
		name = cp + 1;
	else
		name = argv[0];
	if (gethostname(host, sizeof(host))) {
		perror("lpq: gethostname");
		exit(1);
	}

	lflag = 0;
	while ((ch = getopt(argc, argv, "lPS:")) != EOF)
		switch((char)ch) {
		case 'l':			/* long output */
			++lflag;
			break;
		case 'P':		/* printer name */
			printer = optarg;
			break;
		case 'S':		/* LPR server name */
			lprserver = optarg;
			break;
		case '?':
		default:
			usage();
		}

	if (lprserver == NULL && (lprserver = getenv("LPRSERVER")) == NULL) {
		fprintf(stderr,
			"%s: must specify LPR server with LPRSERVER or -S\n",
			name);
		exit(1);
	}
	if (printer == NULL && (printer = getenv("PRINTER")) == NULL)
		printer = DEFLP;

	for (argc -= optind, argv += optind; argc; --argc, ++argv)
		if (isdigit(argv[0][0])) {
			if (requests >= MAXREQUESTS) {
				fprintf(stderr, "%s: too many requests\n",
					name);
				exit(1);
			}
			requ[requests++] = atoi(*argv);
		}
		else {
			if (users >= MAXUSERS) {
				fprintf(stderr, "%s: too many users\n", name);
				exit(1);
			}
			user[users++] = *argv;
		}

	displayq(lflag);
	exit(0);
}

/*
 * Display the current state of the queue. Format = 1 if long format.
 */
displayq(format)
	int format;
{
	register char *cp;
	register int i, fd;

	/*
	 * Print foreign queue
	 */
	(void) sprintf(line, "%c%s", format + '\3', printer);
	cp = line;
	for (i = 0; i < requests; i++) {
		cp += strlen(cp);
		(void) sprintf(cp, " %d", requ[i]);
	}
	for (i = 0; i < users; i++) {
		cp += strlen(cp);
		*cp++ = ' ';
		(void) strcpy(cp, user[i]);
	}
	strcat(line, "\n");
	fd = getport();
	i = strlen(line);
	if (write(fd, line, i) != i) {
		perror(lprserver);
		exit(1);
	}
	copyreply(fd, stdout);
	(void) close(fd);
}

static
usage()
{
	puts("usage: lpq [-l] [-Pprinter] [-Sserver] [user ...] [job ...]");
	exit(1);
}
