/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * Routines and data common to all the line printer functions.
 */

#include "lp.h"

char	line[BUFSIZ];
char	*name;		/* program name */
char	*lprserver;	/* LPR server name */
char	*printer;	/* printer name */
char	host[32];	/* host machine name */

/*
 * Create a connection to the remote printer server.
 * Most of this code comes from rcmd.c.
 */
getport()
{
	struct hostent *hp;
	struct sockaddr_in sin;
	int s, lport = IPPORT_RESERVED - 1;
	int err;

	/* Get ourselves a socket */
	s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (s < 0) {
		perror("socket");
		exit(1);
	}
	/* if root, try getting a reserved port */
	if (!geteuid()) {
		sin.sin_family = AF_INET;
		sin.sin_addr.s_addr = INADDR_ANY;
		for (;;) {
			sin.sin_port = htons((u_short)lport);
			if (bind(s, (caddr_t)&sin, sizeof (sin)) >= 0)
				break;
			if (errno != EADDRINUSE)
				break;
			lport--;
			if (lport == IPPORT_RESERVED/2)
				break;
		}
	}

	/*
	 * Get the host address and port number to connect to.
	 */
	if ((sin.sin_addr.s_addr = inet_addr(lprserver)) != INADDR_NONE)
		sin.sin_family = AF_INET;
	else {
		hp = gethostbyname(lprserver);
		if (hp == NULL)
			herror(lprserver);
		bcopy(hp->h_addr, (caddr_t)&sin.sin_addr, hp->h_length);
		sin.sin_family = hp->h_addrtype;
	}
	sin.sin_port = htons(515);

	/*
	 * Try connecting to the server.
	 */
	if (connect(s, (caddr_t)&sin, sizeof(sin)) < 0) {
		err = errno;
		(void) close(s);
		errno = err;
		perror(lprserver);
		exit(1);
	}
	return(s);
}

copyreply(tcp, out)
	register int tcp;
	register FILE *out;
{
	register int i;

	while (i = read(tcp, line, BUFSIZ)) {
		if (i < 0) {
			perror(lprserver);
			exit(1);
		}
		fwrite(line, 1, i, out);
	}
}
