/*
 * Hack-o-Rocket router configuration compiler
 *
 * Reading and initial parsing of the source file is done here.
 */

#include <ctype.h>
#include <stdio.h>
#include <strings.h>
#include "defs.h"

extern char *input_filename;

int lineno;

extern int set_sdsl();
extern int set_idsl();
extern int set_dlci();
extern int set_vpi();
extern int set_vci();
extern int set_quat();
extern int set_lan();
extern int set_wanip();
extern int set_add_ip();
extern int set_add_route();

struct kwtab {
	char	*keyword;
	int	(*func)();
} keywords[] = {
	"sdsl",		set_sdsl,
	"idsl",		set_idsl,
	"dlci",		set_dlci,
	"vpi",		set_vpi,
	"vci",		set_vci,
	"quat",		set_quat,
	"lan",		set_lan,
	"wan",		set_wanip,
	"addip",	set_add_ip,
	"route",	set_add_route,
	NULL,		NULL};

read_input_file()
{
	FILE *inf;
	char linebuf[512];

	inf = fopen(input_filename, "r");
	if (!inf) {
		perror(input_filename);
		exit(1);
	}

	for (lineno = 1; fgets(linebuf, sizeof linebuf, inf); lineno++)
		process_line(linebuf);

	fclose(inf);
}

process_line(linebuf)
	char *linebuf;
{
	char *args[MAX_SPEC_ARGS+1];
	int nargs;
	register char *cp;
	register struct kwtab *kwp;

	for (cp = linebuf, nargs = 0; ; ) {
		while (isspace(*cp))
			cp++;
		if (*cp == '\0' || *cp == '#')
			break;
		if (!isgraph(*cp)) {
			fprintf(stderr, "%s: line %d: illegal character\n",
				input_filename, lineno);
			exit(1);
		}
		if (nargs >= MAX_SPEC_ARGS) {
			fprintf(stderr, "%s: line %d: too many arguments\n",
				input_filename, lineno);
			exit(1);
		}
		args[nargs++] = cp;
		while (isgraph(*cp))
			cp++;
		if (isspace(*cp))
			*cp++ = '\0';
	}
	if (!nargs)
		return;		/* ignore empty lines */
	args[nargs] = NULL;
	for (kwp = keywords; kwp->keyword; kwp++)
		if (!strcasecmp(args[0], kwp->keyword))
			break;
	if (!kwp->func) {
		fprintf(stderr, "%s: line %d: \"%s\" setting not defined\n",
			input_filename, lineno, args[0]);
		exit(1);
	}
	kwp->func(nargs-1, args+1);
}

is_number_string(str)
	char *str;
{
	register char *cp;

	for (cp = str; *cp; cp++)
		if (!isdigit(*cp))
			return(0);
	return(1);
}
