/*
 * Hack-o-Rocket router configuration compiler
 *
 * Main routine
 */

#include <sys/types.h>
#include <stdio.h>
#include "config.h"

extern char *malloc();

extern int wan_type, lanconf_set, wanip_set;
extern struct lan_config lanconf;
extern struct wan_config wanconf;
extern int vpi, vci;

char *input_filename, *output_filename;

main(argc, argv)
	char **argv;
{
	if (argc < 2 || argc > 3) {
		fprintf(stderr, "usage: %s cfgfile [binfile]\n", argv[0]);
		exit(1);
	}
	input_filename = argv[1];
	if (argv[2])
		output_filename = argv[2];
	else {
		output_filename = malloc(strlen(input_filename) + 5);
		if (!output_filename) {
			perror("malloc");
			exit(1);
		}
		sprintf(output_filename, "%s.bin", input_filename);
	}

	read_input_file();
	/* minimal requirements */
	if (!wan_type || !lanconf_set) {
		fprintf(stderr,
		"LAN configuration and WAN type must be set at the minimum\n");
		exit(1);
	}

	/* finishing touches */
	if (!wanip_set)
		wanconf.wan_ip = lanconf.lan_ip;	/* unnumbered if */
	switch (wan_type) {
	case WANTYPE_IDSL:
	case WANTYPE_SDSLB:
		set_q922_addr();
		break;
	case WANTYPE_NSDSL:
		wanconf.wan_atm_addr = htonl((vpi << 20) | (vci << 4));
	}
	make_routing_table();

	/* spit it out! */
	prepare_bin_output();
	write_output_file();
	exit(0);
}
