/*
 * Hack-o-Rocket router configuration compiler
 *
 * IDSL specifics
 */

#include <sys/types.h>
#include <machine/endian.h>
#include <ctype.h>
#include <strings.h>
#include <stdio.h>
#include "config.h"

extern struct idsl_phy_config idslphy;

extern char *input_filename;
extern int lineno;

idsl_channels_conf(confstring)
	char *confstring;
{
	int timeslot, hadplus, incr;
	register char *cp, *np;
	short *p;

	idslphy.idsl_b1_slot = -1;
	idslphy.idsl_b2_slot = -1;
	idslphy.idsl_d_slot = -1;
	for (cp = confstring, timeslot = 0; ; timeslot += incr) {
		if (!isalpha(*cp)) {
inv:			fprintf(stderr,
			"%s: line %d: invalid IDSL channel specification\n",
				input_filename, lineno);
			exit(1);
		}
		for (np = cp; isalnum(*cp); cp++)
			;
		if (*cp == '+') {
			hadplus = 1;
			*cp++ = '\0';
		} else if (!*cp)
			hadplus = 0;
		else
			goto inv;
		if (!strcasecmp(np, "B1")) {
			p = &idslphy.idsl_b1_slot;
			incr = 4;
		} else if (!strcasecmp(np, "B2")) {
			p = &idslphy.idsl_b2_slot;
			incr = 4;
		} else if (!strcasecmp(np, "D")) {
			p = &idslphy.idsl_d_slot;
			incr = 1;
		} else
			goto inv;
		if (*p >= 0) {
			fprintf(stderr,
				"%s: line %d: %s channel slot listed twice\n",
				input_filename, lineno, np);
			exit(1);
		}
		*p = timeslot;
		if (!hadplus)
			break;
	}
	idslphy.idsl_b1_slot = htons(idslphy.idsl_b1_slot);
	idslphy.idsl_b2_slot = htons(idslphy.idsl_b2_slot);
	idslphy.idsl_d_slot = htons(idslphy.idsl_d_slot);
}
