/*
 * Hack-o-Rocket router configuration compiler
 *
 * The final binary output is produced here.
 */

#include <sys/types.h>
#include <sys/file.h>
#include <stdio.h>
#include "config.h"

extern char *malloc();

extern int wan_type;
extern struct lan_config lanconf;
extern struct wan_config wanconf;
extern struct sdsl_phy_config sdslphy;
extern struct idsl_phy_config idslphy;
extern struct rt_entry rtable[];
extern int total_routes;

extern char *output_filename;

static u_char *buffer;
static int bufptr;
static struct master_config *mcfg;

prepare_bin_output()
{
	buffer = (u_char *) malloc(32768);
	if (!buffer) {
		perror("malloc");
		exit(1);
	}
	mcfg = (struct master_config *) buffer;
	bufptr = sizeof(struct master_config);
	bcopy("HORCFG", mcfg->mc_magic, 6);
	mcfg->mc_wantype = wan_type;
	mcfg->mc_version = CONFIG_STRUCT_VERSION;

	mcfg->off_phyconf = htonl(bufptr);
	switch (wan_type) {
	case WANTYPE_IDSL:
		emit(&idslphy, sizeof idslphy);
		break;
	case WANTYPE_SDSLB:
	case WANTYPE_NSDSL:
		emit(&sdslphy, sizeof sdslphy);
	}
	mcfg->off_lanconf = htonl(bufptr);
	emit(&lanconf, sizeof lanconf);
	mcfg->off_wanconf = htonl(bufptr);
	emit(&wanconf, sizeof wanconf);
	mcfg->off_routing_table = htonl(bufptr);
	emit(rtable, sizeof(struct rt_entry) * total_routes);
}

emit(data, datalen)
	caddr_t data;
{
	bcopy(data, buffer + bufptr, datalen);
	bufptr += datalen;
}

write_output_file()
{
	int fd;

	fd = open(output_filename, O_WRONLY|O_CREAT|O_TRUNC, 0666);
	if (fd < 0) {
		perror(output_filename);
		exit(1);
	}
	write(fd, buffer, bufptr);
	close(fd);
}
