#ifndef __HORT_CONFIG_H
#define	__HORT_CONFIG_H

/* WAN types for the HoR router */
#define	WANTYPE_IDSL	0x01
#define	WANTYPE_SDSLB	0x02	/* SDSL Flavor B */
#define	WANTYPE_NSDSL	0x03	/* Nokia SDSL */

#define	CONFIG_STRUCT_VERSION	0x01

/* configuration data structures */

struct master_config {
	char	mc_magic[6];
	u_char	mc_wantype;
	u_char	mc_version;
	/* the following are offsets from this base */
	u_long	off_lanconf;
	u_long	off_wanconf;
	u_long	off_phyconf;
	u_long	off_routing_table;
};

struct lan_config {
	u_long	lan_ip;
	u_long	lan_netmask;
};

struct wan_config {
	u_long	wan_ip;
	u_short	wan_q922_addr;
	u_short	wan_pad1;
	u_long	wan_atm_addr;
};

struct sdsl_phy_config {
	u_short	sdsl_data_rate;
	u_char	sdsl_terminal_type;
	u_char	sdsl_quat_orient;
};

struct idsl_phy_config {
	short	idsl_b1_slot;
	short	idsl_b2_slot;
	short	idsl_d_slot;
	u_short	pad;
};

struct rt_entry {
	u_long	rt_dest;
	u_long	rt_mask;
	u_long	rt_type;
	u_long	rt_gw;
};

#define	ROUTE_TYPE_FORME	0x0000
#define	ROUTE_TYPE_LANLOCAL	0x0001
#define	ROUTE_TYPE_LANVIA	0x0002
#define	ROUTE_TYPE_WAN		0x0003
#define	ROUTE_TYPE_DROP		0x0004

#endif	/* HORT_CONFIG_H */
