/***********************************************************/
/*    TYPEDEFS.H                                           */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*                                                         */
/* Notes:  Must be called before any other Brooktree       */
/*         Header files.                                   */
/*                                                         */
/* User Modifiable Code:                                   */
/*    None                                                 */
/*                                                         */
/* List of H files included in this module:                */
/*                                                         */
/* Programer:                                              */
/*     Dean Rasmussen             14-Feb-1997              */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/


/*---------------------------------------------------------*/
/*  COMPILER DIRECTIVES                                    */
/*---------------------------------------------------------*/

/*
 * Bit-pump Compiler Directives
 */
#define TEMP_ENV

#ifdef ZIP_START
#define ZIP_START_EC_BUG
#endif

/* These #defines are not required for the EVM.
 * The customer may wish to define them based on
 * their application 
 */
#if 0
#define BP_MASK_INTERRUPTS
#define NO_INDIRECT_RAM_VARS  /* Avoid the slow indirect bitpump RAM */
#define PRINTF_NOT_SUPPORTED  /* Bypass printf() statements */
#endif


/*
 * Channel Unit Compiler Directives
 * Only supported if CHAN_UNIT is declared
 */
#ifdef CHAN_UNIT

 #define SP_API 
#ifdef SP_API
 #define CU_CUSTOM   /*Uses CU_CUSTOM to initialize*/
#endif /*SP_API*/

 #define MCLK_1024  /* MCLK equals 10.24 MHz */
 #define CU_EOC     /* EOC protocol support  */

 #define CU_2T1
 #define CU_2E1
 #define CU_3E1  

#ifdef ZIP_START    /* need to free ROM for ZipStartup */
 #undef CU_3E1
 #undef CU_CUSTOM
#endif /*ZIP_START*/

#ifdef ZIPSOCKET
 #define CHANNEL_BLOCK
 #define PERF_MONITOR    /* Very Large, may cause address overflow */
 #undef CU_3E1
#else /* EVM */
 #define T1E1_FRAMER     /* define any framer */
 #define BT8370_FRAMER   /* define a specific framer */
 #define CU_LED
#endif /*ZIPSOCKET*/

#ifndef SP_API
 #define BT8360_FRAMER   /* define a specific framer */
 #define BT8510_FRAMER   /* define a specific framer */
 #define BT8069_LIU      /* define a specific LIU */
#endif /*ifndef SP_API*/

#ifdef REPEATER    
/* In the channel unit, the PCM data bypasses the routing
 * performed by rmap[], combine_table[], route_table[] and tmap[].
 * Therefore, the repeater can be easily configured for any
 * line rate.  However, the EVM (with appropriate hardware
 * modifications) supports the default of a 2E1 configuration.
 */
 #undef CU_1T1
 #undef CU_2T1
 #undef CU_1E1
 #undef CU_3E1
 #undef CU_CUSTOM
 #undef CU_LED
 #undef SP_API     /* ROM not available for single rate API commands */
 #undef MCLK_1024  /* MCLK equals HCLK and not 10.24 MHz */
#endif /* REPEATER */

#endif /* CHAN_UNIT */ 

/*
 * Miscellaneous Compiler Directives
 */

#ifdef TDEBUG
/* in house development flag, requires additional files.
 * should not be included by customers.
 */
/* #define DEBUG_MENU */
#endif

/* 
 * This compiler directive provides some hooks for characterization
 * testing.  The code is undocumented and subject to be deleted.
 * This should not be declared by an end customer.
 */
/* #define _CHAR_TESTING */


   /*----------------------------------------------------------*/
   /*>>>   User Modifiable Section typedefs.h.1    Begins   <<<*/
   /*----------------------------------------------------------*/
   /* Modification Description:                                */
   /* Compiler specific type definitions                       */
   /*                                                          */
   /* Reference:                                               */
   /* "Bt8970 Software User's Manual", Section ?.?.?           */
   /*----------------------------------------------------------*/


/* 
 * When porting to other processors/compilers, may need to 'pack' the
 * structures to a 1-byte boundry.  
 *
 * Created BP_PACKED and BP_PACKED2 since don't know where keyword
 * should be placed.  Believe is compiler specific.
 *
 * Not supported by Keil 8032, don't know if works.
 */


/*---------------------------------------------------------*/
/*  TYPEDEFS                                               */
/*---------------------------------------------------------*/
#ifdef C51

typedef bit             BP_BIT;
typedef unsigned char   BP_BIT_FIELD;
typedef char            BP_S_8BIT;
typedef unsigned char   BP_U_8BIT;
typedef short           BP_S_16BIT;
typedef unsigned short  BP_U_16BIT;
typedef long            BP_S_32BIT;
typedef unsigned long   BP_U_32BIT;
typedef short           BP_TABLE;

#define BP_CONSTANT     code
#define BP_VOLATILE     
#define BP_DATA         data
#define BP_IDATA        idata
#define BP_PDATA        pdata
#define BP_XDATA        xdata
#define BP_PACKED 
#define BP_PACKED2 

#else

typedef unsigned char   BP_BIT;
typedef unsigned char   BP_BIT_FIELD;
typedef signed char     BP_S_8BIT;
typedef unsigned char   BP_U_8BIT;
typedef signed short    BP_S_16BIT;
typedef unsigned short  BP_U_16BIT;
typedef signed long     BP_S_32BIT;
typedef unsigned long   BP_U_32BIT;
typedef short           BP_TABLE;

#define BP_CONSTANT     const
#define BP_VOLATILE     volatile
#define BP_DATA        
#define BP_IDATA        
#define BP_PDATA        
#define BP_XDATA        
#define BP_PACKED 
#define BP_PACKED2 

#endif

#define BP_MSPACE       BP_XDATA /* moved variables form internal to external data BP_IDATA */

/* All Application variables set to XDATA since EVM has 16k external RAM */
#define APPL_SW_MSPACE  BP_XDATA


   /*----------------------------------------------------------*/
   /*>>>   User Modifiable Section typedefs.h.1    Ends     <<<*/
   /*----------------------------------------------------------*/

