/*
 * PROGRAM NAME:  Bt8960 Single Board
 *
 * VERSION:       1.0
 *
 * FILENAME:      timer.h
 *
 * FILE CREATED:  June 28, 1996
 *
 * LAST MODIFIED: [8-27-98]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1994
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   
 *
 *
 * FUNCTION LIST:
 *
 */

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

/* Timer status bits */
#define TIMER_STATE         1
#define TIMER_COMPLETE      2
#define TIMER_CONTINUOUS    4


/* The Timers */
#define _NO_GEN_PURPOSE_TIMERS      2

#define PENDING_DEACTIVATE_TIMER    0
#define ONE_SECOND_TIMER            1

/* #define BITPUMP_DEBUG_TIMER         2 */

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

typedef union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD state:1;
        BP_BIT_FIELD complete:1;
        BP_BIT_FIELD continuous:1;
        BP_BIT_FIELD reserved:5;
        } bits;
} GEN_PURPOSE_TIMER_STATUS;

typedef struct
{
    BP_U_16BIT load_value;
    BP_U_32BIT elapsed_counter;
} GEN_PURPOSE_CONT_TIMER;

typedef struct
{
    BP_U_16BIT counter_value;
    GEN_PURPOSE_TIMER_STATUS status;
} GEN_PURPOSE_TIMER;

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/
void _InitGenPurposeTimer(void);
void _EnableGenPurposeTimer(BP_U_8BIT bp, BP_U_8BIT timer, BP_U_16BIT value);
void _ContinuousGenPurposeTimer(BP_U_8BIT bp, BP_U_8BIT timer, BP_U_8BIT state);
void _DisableGenPurposeTimer(BP_U_8BIT bp, BP_U_8BIT timer);
BP_U_8BIT _GetGenPurposeTimerStatus(BP_U_8BIT bp, BP_U_8BIT timer);
BP_U_32BIT _GetGenPurposeContCount(BP_U_8BIT bp, BP_U_8BIT timer);

