/***********************************************************/
/*    DSL_MISC.C                                           */
/*    (C) Copyright 1998 by Rockwell Semiconductor Systems */
/*                                                         */
/*                                                         */
/* Description:                                            */
/*    This is the miscellaneous functions.                 */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*                                                         */
/* List of Functions found in this module:                 */
/*                                                         */
/*    _Sync_Led_Update                                     */
/*    _Cu_Led_Update                                       */
/*    _Bp_Led_Update                                       */
/*                                                         */
/*                                                         */
/* Revision History:                                       */
/*     date/name of reviser                                */
/*                                                         */
/* Aug 98 - New: Dean Rasmussen                            */
/* Oct 98 - New: Laura Yuan                                */
/***********************************************************/
#include "dsl_incl.h"

#ifdef ZIPSOCKET
/*
 * Function: _Sync_Led_Update
 *          
 * Usage:   This function is used to update ZIPSOCKET synchronization LED.
 */
void _Sync_Led_Update (BP_U_8BIT bp, BP_U_8BIT state)
{ 
    switch ( bp )
    {
         case 0:
              dip_sw.zip_bits.sync_1 = state;
              break;
         case 1:
              dip_sw.zip_bits.sync_2 = state;
              break;
    }
}
#endif /* ZIPSOCKET */



#ifdef CU_LED
/*
 * Function: _Cu_Led_Update
 *          
 * Usage:   This function is used to update Channel unit EVM synchronization LED.
 */

void _Cu_Led_Update (BP_U_8BIT bp, BP_U_8BIT state)
{
    if ( bp == 0 )
        {
        cu_led_block[0].bits.in_sync = state; 
        cu_led_block[0].bits.out_of_sync = !state; 
        }
    else if ( bp == 1 )
        {
        cu_led_block[1].bits.in_sync = state; 
        cu_led_block[1].bits.out_of_sync = !state; 
        }
    else
        {
        cu_led_block[2].bits.in_sync = state; 
        cu_led_block[2].bits.out_of_sync = !state; 
        }
}


/*
 * Function: _Bp_Led_Update
 *          
 * Usage:   This function is used to update Channel unit EVM synchronization LED.
 */
void _Bp_Led_Update (BP_U_8BIT bp, BP_U_8BIT state)
{

    if ( bp == 0 )
        {
        cu_bp_led_block[0].bits.bp1_gr = state;
        cu_bp_led_block[0].bits.bp1_rd = !state;
        }
    else if ( bp == 1 )
        {
        cu_bp_led_block[0].bits.bp2_gr = state;
        cu_bp_led_block[0].bits.bp2_rd = !state;
        }
    else
        {
        cu_bp_led_block[1].bits.bp1_gr = state;
        cu_bp_led_block[1].bits.bp1_rd = !state;
        }
}


#endif /* CU_LED */
