/*
 * PROGRAM NAME:  dsl_main.H
 *
 * VERSION:       1.0
 *
 * FILENAME:      dsl_main.h
 *
 * FILE CREATED:  July 16, 1996
 *
 * LAST MODIFIED: [4-19-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1996
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   
 *
 *
 * FUNCTION LIST:
 *
 */


/*---------------------------------------------------------*/
/*  Structure & Typedefs                                   */
/*---------------------------------------------------------*/
typedef struct
{
    BP_BIT_FIELD pc_control:1;
    BP_BIT_FIELD symbol_rate:2;
    BP_BIT_FIELD testmode:3;
    BP_BIT_FIELD undefined:1;
    BP_BIT_FIELD terminal_type:1;
}PORT1_BITS;

#ifdef ZIPSOCKET
typedef struct
{
    BP_BIT_FIELD rxd:1;
    BP_BIT_FIELD txd:1;
    BP_BIT_FIELD int0:1;
    BP_BIT_FIELD int1:1;
    BP_BIT_FIELD t0:1;
    BP_BIT_FIELD hdsl_sdsl:1;
    BP_BIT_FIELD wr:1;
    BP_BIT_FIELD rd:1;
}PORT3_BITS;

typedef struct
{
    BP_BIT_FIELD pc_control:1;      /* This bit is reserved in definition */
    BP_BIT_FIELD t1_e1_mode:1;
    BP_BIT_FIELD test_mode:1;
    BP_BIT_FIELD sync_2:1;
    BP_BIT_FIELD sync_1:1;
    BP_BIT_FIELD alarm:1;
    BP_BIT_FIELD flash_rom:1;
    BP_BIT_FIELD terminal_type:1;
}ZIP_PORT;
#endif/*ZIPSOCKET*/

typedef union
{
    BP_U_8BIT port1;
    PORT1_BITS bits;
#ifdef ZIPSOCKET
    ZIP_PORT zip_bits;
#endif
    ERLE_MODE_BITS erle_bits;
}DIP_SW;
#ifdef ZIPSOCKET
typedef union
{
    BP_U_8BIT reg3;
    PORT3_BITS bits;
}PORT3;
#endif /*ZIPSOCKET*/

typedef union
{
    BP_U_8BIT reg;
    struct    
        {
        BP_U_8BIT api_ready:1; 
        BP_U_8BIT api_result_ready:1;
        BP_U_8BIT nm_update:1;
        BP_U_8BIT completed:1;
        BP_U_8BIT zip_status_ready:1;
        BP_U_8BIT co_check_zip:1;
        BP_U_8BIT slipflag:1;
        BP_U_8BIT reserved:1;
    }bits;
}SYSTEM_FLAGS;

typedef union
{
    BP_U_8BIT reg;
    struct{
        BP_BIT_FIELD present:1;
        BP_BIT_FIELD zip_start_attempt:2;
        BP_BIT_FIELD activation_state:5;
    }bits;
} SYSTEM_STATUS;

typedef union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD system_reset:1;
        BP_BIT_FIELD cu_present:1;
        BP_BIT_FIELD loop_reversal:1;
        BP_BIT_FIELD master_loop:2;
        BP_BIT_FIELD good_loop_cnt:2;
        BP_BIT_FIELD reserved:1;
    }bits;
}DSL_STATUS2;

typedef union
{
    BP_U_8BIT reg;
    struct{
        BP_BIT_FIELD loopback_mode:3;
        BP_BIT_FIELD test_mode:4;
        BP_BIT_FIELD reserved:1;
    }bits;
}DSL_USER_SETUP;

#ifdef ZIP_START
typedef union
{
    BP_U_8BIT reg;
    struct{
        BP_BIT_FIELD enabled:1;
        BP_BIT_FIELD zip_start_state:3;
        BP_BIT_FIELD reserved:4;
    }bits;
} ZIP_SYSTEM_STATUS;
#endif



/*---------------------------------------------------------*/
/*  Global Defines                                         */
/*---------------------------------------------------------*/

#define FOREVER    1


/*
 * System Management
 */
#define SYSTEM_IDLE                 0
#define CONFIGURATION_STATE         1
#define INACTIVE_STATE              2
#define ACTIVATING_STATE            3
#define ACTIVATING_STATE_S1         4
#define ACTIVE_RX_STATE             5
#define ACTIVE_TX_STATE             6
#define GOTO_PID_VALIDATION_STATE   7
#define PID_VALIDATION_STATE        8
#define GOTO_ACTIVE_TX_RX_STATE     9
#define ACTIVE_TX_RX_STATE          10
#define PENDING_DEACTIVATED_STATE   11
#define DEACTIVATED_STATE           12
#define WAIT_FOR_LOST               13
#define WAIT_FOR_LOS                14

#define BACKGROUND_TESTMODE         20
#define ERLE_TESTMODE               21
#define AAGC_TESTMODE               22
#define AAGC2_TESTMODE              23

#define ANALOG_LB_TESTMODE          25
#define ANALOG_LB2_TESTMODE         26

#ifdef DEBUG_MENU
#define PROCESS_MENU                31
#endif



#define ZIP_START_IDLE                  0
#define ZIP_START_VALIDATION_STATE0     1
#define ZIP_START_VALIDATION_STATE1     2
#define ZIP_START_UPDATE_STATE          3
#define ZIP_START_WAIT_STATE            4


#define STAND_ALONE 0
#define PC_CONTROL  1

#define SYNC_ON     1
#define SYNC_OFF    0

#ifdef ZIPSOCKET
#define ALARM_ON    1
#define ALARM_OFF   0
#define TEST_ON     1
#define TEST_OFF    0
#define FLASH_OFF   1
#define T1_MODE     1
#define E1_MODE     0
#endif

#define _6MS_MFRAME         47

#define _NOT_REVERSED   0
#define _REVERSED       1

/*---------------------------------------------------------*/
/*  Global Variables                                       */
/*---------------------------------------------------------*/

extern BP_S_8BIT APPL_SW_MSPACE system_type;

extern SYSTEM_STATUS APPL_SW_MSPACE system_status[_NO_OF_LOOPS];
extern DIP_SW APPL_SW_MSPACE dip_sw;
#ifdef ZIPSOCKET
extern PORT3 APPL_SW_MSPACE port_3;
#endif /*ZIPSOCKET*/
#ifdef TDEBUG
extern BP_U_32BIT APPL_SW_MSPACE startup_count[_NO_OF_LOOPS];
#endif /* TDEBUG */
extern BP_U_32BIT APPL_SW_MSPACE last_count[_NO_OF_LOOPS];

extern SYSTEM_FLAGS APPL_SW_MSPACE system_flags[_NO_OF_LOOPS];
extern BP_U_32BIT APPL_SW_MSPACE timeslot, old_timeslot;
extern DSL_STATUS2 APPL_SW_MSPACE dsl_status2;
extern DSL_USER_SETUP APPL_SW_MSPACE dsl_user_setup;

#ifdef SP_API
extern BP_U_8BIT APPL_SW_MSPACE sngl_loop_api;
extern BP_U_16BIT APPL_SW_MSPACE cust_sym_rate; 
#endif /*SP_API*/



#ifdef ZIP_START
extern ZIP_SYSTEM_STATUS APPL_SW_MSPACE zip_system_status[_NO_OF_LOOPS];
extern BP_U_32BIT APPL_SW_MSPACE zip_count[_NO_OF_LOOPS];
#ifdef HTUC
extern BP_U_8BIT APPL_SW_MSPACE rt_zip_system_status[_NO_OF_LOOPS];
#endif /* HTUC */
#endif


/*---------------------------------------------------------*/
/*  Global Macros                                          */
/*---------------------------------------------------------*/

#ifdef TDEBUG
#define HTU_PREFIX(bp)  \
    printf("%s #%d: ",dip_sw.bits.terminal_type==_HTUC?"HTU-C":"HTU-R",(BP_S_16BIT)(bp+1) )
#endif


/*---------------------------------------------------------*/
/*  Function Protos                                        */
/*---------------------------------------------------------*/
#ifdef DEBUG_MENU
char keypress(char *c);
void display_menu();
void process_menu_option(BP_U_8BIT no, BP_S_8BIT c);
#endif

void _EnableBitpump(BP_U_8BIT bp);
BP_U_8BIT  _ConfigureBitpump(BP_U_8BIT bp);
void _ActivationStateManager(BP_U_8BIT bp);
void _HandleTestModes(BP_U_8BIT bp);
