/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/* Must be called before any other Bt Header Files */
#include "typedefs.h"


/*
 * C51 Header Files
 */
#ifdef C51
#include <reg51.h>
#include "bitpump\init51.h"
#endif


#ifdef TDEBUG
#include <stdio.h>
#include <stdlib.h>
#ifdef ERLE
#include <math.h>
#endif
#endif   /* TDEBUG */


/*
 * Bitpump Header Files
 */
#include "bitpump\btmain.h"     /* _NO_OF_LOOPS */
#include "bitpump\api.h"
#include "bitpump\user.h"
#include "bitpump\bitpump.h"    /* HIGH / LOW */
#include "bitpump\suc.h"        /* all the stage definitions */
#include "bitpump\testmode.h"   /* DIP_SW: ERLE_MODE_BITS */
#include "bitpump\extern.h"

#ifdef ZIP_START
#include "bitpump\zipstart.h"
#endif

#ifdef SER_COM
#include "bitpump\mail.h"
#endif

#ifdef INT_BUG
#include "bitpump\intbug.h"
#endif


#ifdef CHAN_UNIT
/*
 * Channel Unit Header Files
 */


#include "chanunit\cu_api.h"        /* 'cu_api.h' has to before 'cu.h' */

#include "chanunit\cu.h"            /* _CuFlags */
#include "chanunit\frmr_api.h"
#include "chanunit\cu_table.h"
#include "chanunit\cu_asm.h"
#include "chanunit\cu_map.h"
#include "chanunit\cu_loop.h"
#include "chanunit\cu_utils.h"
#include "chanunit\cu_init.h"
#ifdef CU_EOC
#include "chanunit\cu_eoc.h"    /* EOC header file */
#endif /* CU_EOC */
#ifdef PERF_MONITOR
#include "chanunit\cu_perf.h"
#endif /* PERF_MONITOR */
#endif /* CHAN_UNIT */

/*
 * Application Header Files, call after Bitpump/Channel Unit headers
 */
#include "dsl_main.h"
#include "bt_api.h"
#include "timer.h"
#include "dsl_api.h"
#include "dsl_init.h"
#include "dsl_man.h"
#include "dsl_misc.h"
#ifdef ZIP_START
#include "zipvalid.h"
#endif 

