/*
 * PROGRAM NAME:  Bt8970
 *
 * VERSION:       1.0
 *
 * FILENAME:      dsl_api.h
 *
 * FILE CREATED:  July 9, 1996
 *
 * LAST MODIFIED: [4-27-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1996
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   
 *
 *
 * FUNCTION LIST:
 *
 */

/* ------------------------------------- 
 *         System Control APIs 
 * -------------------------------------*/
#define _DSL_SET_ASM_STATE          0x00
#define _DSL_RESET                  0x01
#define _DSL_ASM_ENABLE             0x02

/*      Network management APIs         */
#define _SET_NETMANAGE_STATE        0x10
#define _INTERVAL1_ADDR_LO          0x11
#define _INTERVAL1_ADDR_HI          0x12
#define _INTERVAL2_ADDR             0x13
#define _INTERVAL3_ADDR             0x14

/*          Diagnostic APIs             */
#define _DSL_LOOPBACK               0x20
#define _DSL_TESTMODE               0x21

#define _API_DEST                   0x22
#define _API_OPCODE                 0x23
#define _API_DATA                   0x24
#define _API_SEND                   0x25


/*    FT1/FE1 Configuration APIs        */
#define _CB_TIMESLOT_LOCATION       0x30
#define _CB_TIMESLOT_STATE          0x31
#define _CONFIGURE_CHANNEL_BLOCKING 0x32
#define _SET_ALL_TIMESLOTS          0x33

/*    EOC Compliance APIs        */
#define _EOC_REG_SELECT             0x35 /* Select the reg to modify with 0x36-3A*/
#define _EOC_REG_SIZE               0x36 /* Set the reg_size up to 0x10 (16)*/
#define _EOC_BYTE_NUM_LOC           0x37 /* Select which byte of the reg_size to utilize*/
#define _EOC_WRITE_REG_DATA         0x38 /* Writes data to selected reg*/
#define _EOC_SEND_RD_WR             0x39 /* Sets task bit for an EOC operation*/
#define _EOC_SET_CONTROL            0x3A /* Sets task bit to control slave chanunit */
#define _EOC_ADD_DEST               0x3B /* Sets repeater address when enabled*/

#define _RD_WR_BITS  0x30            /*Only checks the rd and wr bits*/

#define _INSERT_CRC6                0x3C /* Enables CRC error to transmit to far-end*/

/* DSL Single Loop Custom Configuration */

#define _SP_TOTAL_PCM_TSLOT         0x40
#define _SP_TOTAL_HDSL_TSLOT        0x41
#define _SP_USED_TSLOT              0x42
#define _SP_FBIT_PRESENT            0x43
#define _SP_DERIVED_MCLK            0x44
#define _SP_CONFIGURE               0x45

/* -------------------------------------
 *         System Status APIs 
 * -------------------------------------*/
#define _DSL_VERSIONS               0x81
#define _DSL_STATUS                 0x82
#define _DSL_LOOP_STATUS            0x83
#define _DSL_ZIP_STATUS             0x84

#define _SYSTEM_STATUS_FLAG         0x85

/* EOC Status */

#define _EOC_RCVD_NEWDATA_STATUS    0x86
#define _EOC_READ_REG_DATA          0x87
#define _EOC_STATUS                 0x88

#define _DSL_AVAILABLE_SECONDS      0x8E

/*    Network management status APIs    */
#define _CRC_ERR_AT_INTERVAL1       0x90
#define _CRC_ERR_AT_INTERVAL2       0x91
#define _CRC_ERR_AT_INTERVAL3       0x92
#define _FEBE_ERR_AT_INTERVAL1      0x93
#define _FEBE_ERR_AT_INTERVAL2      0x94
#define _FEBE_ERR_AT_INTERVAL3      0x95
#define _LAST_CRC_ERR_INTERVAL1     0x96
#define _LAST_CRC_ERR_INTERVAL2     0x97
#define _LAST_CRC_ERR_INTERVAL3     0x98
#define _LAST_FEBE_ERR_INTERVAL1    0x99
#define _LAST_FEBE_ERR_INTERVAL2    0x9A
#define _LAST_FEBE_ERR_INTERVAL3    0x9B

/*     Diagonistic status APIs          */
#define _DSL_ERLE_RESULTS           0xA0
#define _DSL_AAGC_RESULTS           0xA1
#define _API_RESULT                 0xA2

/*        FT1/FE1 Status APIs           */
#define _CB_TIMESLOT_USAGE          0xA3

/*          DSL Status APIs             */
#define _DSL_FELM                   0xB0
#define _DSL_NMR                    0xB1


/* ------------------------------------- 
 *   System Version Options and Versions
 * -------------------------------------*/
#define _DSL_SW_VERSION  0
#define _DSL_HW_VERSION  1

/* ------------------------------------- 
 *          DSL LoopBack Options
 * -------------------------------------*/
#define _LOOPBACKS_OFF                  0
#define _CU_PCM_ON_PCM                  1
#define _CU_HDSL_ON_PCM                 2
#define _BP_ISOLATED_ANALOG_LOOPBACK    3
#define _BP_EXTERNAL_ANALOG_LOOPBACK    4

/* ------------------------------------- 
 *          DSL TestMode Options
 * -------------------------------------*/
#define _BP_TESTMODE_OFF                0
#define _BP_ISOLATED_PULSE_PLUS3        1
#define _BP_ISOLATED_PULSE_PLUS1        2
#define _BP_ISOLATED_PULSE_MINUS1       3
#define _BP_ISOLATED_PULSE_MINUS3       4
#define _BP_FOUR_LEVEL_SCR              5
#define _BP_TWO_LEVEL_SCR               6
#define _BP_ERLE_TEST                   7 
#define _BP_MEASURE_AAGC                8


/* -------------------------------------    
 *       FT1/E1 Configuration Options         
 * -------------------------------------*/
#define _TIMESLOT_BLOCKED               0
#define _TIMESLOT_IN_USE                1

/* -------------------------------------
 *          Noise Margin Options
 * -------------------------------------*/
#define _LOCAL      0
#define _FAR_END    1

/* -------------------------------------    
 *       ASM State for SetLoopIdle()         
 * -------------------------------------*/
#define DSL_IDLE    5


/*---------------------------------------------------------*/
/*  Function Protos                                        */
/*---------------------------------------------------------*/
BP_U_8BIT _DslStatus(BP_U_8BIT, BP_U_8BIT, BP_U_8BIT, BP_S_8BIT *);
BP_U_8BIT _DslControl(BP_U_8BIT, BP_U_8BIT, BP_U_8BIT);
void _ConfigureSinglePair(BP_U_8BIT loop);
void _SetLoopIdle (BP_U_8BIT loop);

extern BP_U_8BIT APPL_SW_MSPACE total_pcm_tslot, total_hdsl_tslot, num_tslot_used;
extern BP_U_8BIT APPL_SW_MSPACE fbit_present, derived_mclk;
extern BP_U_16BIT APPL_SW_MSPACE MCLK_Freq;

