#ifdef T1E1_FRAMER

/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      frmr_api.h
 *
 * FILE CREATED:  September 8, 1994
 *
 * LAST MODIFIED: [9-2-98]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   Header file for the Framer API.
 *
 * FUNCTION LIST: none
 */

/*****************************************/
/*         FRAMER & LIU OPCODES          */
/*****************************************/

/*
 * Control
 */
#define _LIU_CONFIGURE          0x00
#define _LIU_EQ_SELECT          0x01
#define _LIU_MODE_SELECT        0x02
#define _LIU_LOOP_SELECT        0x03
#define _LIU_CB_SELECT          0x04
#define _LIU_LINE_LOOPBACK      0x05
#define _LIU_LOCAL_LOOPBACK     0x06


#define _FRAMER_CONFIGURE       0x10
#define _FRAMER_TRANSMIT_AIS    0x11
#define _FRAMER_LOOPBACK        0x12
#define _FRAMER_FRAME_FORMAT    0x13
#define _FRAMER_PCM_MODE        0x14
#define _FRAMER_OUTPUT_MODE     0x15


/*
 * Status
 */
#define _LIU_PRESENT            0x80
#define _LIU_STATUS             0x81
#define _FRAMER_PRESENT         0x90
#define _FRAMER_VERSION         0x91

/*
 * LIU Equalizer Select Modes
 */
#define _ELS_T1_0_110       0
#define _ELS_T1_110_220     1
#define _ELS_T1_220_330     2
#define _ELS_T1_330_440     3
#define _ELS_T1_440_550     4
#define _ELS_T1_550_660     5
#define _ELS_E1_PCM30       6

/*
 * Framer Types
 */
#define _BT8510     1
#define _BT8370     2
#define _BT8360     3

/*
 * Framer Loopback Options
 */
#define _FRAMER_LOOPBACK_OFF        0
#define _FRAMER_LINE_PER_CHAN_LB    1
#define _FRAMER_FAR_PER_CHAN_LB     2

#define DISABLE     0
#define ENABLE      1


/*
 * Framer PCM Mode (defines match channel unit rate index)
 */
#define _FRAMER_T1_MODE    0
#define _FRAMER_E1_MODE    1

extern BP_U_8BIT BP_XDATA  _framer_pcm_mode;  /* the header file path is messed up to work with dsl_api.c */

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

BP_U_8BIT _FramerControl(BP_U_8BIT,BP_U_8BIT,BP_U_8BIT);
BP_U_8BIT _FramerStatus(BP_U_8BIT,BP_U_8BIT,BP_U_8BIT,BP_S_8BIT *);

#endif /* T1E1_FRAMER */
