#ifdef T1E1_FRAMER
/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      framer.h
 *
 * FILE CREATED:  June 10, 1994
 *
 * LAST MODIFIED: [10-17-98]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   Header file for the E1/T1 Framers.
 *
 * FUNCTION LIST: none
 */

typedef BP_PACKED struct
{
    BP_BIT_FIELD hardware_rev_number:4;
    BP_BIT_FIELD hardware_part_number:4;
} BP_PACKED2 FRAMER_VERSION;

#ifdef BT8360_FRAMER
#include "fr8360.h"
#endif

#ifdef BT8510_FRAMER
#include "fr8510.h"
#endif

#ifdef BT8370_FRAMER
#include "fr8370.h"
#endif

#ifdef BT8069_LIU

/*************************************************************************/
/*                                                                       */
/*                             LIU STRUCTURES                            */
/*                                                                       */
/*************************************************************************/

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD els:3;
        BP_BIT_FIELD reset:1;
        BP_BIT_FIELD cb:1;
        BP_BIT_FIELD loop:1;
        BP_BIT_FIELD mode:1;
        BP_BIT_FIELD :1;
        } bits;
} BP_PACKED2 LIU_CONTROL;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD esd:4;
        BP_BIT_FIELD bpv:1;
        BP_BIT_FIELD :3;
        } bits;
} BP_PACKED2 LIU_STATUS;

extern LIU_CONTROL BP_XDATA * BP_XDATA liu_control;
extern LIU_STATUS BP_XDATA * BP_XDATA liu_status;
#endif /* BT8069_LIU */


/*
 * Function Prototypes
 */
BP_U_8BIT _CuInitFramer(void);
void _FramerMaskInterrupt(void);

/*
BP_U_8BIT _StartupInitFramer(void);
BP_U_8BIT _ReInitFramer(void);
*/

extern BP_U_8BIT BP_XDATA _FramerType;

#endif /* T1E1_FRAMER */
