
/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      framer.c
 *
 * FILE CREATED:  June 10, 1994
 *
 * LAST MODIFIED: [4-26-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   This file contains the Initializations routines
 *                for the E1 (Bt8510), T1 (Bt8360) and T1/E1-LIU (Bt8370)
 *                Framers.
 *
 * FUNCTION LIST:
 *                _CuInitFramer()
 *                _ReInitFramer()
 */

#include "chanunit.h"



#ifdef T1E1_FRAMER

/*
 * Globals
 */

#ifdef BT8510_FRAMER
FR8510_PTR BP_XDATA * BP_XDATA fr8510_ptr;
FR8510_MODE_PTR BP_XDATA * BP_XDATA fr8510_mode_ptr;
FR8510_RAM_BUFFER_PTR BP_XDATA * BP_XDATA fr8510_ram_buffer_ptr;
FR8510_RAM_BUFFER_MODE_PTR BP_XDATA * BP_XDATA fr8510_ram_buffer_mode_ptr;
#endif /* BT8510_FRAMER */


#ifdef BT8360_FRAMER
FR8360_PTR BP_XDATA * BP_XDATA fr8360_ptr;
FR8360_MODE_PTR BP_XDATA * BP_XDATA fr8360_mode_ptr;
FR8360_RAM_BUFFER_PTR BP_XDATA * BP_XDATA fr8360_ram_buffer_ptr;
#endif /* BT8360_FRAMER */

#ifdef BT8370_FRAMER
FR8370_PTR BP_XDATA * BP_XDATA fr8370_ptr;
FR8370_MODE_PTR BP_XDATA * BP_XDATA fr8370_mode_ptr;
FR8370_RAM_BUFFER_PTR BP_XDATA * BP_XDATA fr8370_ram_buffer_ptr; 
#endif /* BT8370_FRAMER */

BP_U_8BIT BP_XDATA _FramerType;
BP_U_8BIT BP_XDATA _framer_pcm_mode;

/*
 * FUNCTION:   _CuInitFramer
 *
 * PARAMETERS: none
 *
 * PURPOSE:    This function initializes the Framer (8510 or 8360 or 8370)
 *             
 * RETURN:     _PASS (0) - Successfully Completed Operation
 *             _FAIL (1) - An error occured
 *
 * NOTES:      The Transmit AIS is activated during startup.
 *
 * CHANGES:    June 29, 1994    NEW   -   Dean Rasmussen
 */
BP_U_8BIT _CuInitFramer (void)
{
    BP_U_8BIT i;

    switch ( _FramerType )
        {
#ifdef BT8510_FRAMER
        case _BT8510:
            /* disable all interrupts for startup */
            fr8510_ptr->interrupt_control = 0;

            fr8510_ptr->configuration = 0x00;
            fr8510_ptr->framing_control = 0x00; /* use long slip buffer */
            fr8510_ptr->time_slot_16_control = 0xD0;
            fr8510_ptr->control_reg_3 = 0xC0;

            fr8510_ptr->sa_bits_tx[0] = 0xff;           /* sa4 */
            fr8510_ptr->sa_bits_tx[1] = 0xff;           /* sa5 */
            fr8510_ptr->sa_bits_tx[2] = 0xff;           /* sa6 */
            fr8510_ptr->sa_bits_tx[3] = 0xff;           /* sa7 */ 
            fr8510_ptr->sa_bits_tx[4] = 0xff;           /* sa8 */

            for ( i=0 ; i < 16 ; i++ )
                {
                fr8510_ram_buffer_ptr->per_channel_rx[i] = 0x0;
                fr8510_ram_buffer_ptr->per_channel_tx[i] = 0x0;
                }

            /*
             * UnFramed Mode, set Inhibit/Abort Reframing
             */
            if ( _CuFlags._CuFrameFormat == _CU_UNFRAMED_DATA )
                {
                fr8510_mode_ptr->control_reg1.inhibit_abort_reframing = 1;
                }

            break;  /* end 8510 init */
#endif /* BT8510_FRAMER */

#ifdef BT8360_FRAMER
        case _BT8360:
            fr8360_ptr->configuration = 0xD;
            fr8360_ptr->clock_control = 0xB0;
            fr8360_ptr->frame_bit_loopback_control = 0x7;
            fr8360_ptr->signaling_control = 0x0;
            fr8360_ptr->framing_control = 0x10;
            fr8360_ptr->slip_buffer_control = 0x80;
            fr8360_ptr->alarm_signal_control = 0x0;
            fr8360_ptr->alarm_timing_interrupt  = 0x0;
            fr8360_ptr->error_counter_interrupt  = 0x0;
            fr8360_ptr->transmit_data_link = 0x0;
            fr8360_ptr->receive_data_link = 0x0;
            fr8360_ptr->lb_detection = 0x0;
            fr8360_ptr->lb_code_generation = 0x0;
            fr8360_ptr->lb_activate_code = 0x0;
            fr8360_ptr->lb_deactivate_code = 0x0;

            fr8360_ram_buffer_ptr->rate_convertor[0] = 0x00;

            for ( i=1 ; i <= 24 ; i++)
                {
                fr8360_ram_buffer_ptr->rate_convertor[i] = 0x01;
                }
            
            for ( i=25 ; i < 32 ; i++)
                {
                fr8360_ram_buffer_ptr->rate_convertor[i] = 0x00;
                }

            for ( i=0 ; i < 24 ; i++)
                {
                fr8360_ram_buffer_ptr->tx_pcm_control[i] = 0x00;
                fr8360_ram_buffer_ptr->rx_pcm_control[i] = 0x00;
                }

            /* Transmit PCM buffer (0x160 to 0x17F) : set to 0x00 */
            for ( i=0 ; i < 32 ; i++)
                {
                fr8360_ram_buffer_ptr->tx_rx_pcm_buffer[i] = 0x00;
                }

            /*
             * UnFramed Mode, disable ESF Mode
             */
            if ( _CuFlags._CuFrameFormat == _CU_UNFRAMED_DATA )
                {
                fr8360_mode_ptr->configuration.enable_esf_mode = 0;
                }

            break;  /* end 8360 init */
#endif /* BT8360_FRAMER */


#ifdef BT8370_FRAMER
        case _BT8370:
    
            /* Generic Registers for E1 and T1 */
/*Required for 8370 init*/                
            fr8370_ptr->lb_conf_reg = 0x00;                 /*  014  */
            fr8370_ptr->primary_ctrl_reg = 0x80;            /*  001  */
/*Required for 8370 init*/                
            fr8370_ptr->jitter_attenuator_conf = 0x04;      /*  002  */
            fr8370_ptr->count_ovrfl_int_en_reg = 0x00;      /*  00F  */
            fr8370_ptr->timer_int_en_reg = 0x00;            /*  010  */
            fr8370_ptr->dlink_1_int_en_reg = 0x00;          /*  011  */
            fr8370_ptr->dlink_2_int_en_reg = 0x00;          /*  012  */
            fr8370_ptr->lb_conf_reg = 0x00;                 /*  014  */
            fr8370_ptr->ext_dlink_ts = 0x00;                /*  015  */
            fr8370_ptr->ext_dlink_bit = 0xff;               /*  016  */
            fr8370_ptr->program_input_output = 0xfe;        /*  018  */
            fr8370_ptr->program_output_en = 0x3a;           /*  019  */
            fr8370_ptr->clock_input_mux = 0x04;             /*  01A  */
            fr8370_ptr->test_mux_conf = 0x00;               /*  01B  */
            fr8370_ptr->test_conf = 0x00;                   /*  01C  */
            fr8370_ptr->rpll_low_pass_filter = 0x33;        /*  023  */
            fr8370_ptr->variable_gain_amp_max = 0x1d;       /*  024  */
            fr8370_ptr->eq_coeff_dt_reg = 0xfa;             /*  025  */
            fr8370_ptr->eq_coeff_table_ptr = 0x07;          /*  026  */
            fr8370_ptr->dt_slicer_threshold = 0xfa;         /*  027  */       
            fr8370_ptr->clock_slicer_threshold = 0x4c;      /*  028  */
            fr8370_ptr->pre_eq = 0xa6;                      /*  02A  */
            fr8370_ptr->rec_lb_code_det_conf = 0x00;        /*  042  */
            fr8370_ptr->rec_alm_signal_conf = 0x00;         /*  045  */
            fr8370_ptr->alm_err_count_latch_conf = 0x07;    /*  046  */
            fr8370_ptr->tran_err_insert = 0x00;             /*  073  */
            fr8370_ptr->tran_man_sa_bt_febe_conf = 0x00;    /*  074  */
            fr8370_ptr->tran_alm_signal_conf = 0x00;        /*  075  */
            fr8370_ptr->tran_test_pat_conf = 0x00;          /*  076  */
            fr8370_ptr->tran_inband_lb_code_conf = 0x00;    /*  077  */
            fr8370_ptr->tran_sa4_byte_buffer = 0xff;        /*  07B  */
            fr8370_ptr->tran_sa5_byte_buffer = 0xff;        /*  07C  */
            fr8370_ptr->tran_sa6_byte_buffer = 0xff;        /*  07D  */
            fr8370_ptr->tran_sa7_byte_buffer = 0xff;        /*  07E  */
            fr8370_ptr->tran_sa8_byte_buffer = 0xff;        /*  07F  */
            fr8370_ptr->clad_phase_det_scale_factor = 0x00; /*  092  */
            fr8370_ptr->clad_test =00;                      /*  093  */
            fr8370_ptr->bit_orient_protocol_tx =00;         /*  0A0  */
            fr8370_ptr->tran_bop_codeword = 0x00;           /*  0A1  */
            fr8370_ptr->dl1_bit_en = 0x00;                  /*  0A5  */
            fr8370_ptr->performance_report_mess=00;         /*  0AA  */
            fr8370_ptr->tdl1_end_of_mess_ctrl =0xff;        /*  0AC  */
            fr8370_ptr->tran_dlink_fifo = 0xff;             /*  0AD  */
            fr8370_ptr->dl2_ts_en = 0x00;                   /*  0AF  */
            fr8370_ptr->dl2_bit_en=00;                      /*  0B0  */
            fr8370_ptr->dl2_ctrl=00;                        /*  0B1  */
            fr8370_ptr->rdl2_fifo_fill_ctrl=00;             /*  0B2  */
            fr8370_ptr->tdl2_fifo_empty_ctrl=00;            /*  0B6  */
            fr8370_ptr->tdl2_end_of_mess_ctrl = 0xff;       /*  0B7  */
            fr8370_ptr->tran_dlink_fifo2 = 0xff;            /*  0B8  */
            fr8370_ptr->dlink_test_conf1 =00;               /*  0BA  */
            fr8370_ptr->dlink_test_status2 = 00;            /*  0BB  */
            fr8370_ptr->dlink_test_status3 = 00;            /*  0BC  */
            fr8370_ptr->dlink_test_control1 = 00;           /*  0BD  */
            fr8370_ptr->dlink_test_control2 = 00;           /*  0BE  */
            fr8370_ptr->rec_sys_bus_conf = 0x82;            /*  0D1  */
            fr8370_ptr->rsb_sync_bit_offset = 0x00;         /*  0D2  */
            fr8370_ptr->rsb_sync_ts_offset = 0x00;          /*  0D3  */
            fr8370_ptr->tran_sys_bus_conf = 0x82;           /*  0D4  */
            fr8370_ptr->tsb_sync_bit_offset = 0x00;         /*  0D5  */
            fr8370_ptr->tsb_sync_ts_offset = 0x00;          /*  0D6  */
            fr8370_ptr->rsync_frame_offset = 0x00;      /*  0D8  */
            fr8370_ptr->rec_sig_conf = 0x01;                /*  0D7  */


            /*   T1 ram    */
            for ( i=1 ; i <= 24; i++)  
                {
                fr8370_ram_buffer_ptr->sys_bus_per_chan_ctrl[i] = 0x01;
                }

               
            /* RAM Buffer Information */            
            fr8370_ram_buffer_ptr->sys_bus_per_chan_ctrl[0]= 0x00;    /*  0E0  */

            for ( i=25 ; i <= 31; i++)  /* For F9-100 SBC */
                {
                fr8370_ram_buffer_ptr->sys_bus_per_chan_ctrl[i] = 0x00; 
                }

            for ( i=0 ; i <= 31; i++)  /* For F9-100 SBC */
                {
                fr8370_ram_buffer_ptr->tran_per_chan_ctrl[i] = 0x00;
                fr8370_ram_buffer_ptr->tran_sig_buff[i] = 0x00; 
                fr8370_ram_buffer_ptr->tran_pcm_slip_buff_lo[i] = 0x00; 
                fr8370_ram_buffer_ptr->tran_pcm_slip_buff_hi[i] = 0x00; 
                fr8370_ram_buffer_ptr->rec_per_chan_ctrl[i] = 0x00; 
                fr8370_ram_buffer_ptr->rec_sig_buff[i] = 0x00; 
                fr8370_ram_buffer_ptr->rec_pcm_slip_bufflo[i] = 0x00; 
                fr8370_ram_buffer_ptr->rec_pcm_slip_buffhi[i] = 0x00; 
                }
   
            if ( _framer_pcm_mode == _FRAMER_T1_MODE )
                {

#ifdef CU_LED
                /* Set the terminal impendance to 100 ohms */
                misc_term.bits.framer_term = TERM_100;    
                set_LED_block(_MISC_TERM, _CU_LED_BLOCK_SET, misc_term.reg);
#endif /* CU_LED */

                /* T1 Specific */
                fr8370_ptr->primary_ctrl_reg = 0x19;           /*  001  */
                fr8370_ptr->alm_1_int_en_reg = 0x00;           /*  00C  */
                fr8370_ptr->alm_2_int_en_reg = 0x00;           /*  00D  */
                fr8370_ptr->err_int_en_reg = 0x00;             /*  00E  */
                fr8370_ptr->pat_int_en_reg = 0x00;             /*  013  */
                fr8370_ptr->liu_conf = 0x01;                   /*  020  */
                fr8370_ptr->rec_liu_conf = 0x77;               /*  022  */
                fr8370_ptr->recr_conf = 0x03;                  /*  040  */
                fr8370_ptr->rec_test_pat_conf = 0x3e;          /*  041  */
                fr8370_ptr->lb_active_code_pat = 0xfe;         /*  043  */                            
                fr8370_ptr->lb_deactive_code_pat = 0xfe;       /*  044  */
                fr8370_ptr->tran_liu_conf = 0x4e;              /*  068  */
                fr8370_ptr->tran_pulse_shape_conf[0] = 0x1d;   /*  060  */
                fr8370_ptr->tran_pulse_shape_conf[1] = 0x1d;   /*  061  */
                fr8370_ptr->tran_pulse_shape_conf[2] = 0x1d;   /*  062  */
                fr8370_ptr->tran_pulse_shape_conf[3] = 0x1d;   /*  063  */
                fr8370_ptr->tran_pulse_shape_conf[4] = 0x04;   /*  064  */
                fr8370_ptr->tran_pulse_shape_conf[5] = 0x07;   /*  065  */
                fr8370_ptr->tran_pulse_shape_conf[6] = 0x04;   /*  066  */
                fr8370_ptr->tran_pulse_shape_conf[7] = 0x01;   /*  067  */
                fr8370_ptr->tran_framer_conf = 0x0d;           /*  070  */ 
                fr8370_ptr->transmiter_conf = 0x45;            /*  071  */
                fr8370_ptr->tran_frame_format = 0x00;          /*  072  */
                fr8370_ptr->tran_inband_lb_code_pat = 0xfe;    /*  078  */
                fr8370_ptr->clock_rate_adaptor_conf = 0x85;    /*  090  */
                fr8370_ptr->clad_frequency_select = 0x55;      /*  091  */
                fr8370_ptr->dl1_ts_en = 0x40;                  /*  0A4  */
                fr8370_ptr->dl1_ctrl = 0x00;                   /*  0A6  */
                fr8370_ptr->rdl1_fifo_fill_ctrl = 0x0a;        /*  0A7  */
                fr8370_ptr->tdl1_fifo_empty_ctrl = 0x0a;       /*  0AB  */
                fr8370_ptr->sys_bus_interface_conf = 0x47;     /*  0D0  */
                fr8370_ptr->rec_sig_conf = 0x01;               /*  0D7  */
                }
            else
                {
#ifdef CU_LED
                /* Set the terminal impendance to 75 ohms */
                misc_term.bits.framer_term = TERM_75;    
                set_LED_block(_MISC_TERM, _CU_LED_BLOCK_SET, misc_term.reg);
#endif /* CU_LED */

                /* E1 Specific */
                fr8370_ptr->primary_ctrl_reg = 0x00;           /*  001  */
                fr8370_ptr->alm_1_int_en_reg = 0x00;           /*  00C  */
                fr8370_ptr->alm_2_int_en_reg = 0x00;           /*  00D  */
                fr8370_ptr->err_int_en_reg = 0x00;             /*  00E  */
                fr8370_ptr->pat_int_en_reg = 0x00;             /*  013  */
                fr8370_ptr->liu_conf = 0x01;                   /*  020  */
                fr8370_ptr->rec_liu_conf = 0x77;               /*  022  */
                fr8370_ptr->recr_conf = 0x19;                  /*  040  */
                fr8370_ptr->rec_test_pat_conf = 0x39;          /*  041  */
                fr8370_ptr->lb_active_code_pat = 0x08;         /*  043  */                            
                fr8370_ptr->lb_deactive_code_pat = 0x24;       /*  044  */
                fr8370_ptr->tran_liu_conf = 0x4c;              /*  068  */
                fr8370_ptr->tran_pulse_shape_conf[0] = 0x18;   /*  060  */
                fr8370_ptr->tran_pulse_shape_conf[1] = 0x18;   /*  061  */
                fr8370_ptr->tran_pulse_shape_conf[2] = 0x18;   /*  062  */
                fr8370_ptr->tran_pulse_shape_conf[3] = 0x18;   /*  063  */
                fr8370_ptr->tran_pulse_shape_conf[4] = 0;      /*  064  */
                fr8370_ptr->tran_pulse_shape_conf[5] = 0;      /*  065  */
                fr8370_ptr->tran_pulse_shape_conf[6] = 0;      /*  066  */
                fr8370_ptr->tran_pulse_shape_conf[7] = 0;      /*  067  */
                fr8370_ptr->tran_framer_conf = 0x04;           /*  070  */ 
                fr8370_ptr->transmiter_conf = 0x51;            /*  071  */
                fr8370_ptr->tran_frame_format = 0x00;          /*  072  */
                fr8370_ptr->tran_inband_lb_code_pat = 0x7a;    /*  078  */
                fr8370_ptr->clock_rate_adaptor_conf = 0x88;    /*  090  */
                fr8370_ptr->clad_frequency_select = 0x11;      /*  091  */
                fr8370_ptr->dl1_ts_en = 0x00;                  /*  0A4  */
                fr8370_ptr->dl1_ctrl = 0x00;                   /*  0A6  */
                fr8370_ptr->rdl1_fifo_fill_ctrl =0x00 ;        /*  0A7  */
                fr8370_ptr->tdl1_fifo_empty_ctrl = 0x00;       /*  0AB  */

                fr8370_ram_buffer_ptr->sys_bus_per_chan_ctrl[0] = 0x01;

                fr8370_ptr->sys_bus_interface_conf = 0x46;     /*  0D0  */
                fr8370_ptr->rec_sig_conf = 0x01;               /*  0D7  */


                /*   E1 needs SBC25-32 and TPC0 to be 0x01    */
                for ( i=25 ; i <= 32; i++)  /* For F9-100 SBC */
                    {
                    fr8370_ram_buffer_ptr->sys_bus_per_chan_ctrl[i] = 0x01;   
                    }

                }

         break;  /* end 8370 init */
#endif /* BT8370_FRAMER */



        default:
            return _FAIL;

        }   /* end switch */

    return _PASS;
}



/*
 * FUNCTION:   _FramerMaskInterrupt
 *
 * PARAMETERS: none
 *
 * PURPOSE:    This function masks the Framer Interrupts.
 *
 *             Blindly write the registers, if different device is present
 *             then more registers will get set to 0.  However, the registers
 *             will get properly initialized later.
 *
 * RETURN:     nothing
 *
 * NOTES:      
 *
 * CHANGES:    September 14, 1998    NEW   -   Dean Rasmussen
 */
void _FramerMaskInterrupt (void)
{

#ifdef BT8510_FRAMER
    fr8510_ptr->interrupt_control = 0;
#endif

#ifdef BT8360_FRAMER
    fr8360_ptr->alarm_timing_interrupt  = 0x0;
    fr8360_ptr->error_counter_interrupt  = 0x0;
#endif

#ifdef BT8370_FRAMER
    fr8370_ptr->alm_1_int_en_reg = 0x00;            /*  00C  */
    fr8370_ptr->alm_2_int_en_reg = 0x00;            /*  00D  */
    fr8370_ptr->err_int_en_reg = 0x00;              /*  00E  */
    fr8370_ptr->count_ovrfl_int_en_reg = 0x00;      /*  00F  */
    fr8370_ptr->timer_int_en_reg = 0x00;            /*  010  */
    fr8370_ptr->dlink_1_int_en_reg = 0x00;          /*  011  */
    fr8370_ptr->dlink_2_int_en_reg = 0x00;          /*  012  */
    fr8370_ptr->pat_int_en_reg = 0x00;              /*  013  */
#endif /* BT8370_FRAMER */

    return ;
}

#endif /* T1E1_FRAMER */
/*#endif CHAN_UNIT */
