#ifdef T1E1_FRAMER


#ifdef BT8510_FRAMER

/* still need to add BIT_REVERSE support */

/*
 * BT8510 Framer Structures
 */

typedef BP_PACKED struct
{
    BP_BIT_FIELD clock_recovery_enable:1;
    BP_BIT_FIELD insert_crc:1;
    BP_BIT_FIELD insert_framing:1;
    BP_BIT_FIELD febe_enable:1;
    BP_BIT_FIELD transmit_ais:1;
    BP_BIT_FIELD enable_ami_line_code:1;
    BP_BIT_FIELD transmit_receive_clock:1;
    BP_BIT_FIELD receive_to_transmit_loopback:1;
} BP_PACKED2 FR8510_CONTROL_REG0;

typedef BP_PACKED struct
{
    BP_BIT_FIELD alternate_cas_mframe_align:1;
    BP_BIT_FIELD inhibit_abort_reframing:1;
    BP_BIT_FIELD force_reframing_operation:1;
    BP_BIT_FIELD slip_buffer_short_delay_mode:1;
    BP_BIT_FIELD bit_slip_enable:1;
    BP_BIT_FIELD ccs_enable:1;
    BP_BIT_FIELD cas_enable:1;
    BP_BIT_FIELD lapd_formatting_enabled:1;
} BP_PACKED2 FR8510_CONTROL_REG1;

typedef BP_PACKED union
{
    struct {
        BP_BIT_FIELD insert_framing:1;
        BP_BIT_FIELD signaling_freeze_enable:1;
        BP_BIT_FIELD freeze_signal:1;
        BP_BIT_FIELD transmit_ais:1;
        BP_BIT_FIELD x1_bit:1;
        BP_BIT_FIELD transmit_mf_rai:1;
        BP_BIT_FIELD x3_bit:1;
        BP_BIT_FIELD x4_bit:1;
        } cas_ccs_mode;

    struct {
        BP_BIT_FIELD transmit_idle:1;
        BP_BIT_FIELD transmit_fcs:1;
        BP_BIT_FIELD abort_message:1;
        BP_BIT_FIELD transmit_ais:1;
        BP_BIT_FIELD bytes_0:1;
        BP_BIT_FIELD bytes_1:1;
        BP_BIT_FIELD bytes_2:1;
        BP_BIT_FIELD bytes_3:1;
        } lapd_mode;
} BP_PACKED2 FR8510_CONTROL_REG2;


typedef BP_PACKED struct
{
    BP_BIT_FIELD analog_enable:1;
    BP_BIT_FIELD ext_signaling_insertion_enable:1;
    BP_BIT_FIELD line_loopback:1;
    BP_BIT_FIELD local_loopback:1;
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD tx_remote_alarm_indication:1;
    BP_BIT_FIELD si_0:1;
    BP_BIT_FIELD si_1:1;
} BP_PACKED2 FR8510_CONTROL_REG3;

typedef BP_PACKED struct
{
    BP_BIT_FIELD rcv_cas_mf:1;
    BP_BIT_FIELD rcv_crc_mf:1;
    BP_BIT_FIELD tx_crc_mf:1;
    BP_BIT_FIELD rcv_oof:1;
    BP_BIT_FIELD lapd:1;
    BP_BIT_FIELD fas:1;
    BP_BIT_FIELD crc:1;
    BP_BIT_FIELD bpv:1;
} BP_PACKED2 FR8510_INTERRUPT_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD loss_of_signal:1;
    BP_BIT_FIELD crc_failure:1;
    BP_BIT_FIELD ais_signal_detect:1;
    BP_BIT_FIELD hdb3_signature_detect:1;
    BP_BIT_FIELD in_frame:1;
    BP_BIT_FIELD fas_error:1;
    BP_BIT_FIELD line_code_violation:1;
    BP_BIT_FIELD in_crc_frame:1;
} BP_PACKED2 FR8510_STATUS_0;

typedef BP_PACKED struct
{
    BP_BIT_FIELD bit_slip:1;
    BP_BIT_FIELD frame_search_1_ms:1;
    BP_BIT_FIELD uncontrolled_slip:1;
    BP_BIT_FIELD loss_of_frame_alignment:1;
    BP_BIT_FIELD change_of_frame_alignment:1;
    BP_BIT_FIELD pcm_controlled_frame_slip:1;
    BP_BIT_FIELD two_ms_transmit_clock:1;
    BP_BIT_FIELD two_ms_receive_clock:1;
} BP_PACKED2 FR8510_STATUS_1;

typedef BP_PACKED union
{
    struct
        {
        BP_BIT_FIELD in_cas_multiframe:1;
        BP_BIT_FIELD change_of_mf_alignment:1;
        BP_BIT_FIELD signaling_freeze_set:1;
        BP_BIT_FIELD ais_detect:1;
        BP_BIT_FIELD x1_bit:1;
        BP_BIT_FIELD mf_rai:1;
        BP_BIT_FIELD x3_bit:1;
        BP_BIT_FIELD x4_bit:1;
        } cas_ccs_mode;

    struct
        {
        BP_BIT_FIELD idle_code_received:1;
        BP_BIT_FIELD bad_fcs:1;
        BP_BIT_FIELD abort_flag_received:1;
        BP_BIT_FIELD ais_detect:1;
        BP_BIT_FIELD bytes_0:1;
        BP_BIT_FIELD bytes_1:1;
        BP_BIT_FIELD bytes_2:1;
        BP_BIT_FIELD bytes_3:1;
        } lapd_mode;
} BP_PACKED2 FR8510_STATUS_2;


typedef BP_PACKED struct
{
    BP_BIT_FIELD fas_error_cntr_overflow:1;
    BP_BIT_FIELD crc_error_cntr_overflow:1;
    BP_BIT_FIELD bpv_cntr_overflow:1;
    BP_BIT_FIELD unused:2;
    BP_BIT_FIELD remote_alarm_indication:1;
    BP_BIT_FIELD si_0:1;
    BP_BIT_FIELD si_1:1;
} BP_PACKED2 FR8510_STATUS_3;

typedef BP_PACKED struct
{                                               /* Addr (hex) */
    /***********/
    /* Control */
    /***********/
    FR8510_CONTROL_REG0 control_reg0;           /*     00     */
    FR8510_CONTROL_REG1 control_reg1;           /*     01     */
    FR8510_CONTROL_REG2 control_reg2;           /*     02     */
    FR8510_CONTROL_REG3 control_reg3;           /*     03     */
    BP_U_8BIT sa_bits_tx[5];                    /*  04 -- 08  */
    BP_U_8BIT reserved_a[6];                    /*  09 -- 0E  */
    FR8510_INTERRUPT_REG interrupt_control;     /*     0F     */

    /**********/
    /* Status */
    /**********/
    FR8510_STATUS_0 status_0;                   /*     10     */
    FR8510_STATUS_1 status_1;                   /*     11     */
    FR8510_STATUS_2 status_2;                   /*     12     */
    FR8510_STATUS_3 status_3;                   /*     13     */
    BP_U_8BIT sa_bits_rx[5];                    /*  14 -- 18  */
    FRAMER_VERSION version;                     /*     19     */
    BP_U_8BIT reserved_b[2];                    /*  1A -- 1B  */
    BP_U_8BIT bipolar_violation_cntr;           /*     1C     */
    BP_U_8BIT crc4_error_cntr;                  /*     1D     */
    BP_U_8BIT frame_align_error_cntr;           /*     1E     */
    FR8510_INTERRUPT_REG interrupt_status;      /*     1F     */
} BP_PACKED2 FR8510_MODE_PTR;


typedef BP_PACKED struct
{                                               /* Addr (hex) */
    /***********/
    /* Control */
    /***********/
    BP_U_8BIT configuration;                /*     00     */
    BP_U_8BIT framing_control;              /*     01     */
    BP_U_8BIT time_slot_16_control;         /*     02     */
    BP_U_8BIT control_reg_3;                /*     03     */
    BP_U_8BIT sa_bits_tx[5];                /*  04 -- 08  */
    BP_U_8BIT reserved_a[6];                /*  09 -- 0E  */
    BP_U_8BIT interrupt_control;            /*     0F     */

    /**********/
    /* Status */
    /**********/
    BP_U_8BIT status_0;                     /*     10     */
    BP_U_8BIT status_1;                     /*     11     */
    BP_U_8BIT status_2;                     /*     12     */
    BP_U_8BIT status_3;                     /*     13     */
    BP_U_8BIT sa_bits_rx[5];                /*  14 -- 18  */
    BP_U_8BIT version;                      /*     19     */
    BP_U_8BIT reserved_b[2];                /*  1A -- 1B  */
    BP_U_8BIT bipolar_violation_cntr;       /*     1C     */
    BP_U_8BIT crc4_error_cntr;              /*     1D     */
    BP_U_8BIT frame_align_error_cntr;       /*     1E     */
    BP_U_8BIT interrupt_status;             /*     1F     */
} BP_PACKED2 FR8510_PTR;


/*********************************/
/* Per-Channel Control Registers */
/*              or               */
/*       RAM Buffer Memory       */
/*********************************/
typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_ds0_loopback_n:1;
    BP_BIT_FIELD insert_idle_code_n:1;
    BP_BIT_FIELD insert_signaling:1;
    BP_BIT_FIELD loopback_signaling:1;
    BP_BIT_FIELD enable_ds0_loopback_n16:1;
    BP_BIT_FIELD insert_idle_code_n16:1;
    BP_BIT_FIELD indicate_time_slot_n:1;
    BP_BIT_FIELD indicate_time_slot_n16:1;
} BP_PACKED2 PER_CHANNEL_CONTROL_REG;

typedef BP_PACKED struct
{
    PER_CHANNEL_CONTROL_REG per_channel_rx[16];     /*  00 -- 0F  */
    PER_CHANNEL_CONTROL_REG per_channel_tx[16];     /*  10 -- 1F  */
    BP_U_8BIT rx_idle_codes[32];                    /*  20 -- 3F  */
    BP_U_8BIT rx_data_buffer[64];                   /*  40 -- 7F  */
    BP_U_8BIT rx_ts16_buffer[32];                   /*  80 -- 9F  */
    BP_U_8BIT tx_idle_codes[32];                    /*  A0 -- BF  */
    BP_U_8BIT tx_data_buffer[32];                   /*  C0 -- DF  */
    BP_U_8BIT rx_signaling_buffer[16];              /*  E0 -- EF  */
    BP_U_8BIT tx_ts16_buffer[16];                   /*  F0 -- FF  */
} BP_PACKED2 FR8510_RAM_BUFFER_MODE_PTR;

typedef BP_PACKED struct
{
    BP_U_8BIT per_channel_rx[16];                   /*  00 -- 0F  */
    BP_U_8BIT per_channel_tx[16];                   /*  10 -- 1F  */
    BP_U_8BIT rx_idle_codes[32];                    /*  20 -- 3F  */
    BP_U_8BIT rx_data_buffer[64];                   /*  40 -- 7F  */
    BP_U_8BIT rx_ts16_buffer[32];                   /*  80 -- 9F  */
    BP_U_8BIT tx_idle_codes[32];                    /*  A0 -- BF  */
    BP_U_8BIT tx_data_buffer[32];                   /*  C0 -- DF  */
    BP_U_8BIT rx_signaling_buffer[16];              /*  E0 -- EF  */
    BP_U_8BIT tx_ts16_buffer[16];                   /*  F0 -- FF  */
} BP_PACKED2 FR8510_RAM_BUFFER_PTR;

extern FR8510_PTR BP_XDATA * BP_XDATA fr8510_ptr;
extern FR8510_MODE_PTR BP_XDATA * BP_XDATA fr8510_mode_ptr;

extern FR8510_RAM_BUFFER_PTR BP_XDATA * BP_XDATA fr8510_ram_buffer_ptr;

#endif /* BT8510_FRAMER */
#endif /* T1E1_FRAMER */

