#ifdef T1E1_FRAMER


#ifdef BT8370_FRAMER

/*
 * BT8370 Framer Structures
 */

#ifdef BIT_REVERSE

typedef BP_PACKED struct
{
    BP_BIT_FIELD reset:1;
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD rframe:4;
    BP_BIT_FIELD t1_e1:1;
} BP_PACKED2 FR8370_PRIMARY_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD jen:1;
    BP_BIT_FIELD jfree:1;
    BP_BIT_FIELD jdir:1;
    BP_BIT_FIELD jauto:1;
    BP_BIT_FIELD jcenter:1;
    BP_BIT_FIELD jsize:3;
} BP_PACKED2 FR8370_JITTER_ATTEN_CONF;

typedef BP_PACKED struct
{
    BP_BIT_FIELD alm1:1;
    BP_BIT_FIELD alm2:1;
    BP_BIT_FIELD error:1;
    BP_BIT_FIELD count:1;
    BP_BIT_FIELD timer:1;
    BP_BIT_FIELD dl1:1;
    BP_BIT_FIELD dl2:1;
    BP_BIT_FIELD patt:1;
} BP_PACKED2 FR8370_INT_REQ_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD rmyel:1;
    BP_BIT_FIELD ryel:1;
    BP_BIT_FIELD rpdv:1;
    BP_BIT_FIELD rais:1;
    BP_BIT_FIELD ralos:1;
    BP_BIT_FIELD rlos:1;
    BP_BIT_FIELD rlof:1;
    BP_BIT_FIELD sigfrz:1;
} BP_PACKED2 FR8370_ALARM_1_INT_STATUS;
                                                 
typedef BP_PACKED struct
{
    BP_BIT_FIELD loopdn:1;
    BP_BIT_FIELD loopup:1;
    BP_BIT_FIELD tpdv:1;  
    BP_BIT_FIELD tshort:1;
    BP_BIT_FIELD tloc:1;
    BP_BIT_FIELD tlos:1;
    BP_BIT_FIELD tlof:1;
    BP_BIT_FIELD onesec:1;
} BP_PACKED2 FR8370_ALARM_2_INT_STATUS;


typedef BP_PACKED struct
{
    BP_BIT_FIELD tslip:1;
    BP_BIT_FIELD rslip:1;
    BP_BIT_FIELD ckerr:1;
    BP_BIT_FIELD jerr:1;
    BP_BIT_FIELD cerr:1;
    BP_BIT_FIELD serr:1;
    BP_BIT_FIELD merr:1;
    BP_BIT_FIELD ferr:1;
} BP_PACKED2 FR8370_ERROR_INT_STATUS;

typedef BP_PACKED struct
{
    BP_BIT_FIELD rlof:1;
    BP_BIT_FIELD cofa:1;
    BP_BIT_FIELD sef:1;
    BP_BIT_FIELD berr:1;
    BP_BIT_FIELD febe:1;
    BP_BIT_FIELD lcv:1;
    BP_BIT_FIELD crc:1;
    BP_BIT_FIELD ferr:1;
} BP_PACKED2 FR8370_COUNT_OVRFL_INT_STATUS;

typedef BP_PACKED struct
{
    BP_BIT_FIELD tsig:1;
    BP_BIT_FIELD tmsync:1;
    BP_BIT_FIELD tmf:1;
    BP_BIT_FIELD tframe:1;
    BP_BIT_FIELD rsig:1;
    BP_BIT_FIELD rmsync:1;
    BP_BIT_FIELD rmf:1;
    BP_BIT_FIELD rframe:1;
} BP_PACKED2 FR8370_TIMER_INT_STATUS;

typedef BP_PACKED struct
{
    BP_BIT_FIELD rmyel:1;
    BP_BIT_FIELD ryel:1;
    BP_BIT_FIELD rpdv:1;
    BP_BIT_FIELD rais:1;
    BP_BIT_FIELD ralos:1;
    BP_BIT_FIELD rlos:1;
    BP_BIT_FIELD rlof:1;
    BP_BIT_FIELD sigfrz:1;
} BP_PACKED2 FR8370_ALARM_1_INT_ENABLE_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD loopdn:1;
    BP_BIT_FIELD loopup:1;
    BP_BIT_FIELD tpdv:1;
    BP_BIT_FIELD tshort:1;
    BP_BIT_FIELD tloc:1;
    BP_BIT_FIELD tlos:1;
    BP_BIT_FIELD tlof:1;
    BP_BIT_FIELD onesec:1;

} BP_PACKED2 FR8370_ALARM_2_INT_ENABLE_REG;
   
typedef BP_PACKED struct
{
    BP_BIT_FIELD tslip:1;
    BP_BIT_FIELD rslip:1;
    BP_BIT_FIELD ckerr:1;
    BP_BIT_FIELD jerr:1;
    BP_BIT_FIELD cerr:1;
    BP_BIT_FIELD serr:1;
    BP_BIT_FIELD merr:1;
    BP_BIT_FIELD ferr:1;
} BP_PACKED2 FR8370_ERROR_INT_ENABLE_REG;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lof:1;
    BP_BIT_FIELD cofa:1;
    BP_BIT_FIELD sef:1;
    BP_BIT_FIELD berr:1;
    BP_BIT_FIELD febe:1;
    BP_BIT_FIELD lcv:1;
    BP_BIT_FIELD crc:1;
    BP_BIT_FIELD ferr:1;

} BP_PACKED2 FR8370_COUNT_OVRFL_INT_EN_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD tsig:1;
    BP_BIT_FIELD tmsync:1;
    BP_BIT_FIELD tmf:1;
    BP_BIT_FIELD tframe:1;
    BP_BIT_FIELD rsig:1;
    BP_BIT_FIELD rmsync:1;
    BP_BIT_FIELD rmf:1;
    BP_BIT_FIELD rframe:1;
} BP_PACKED2 FR8370_TIMER_INT_ENABLE_REG;


typedef BP_PACKED struct
{
    BP_BIT_FIELD tbop:1;
    BP_BIT_FIELD rfull:1;
    BP_BIT_FIELD rnear1:1;
    BP_BIT_FIELD rmsg1:1;
    BP_BIT_FIELD tdlerr1:1;
    BP_BIT_FIELD tempty:1;
    BP_BIT_FIELD tnear:1;
    BP_BIT_FIELD tmsg:1;
} BP_PACKED2 FR8370_DATA_LINK_1_INT_EN_REG;


typedef BP_PACKED struct
{
    BP_BIT_FIELD rbop:1;
    BP_BIT_FIELD rfull:1;
    BP_BIT_FIELD rnear2:1;
    BP_BIT_FIELD rmsg2:1;
    BP_BIT_FIELD tdlerr2:1;
    BP_BIT_FIELD tempty2:1;
    BP_BIT_FIELD tnear2:1;
    BP_BIT_FIELD tmsg2:1;
} BP_PACKED2 FR8370_DATA_LINK_2_INT_EN_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD bslip:1;
    BP_BIT_FIELD psync:1;
    BP_BIT_FIELD tcerr:1;
    BP_BIT_FIELD tserr:1;
    BP_BIT_FIELD tmerr:1;
    BP_BIT_FIELD tferr:1;
} BP_PACKED2 FR8370_PATTERN_INT_ENABLE_REG;


/*********************************/
/* Primary Control and Status    */
/*         Registers             */
/*********************************/

typedef BP_PACKED struct
{
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD ploop:1;
    BP_BIT_FIELD lloop:1;
    BP_BIT_FIELD floop:1;
    BP_BIT_FIELD aloop:1;
} BP_PACKED2 FR8370_LB_CONF_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD dl3en:1;
    BP_BIT_FIELD odd:1;
    BP_BIT_FIELD even:1;
    BP_BIT_FIELD ts:5;
} BP_PACKED2 FR8370_EXT_DATA_LINK_TIMESLOT;

typedef BP_PACKED struct
{
    BP_BIT_FIELD dl3_bit:8;
} BP_PACKED2 FR8370_EXTERNAL_DATA_LINK_BIT;

typedef BP_PACKED struct
{
    BP_BIT_FIELD reserved:3;
    BP_BIT_FIELD invalid:1;
    BP_BIT_FIELD found:1;
    BP_BIT_FIELD timeout:1;
    BP_BIT_FIELD active:1;
    BP_BIT_FIELD rx_txn:1;

} BP_PACKED2 FR8370_OFFLINE_FRAMER_STATUS;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD onesec_io:1;
    BP_BIT_FIELD rdl_io:1;
    BP_BIT_FIELD tdl_io:1;
    BP_BIT_FIELD indy_io:1;
    BP_BIT_FIELD rfsync_io:1;
    BP_BIT_FIELD rmsync_io:1;
    BP_BIT_FIELD tfsync_io:1;
    BP_BIT_FIELD tmsync_io:1;
} BP_PACKED2 FR8370_PROGRAM_INPUT_OUTPUT;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD tdl_oe:1;
    BP_BIT_FIELD rdl_oe:1;
    BP_BIT_FIELD indy_oe:1;
    BP_BIT_FIELD tcko_oe:1;
    BP_BIT_FIELD clado_oe:1;
    BP_BIT_FIELD rcko_oe:1;
} BP_PACKED2 FR8370_PROGRAM_OUTPUT_ENABLE;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rsbcki:2;
    BP_BIT_FIELD tsbcki:2;
    BP_BIT_FIELD cladi:2;
    BP_BIT_FIELD tcki:2;
} BP_PACKED2 FR8370_CLOCK_INPUT_MUX;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD tmux:6;
} BP_PACKED2 FR8370_TEST_MUX_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:6;
    BP_BIT_FIELD test:1;
    BP_BIT_FIELD pup_off:1;
} BP_PACKED2 FR8370_TEST_CONF;


/*********************************/
/*       Receive LIU             */
/*         Registers             */
/*********************************/


typedef BP_PACKED struct
{   
    BP_BIT_FIELD rst_liu:1;
    BP_BIT_FIELD squelch:1;
    BP_BIT_FIELD vlimit:1;
    BP_BIT_FIELD rdigi:1;
    BP_BIT_FIELD attn:2;
    BP_BIT_FIELD dpm_csu:1;
    BP_BIT_FIELD dpm_off:1;
} BP_PACKED2 FR8370_LIU_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD force_eye:1;
    BP_BIT_FIELD hi_cslice:1;
    BP_BIT_FIELD agc:2;
    BP_BIT_FIELD eq_frz:1;
    BP_BIT_FIELD pflip:1;
    BP_BIT_FIELD lpf_off:1;
    BP_BIT_FIELD long_eye:1;
} BP_PACKED2 FR8370_REC_LIU_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD lpf:6;
} BP_PACKED2 FR8370_RPLL_LOW_PASS_FILTER;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD vga_max:6;
} BP_PACKED2 FR8370_VARIABLE_GAIN_AMP_MAX;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD eq_dat:8;
} BP_PACKED2 FR8370_EQ_COEFF_DATA_REG;


typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD eq_ptr:6;
} BP_PACKED2 FR8370_EQ_COEFF_TABLE_PTR;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dslice:8;
} BP_PACKED2 FR8370_DATA_SLICER_THRESHOLD;


typedef BP_PACKED struct
{   
    BP_BIT_FIELD cslice:8;
} BP_PACKED2 FR8370_CLOCK_SLICER_THRESHOLD;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD peq:1;
    BP_BIT_FIELD pq_stat:1;
    BP_BIT_FIELD vauto:1;
    BP_BIT_FIELD vthresh:4;
} BP_PACKED2 FR8370_PRE_EQ;


/*********************************/
/*         Receive               */
/*         Registers             */
/*********************************/


typedef BP_PACKED struct
{   
    BP_BIT_FIELD rami:1;
    BP_BIT_FIELD rabort:1;
    BP_BIT_FIELD rforce:1;
    BP_BIT_FIELD rlofd:1;
    BP_BIT_FIELD rlofc:1;
    BP_BIT_FIELD rlofb:1;
    BP_BIT_FIELD rlofa:1;
    BP_BIT_FIELD rzcs:1;
} BP_PACKED2 FR8370_RECR_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD reseed:1;
    BP_BIT_FIELD bstart:1;
    BP_BIT_FIELD framed:1;
    BP_BIT_FIELD zlimit:1;
    BP_BIT_FIELD rpatt:2;
} BP_PACKED2 FR8370_REC_TEST_PATTERN_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD dn_len:2;
    BP_BIT_FIELD up_len:2;
} BP_PACKED2 FR8370_REC_LB_CODE_DET_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lba:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_LB_ACTIVATE_CODE_PATTERN;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lbd:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_LB_DEACTIVATE_CODE_PAT;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD fs_nfas:1;
    BP_BIT_FIELD exz_lcv:1;
    BP_BIT_FIELD yel_integ:1;
    BP_BIT_FIELD rlof_integ:1;
    BP_BIT_FIELD rpcm_yel:1;
    BP_BIT_FIELD rpcm_ais:1;
} BP_PACKED2 FR8370_REC_ALARM_SIGNAL_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD stop_cnt:1;
    BP_BIT_FIELD latch_cnt:1;
    BP_BIT_FIELD latch_err:1;
    BP_BIT_FIELD latchalm:1;
} BP_PACKED2 FR8370_ERROR_LATCH_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD shape:6;
} BP_PACKED2 FR8370_TX_PULSE_SHAPE_CONF;            /* 060 - 067 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD turns:1;
    BP_BIT_FIELD term:1;
    BP_BIT_FIELD lbo:2;
    BP_BIT_FIELD pulse:3;
    BP_BIT_FIELD aisclk:1;
} BP_PACKED2 FR8370_TX_LIU_CONF;                     /* 068 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD tframe:4;
} BP_PACKED2 FR8370_TX_FRAMER_CONF;                  /* 070 */


typedef BP_PACKED struct
{   
    BP_BIT_FIELD tnzr:1;
    BP_BIT_FIELD tabort:1;
    BP_BIT_FIELD tforce:1;
    BP_BIT_FIELD tlofc:1;
    BP_BIT_FIELD tlofb:1;
    BP_BIT_FIELD tlofa:1;
    BP_BIT_FIELD tzcs:2;
} BP_PACKED2 FR8370_TRANSMITER_CONF;                   /* 071 -0A1 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD ins_myel:1;
    BP_BIT_FIELD ins_yel:1;
    BP_BIT_FIELD ins_mf:1;
    BP_BIT_FIELD ins_fe:1;
    BP_BIT_FIELD ins_crc:1;
    BP_BIT_FIELD ins_fbit:1;
} BP_PACKED2 FR8370_TX_FRAME_FORMAT;                 /* 072 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tserr:1;
    BP_BIT_FIELD tmerr:1;
    BP_BIT_FIELD tberr:1;
    BP_BIT_FIELD bslip:1;
    BP_BIT_FIELD tcofa:1;
    BP_BIT_FIELD tcerr:1;
    BP_BIT_FIELD tferr:1;
    BP_BIT_FIELD tverr:1;
} BP_PACKED2 FR8370_TX_ERROR_INSERT;                 /* 073 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD ins_sa:5;
    BP_BIT_FIELD febe1:1;
    BP_BIT_FIELD febe2:1;
    BP_BIT_FIELD tfebe:1;
} BP_PACKED2 FR8370_TX_SA_BYTE_FEBE_CONF;     /* 074 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved :2;
    BP_BIT_FIELD auto_myel:1;
    BP_BIT_FIELD auto_yel:1;
    BP_BIT_FIELD auto_ais:1;
    BP_BIT_FIELD tmyel:1;
    BP_BIT_FIELD tyel:1;
    BP_BIT_FIELD tais:1;
} BP_PACKED2 FR8370_TX_ALARM_SIGNAL_CONF;            /* 075 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:3;
    BP_BIT_FIELD ttpstart:1;
    BP_BIT_FIELD framed:1;
    BP_BIT_FIELD zlimilt:1;
    BP_BIT_FIELD tpatt:2;
} BP_PACKED2 FR8370_TX_TEST_PATTERN_CONF;             /* 076 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD lb_len:2;
    BP_BIT_FIELD unframed:1;
    BP_BIT_FIELD lbstart:1;
} BP_PACKED2 FR8370_TX_INBAND_LB_CODE_CONF;           /* 077 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lbp:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_TX_INBAND_LB_CODE_PAT;       /* 078 */


typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa4:8;
} BP_PACKED2 FR8370_TX_SA4_BYTE_BUFFER;              /* 07B */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa5:8;
} BP_PACKED2 FR8370_TX_SA5_BYTE_BUFFER;              /* 07C */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa6:8;
} BP_PACKED2 FR8370_TX_SA6_BYTE_BUFFER;              /* 07D */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa7:8;
} BP_PACKED2 FR8370_TX_SA7_BYTE_BUFFER;              /* 07E */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa8:8;
} BP_PACKED2 FR8370_TX_SA8_BYTE_BUFFER;              /* 07F */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD cen:1;
    BP_BIT_FIELD xsel:3;
    BP_BIT_FIELD lfgain:4;
} BP_PACKED2 FR8370_CLOCK_RATE_ADAPTOR_CONF;           /* 090 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD vsel:4;
    BP_BIT_FIELD osel:4;
} BP_PACKED2 FR8370_CLAD_FREQUENCY_SELECT;             /* 091 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved1:1;
    BP_BIT_FIELD rscale:3;
    BP_BIT_FIELD reserved2:1;
    BP_BIT_FIELD vscale:3;
} BP_PACKED2 FR8370_CLAD_PHASE_DETECTOR;       /* 092 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:3;
    BP_BIT_FIELD pnsel:1;
    BP_BIT_FIELD d20a:1;
    BP_BIT_FIELD tbus:1;
    BP_BIT_FIELD rwini:1;
    BP_BIT_FIELD jinit:1;
} BP_PACKED2 FR8370_CLAD_TEST;                         /* 093 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rbop_start:1;
    BP_BIT_FIELD rbop_integ:1;
    BP_BIT_FIELD rbop_len:2;
    BP_BIT_FIELD tbop_len:2;
    BP_BIT_FIELD tbop_mode:2;
} BP_PACKED2 FR8370_BOP_TRANSCEIVER;        /* 0A0 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD tframe:4;
} BP_PACKED2 FR8370_TX_BOP_CODEWORD;                 /* 0A1 */


typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl1_ts:8;
} BP_PACKED2 FR8370_DL1_TIMESLOT_ENABLE;               /* 0A4 DL REG */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl1_bit:8;
} BP_PACKED2 FR8370_DL1_BIT_ENABLE;                    /* 0A5  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved1:3;
    BP_BIT_FIELD tdl1_rpt:1;
    BP_BIT_FIELD dl1:2;
    BP_BIT_FIELD tdl1_en:1;
    BP_BIT_FIELD rdl1_en:1;
} BP_PACKED2 FR8370_DL1_CONTROL;                       /* 0A6  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD msg_fil:2;
    BP_BIT_FIELD ffc:6;
} BP_PACKED2 FR8370_RDL1_FIFO_FILL_CONTROL;            /* 0A7  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD auto_prm:1;
    BP_BIT_FIELD prm_cr:1;
    BP_BIT_FIELD prm_r:1;
    BP_BIT_FIELD prm_u1:1;
    BP_BIT_FIELD prm_u2:1;
    BP_BIT_FIELD prm_sl:1;
    BP_BIT_FIELD auto_sl:1;
    BP_BIT_FIELD send_prm:1;
} BP_PACKED2 FR8370_PERF_REPORT_MESSAGE;        /* 0AA  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD fec:6;
} BP_PACKED2 FR8370_TDL1_FIFO_EMPTY_CONTROL;           /* 0AB  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:8;
} BP_PACKED2 FR8370_TDL1_EOM_CONTROL;       /* 0AC  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tdl1:8;
} BP_PACKED2 FR8370_TX_DATA_LINK_FIFO;               /* 0AD  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD tmsg1:1;
    BP_BIT_FIELD tmpty:1;
    BP_BIT_FIELD tnear:1;
    BP_BIT_FIELD tfull:1;
} BP_PACKED2 FR8370_TDL1_STATUS;                       /* 0AE  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lds_2:8;
} BP_PACKED2 FR8370_DL2_TIMESLOT_ENABLE;               /* 0AF  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl2_bit:8;
} BP_PACKED2 FR8370_DL2_BIT_ENABLE;                    /* 0B0  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:3;
    BP_BIT_FIELD tdl2_rpt:1;
    BP_BIT_FIELD dl2:2;
    BP_BIT_FIELD tdl2_en:1;
    BP_BIT_FIELD rdl2_en:1;
} BP_PACKED2 FR8370_DL2_CONTROL;                       /* 0B1  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD msg_fill:2;
    BP_BIT_FIELD fcc:6;
} BP_PACKED2 FR8370_RDL2_FIFO_FILL_CONTROL;            /* 0B2  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD fec:6;
} BP_PACKED2 FR8370_TDL2_FIFO_EMPTY_CONTROL;           /* 0B6  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:8;
} BP_PACKED2 FR8370_TDL2_EOM_CONTROL;       /* 0B7  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tdl2:8;
} BP_PACKED2 FR8370_TX_DATA_LINK_FIFO2;              /* 0B8  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:4;
    BP_BIT_FIELD dl_test:4;
} BP_PACKED2 FR8370_DLINK_TEST_CONF1;                  /* 0BA  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD dl_test2:6;
} BP_PACKED2 FR8370_DLINK_TEST_STATUS2;                /* 0BB  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD dl_test3:6;
    BP_BIT_FIELD send_prm:1;
} BP_PACKED2 FR8370_DLINK_TEST_STATUS3;                /* 0BC  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD dl_test4:7;
} BP_PACKED2 FR8370_DLINK_TEST_CONTROL1;      /* 0BD  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD dl_test5:7;
} BP_PACKED2 FR8370_DLINK_TEST_CONTROL2;      /* 0BE  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD x2clk:1;
    BP_BIT_FIELD sbi_oe:1;
    BP_BIT_FIELD emf:1;
    BP_BIT_FIELD embed:1;
    BP_BIT_FIELD sbi:4;
} BP_PACKED2 FR8370_SYS_BUS_INTERFACE_CONF;            /* 0D0  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD bus_rsb:1;
    BP_BIT_FIELD sig_off:1;
    BP_BIT_FIELD rpcm_neg:1;
    BP_BIT_FIELD rsyn_neg:1;
    BP_BIT_FIELD bus_frz:1;
    BP_BIT_FIELD rsb_ctr:1;
    BP_BIT_FIELD rsbi:2;
} BP_PACKED2 FR8370_REC_SYS_BUS_CONF;                  /* 0D1  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:5;
    BP_BIT_FIELD offset:3;
} BP_PACKED2 FR8370_RSB_SYNC_BIT_OFFSET;               /* 0D2  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD offset:7;
} BP_PACKED2 FR8370_RSB_SYNC_TIMESLOT_OFFSET;          /* 0D3  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD bus_tsb:1;
    BP_BIT_FIELD tx_align:1;
    BP_BIT_FIELD tpcm_neg:1;
    BP_BIT_FIELD tsyn_neg:1;
    BP_BIT_FIELD tsb_align:1;
    BP_BIT_FIELD tsb_ctr:1;
    BP_BIT_FIELD tsbi:2;
} BP_PACKED2 FR8370_TX_SYS_BUS_CONF;                 /* 0D4  */
                                                   
typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:5;
    BP_BIT_FIELD offset:3;
} BP_PACKED2 FR8370_TSB_SYNC_BIT_OFFSET;               /* 0D5  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD offset:7;
} BP_PACKED2 FR8370_TSB_SYNC_TIMESLOT_OFFSET;          /* 0D6  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD set_rsig:1;
    BP_BIT_FIELD set_sig:1;
    BP_BIT_FIELD unicode:1;
    BP_BIT_FIELD debounce:1;
    BP_BIT_FIELD frz_off:1;
    BP_BIT_FIELD frz_on:1;
    BP_BIT_FIELD thru:1;
} BP_PACKED2 FR8370_REC_SIGNALING_CONF;                /* 0D7  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:3;
    BP_BIT_FIELD offset:5;
} BP_PACKED2 FR8370_RSYNC_FRAME_OFFSET;   /* 0D8  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsdir:1;
    BP_BIT_FIELD tfslip:1;
    BP_BIT_FIELD tuslip:1;
    BP_BIT_FIELD tdly:1;
    BP_BIT_FIELD rsdir:1;
    BP_BIT_FIELD rfslip:1;
    BP_BIT_FIELD ruslip:1;
    BP_BIT_FIELD rdly:1;
} BP_PACKED2 FR8370_SLIP_BUFFER_STATUS;                /* 0D9  */

#else /* not BIT_REVERSE */

typedef BP_PACKED struct
{
    BP_BIT_FIELD t1_e1:1;
    BP_BIT_FIELD rframe:4;
    BP_BIT_FIELD reserved:2;
    BP_BIT_FIELD reset:1;
} BP_PACKED2 FR8370_PRIMARY_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD jsize:3;
    BP_BIT_FIELD jcenter:1;
    BP_BIT_FIELD jauto:1;
    BP_BIT_FIELD jdir:1;
    BP_BIT_FIELD jfree:1;
    BP_BIT_FIELD jen:1;
} BP_PACKED2 FR8370_JITTER_ATTEN_CONF;   

typedef BP_PACKED struct
{
    BP_BIT_FIELD patt:1;
    BP_BIT_FIELD dl2:1;
    BP_BIT_FIELD dl1:1;
    BP_BIT_FIELD timer:1;
    BP_BIT_FIELD count:1;
    BP_BIT_FIELD error:1;
    BP_BIT_FIELD alm2:1;
    BP_BIT_FIELD alm1:1;
} BP_PACKED2 FR8370_INT_REQ_REG;            


typedef BP_PACKED struct
{
    BP_BIT_FIELD sigfrz:1;
    BP_BIT_FIELD rlof:1;
    BP_BIT_FIELD rlos:1;
    BP_BIT_FIELD ralos:1;
    BP_BIT_FIELD rais:1;
    BP_BIT_FIELD rpdv:1;
    BP_BIT_FIELD ryel:1;
    BP_BIT_FIELD rmyel:1;
} BP_PACKED2 FR8370_ALARM_1_INT_STATUS;     
                                                 
typedef BP_PACKED struct
{
    BP_BIT_FIELD onesec:1;
    BP_BIT_FIELD tlof:1;
    BP_BIT_FIELD tlos:1;
    BP_BIT_FIELD tloc:1;
    BP_BIT_FIELD tshort:1;
    BP_BIT_FIELD tpdv:1;  
    BP_BIT_FIELD loopup:1;
    BP_BIT_FIELD loopdn:1;
} BP_PACKED2 FR8370_ALARM_2_INT_STATUS;        


typedef BP_PACKED struct
{
    BP_BIT_FIELD ferr:1;
    BP_BIT_FIELD merr:1;
    BP_BIT_FIELD serr:1;
    BP_BIT_FIELD cerr:1;
    BP_BIT_FIELD jerr:1;
    BP_BIT_FIELD ckerr:1;
    BP_BIT_FIELD rslip:1;
    BP_BIT_FIELD tslip:1;
} BP_PACKED2 FR8370_ERROR_INT_STATUS;          

typedef BP_PACKED struct
{
    BP_BIT_FIELD ferr:1;
    BP_BIT_FIELD crc:1;
    BP_BIT_FIELD lcv:1;
    BP_BIT_FIELD febe:1;
    BP_BIT_FIELD berr:1;
    BP_BIT_FIELD sef:1;
    BP_BIT_FIELD cofa:1;
    BP_BIT_FIELD rlof:1;
} BP_PACKED2 FR8370_COUNT_OVRFL_INT_STATUS;

typedef BP_PACKED struct
{
    BP_BIT_FIELD rframe:1;
    BP_BIT_FIELD rmf:1;
    BP_BIT_FIELD rmsync:1;
    BP_BIT_FIELD rsig:1;
    BP_BIT_FIELD tframe:1;
    BP_BIT_FIELD tmf:1;
    BP_BIT_FIELD tmsync:1;
    BP_BIT_FIELD tsig:1;
} BP_PACKED2 FR8370_TIMER_INT_STATUS;    

typedef BP_PACKED struct
{
    BP_BIT_FIELD sigfrz:1;
    BP_BIT_FIELD rlof:1;
    BP_BIT_FIELD rlos:1;
    BP_BIT_FIELD ralos:1;
    BP_BIT_FIELD rais:1;
    BP_BIT_FIELD rpdv:1;
    BP_BIT_FIELD ryel:1;
    BP_BIT_FIELD rmyel:1;
} BP_PACKED2 FR8370_ALARM_1_INT_ENABLE_REG;    

typedef BP_PACKED struct
{
    BP_BIT_FIELD onesec:1;
    BP_BIT_FIELD tlof:1;
    BP_BIT_FIELD tlos:1;
    BP_BIT_FIELD tloc:1;
    BP_BIT_FIELD tshort:1;
    BP_BIT_FIELD tpdv:1;
    BP_BIT_FIELD loopup:1;
    BP_BIT_FIELD loopdn:1;
} BP_PACKED2 FR8370_ALARM_2_INT_ENABLE_REG;    
   
typedef BP_PACKED struct
{
    BP_BIT_FIELD ferr:1;
    BP_BIT_FIELD merr:1;
    BP_BIT_FIELD serr:1;
    BP_BIT_FIELD cerr:1;
    BP_BIT_FIELD jerr:1;
    BP_BIT_FIELD ckerr:1;
    BP_BIT_FIELD rslip:1;
    BP_BIT_FIELD tslip:1;
} BP_PACKED2 FR8370_ERROR_INT_ENABLE_REG;      

typedef BP_PACKED struct
{   
    BP_BIT_FIELD ferr:1;
    BP_BIT_FIELD crc:1;
    BP_BIT_FIELD lcv:1;
    BP_BIT_FIELD febe:1;
    BP_BIT_FIELD berr:1;
    BP_BIT_FIELD sef:1;
    BP_BIT_FIELD cofa:1;
    BP_BIT_FIELD lof:1;
} BP_PACKED2 FR8370_COUNT_OVRFL_INT_EN_REG;  


typedef BP_PACKED struct
{
    BP_BIT_FIELD tsig:1;
    BP_BIT_FIELD tmsync:1;
    BP_BIT_FIELD tmf:1;
    BP_BIT_FIELD tframe:1;
    BP_BIT_FIELD rsig:1;
    BP_BIT_FIELD rmsync:1;
    BP_BIT_FIELD rmf:1;
    BP_BIT_FIELD rframe:1;
} BP_PACKED2 FR8370_TIMER_INT_ENABLE_REG;         


typedef BP_PACKED struct
{
    BP_BIT_FIELD tmsg:1;
    BP_BIT_FIELD tnear:1;
    BP_BIT_FIELD tempty:1;
    BP_BIT_FIELD tdlerr1:1;
    BP_BIT_FIELD rmsg1:1;
    BP_BIT_FIELD rnear1:1;
    BP_BIT_FIELD rfull:1;
    BP_BIT_FIELD tbop:1;

} BP_PACKED2 FR8370_DATA_LINK_1_INT_EN_REG;
                                       

typedef BP_PACKED struct
{
    BP_BIT_FIELD tmsg2:1;
    BP_BIT_FIELD tnear2:1;
    BP_BIT_FIELD tempty2:1;
    BP_BIT_FIELD tdlerr2:1;
    BP_BIT_FIELD rmsg2:1;
    BP_BIT_FIELD rnear2:1;
    BP_BIT_FIELD rfull:1;
    BP_BIT_FIELD rbop:1;
} BP_PACKED2 FR8370_DATA_LINK_2_INT_EN_REG;      

typedef BP_PACKED struct
{
    BP_BIT_FIELD tferr:1;
    BP_BIT_FIELD tmerr:1;
    BP_BIT_FIELD tserr:1;
    BP_BIT_FIELD tcerr:1;
    BP_BIT_FIELD psync:1;
    BP_BIT_FIELD bslip:1;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_PATTERN_INT_ENABLE_REG;


/*********************************/
/* Primary Control and Status    */
/*         Registers             */
/*********************************/

typedef BP_PACKED struct
{
    BP_BIT_FIELD aloop:1;
    BP_BIT_FIELD floop:1;
    BP_BIT_FIELD lloop:1;
    BP_BIT_FIELD ploop:1;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_LB_CONF_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD ts:5;
    BP_BIT_FIELD even:1;
    BP_BIT_FIELD odd:1;
    BP_BIT_FIELD dl3en:1;
} BP_PACKED2 FR8370_EXT_DATA_LINK_TIMESLOT;     

typedef BP_PACKED struct
{
    BP_BIT_FIELD dl3_bit:8;
} BP_PACKED2 FR8370_EXTERNAL_DATA_LINK_BIT;

typedef BP_PACKED struct
{
    BP_BIT_FIELD rx_txn:1;
    BP_BIT_FIELD active:1;
    BP_BIT_FIELD timeout:1;
    BP_BIT_FIELD found:1;
    BP_BIT_FIELD invalid:1;
    BP_BIT_FIELD reserved:3;
} BP_PACKED2 FR8370_OFFLINE_FRAMER_STATUS;
                                          
typedef BP_PACKED struct
{   
    BP_BIT_FIELD tmsync_io:1;
    BP_BIT_FIELD tfsync_io:1;
    BP_BIT_FIELD rmsync_io:1;
    BP_BIT_FIELD rfsync_io:1;
    BP_BIT_FIELD indy_io:1;
    BP_BIT_FIELD tdl_io:1;
    BP_BIT_FIELD rdl_io:1;
    BP_BIT_FIELD onesec_io:1;
} BP_PACKED2 FR8370_PROGRAM_INPUT_OUTPUT;         

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rcko_oe:1;
    BP_BIT_FIELD clado_oe:1;
    BP_BIT_FIELD tcko_oe:1;
    BP_BIT_FIELD indy_oe:1;
    BP_BIT_FIELD rdl_oe:1;
    BP_BIT_FIELD tdl_oe:1;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_PROGRAM_OUTPUT_ENABLE;        

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tcki:2;
    BP_BIT_FIELD cladi:2;
    BP_BIT_FIELD tsbcki:2;
    BP_BIT_FIELD rsbcki:2;
} BP_PACKED2 FR8370_CLOCK_INPUT_MUX;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tmux:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_TEST_MUX_CONF;                

typedef BP_PACKED struct
{   
    BP_BIT_FIELD pup_off:1;
    BP_BIT_FIELD test:1;
    BP_BIT_FIELD reserved:6;
} BP_PACKED2 FR8370_TEST_CONF;                 


/*********************************/
/*       Receive LIU             */
/*         Registers             */
/*********************************/


typedef BP_PACKED struct
{   
    BP_BIT_FIELD dpm_off:1;
    BP_BIT_FIELD dpm_csu:1;
    BP_BIT_FIELD attn:2;
    BP_BIT_FIELD rdigi:1;
    BP_BIT_FIELD vlimit:1;
    BP_BIT_FIELD squelch:1;
    BP_BIT_FIELD rst_liu:1;
} BP_PACKED2 FR8370_LIU_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD long_eye:1;
    BP_BIT_FIELD lpf_off:1;
    BP_BIT_FIELD pflip:1;
    BP_BIT_FIELD eq_frz:1;
    BP_BIT_FIELD agc:2;
    BP_BIT_FIELD hi_cslice:1;
    BP_BIT_FIELD force_eye:1;
} BP_PACKED2 FR8370_REC_LIU_CONF;           

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lpf:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_RPLL_LOW_PASS_FILTER;      

typedef BP_PACKED struct
{   
    BP_BIT_FIELD vga_max:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_VARIABLE_GAIN_AMP_MAX;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD eq_dat:8;
} BP_PACKED2 FR8370_EQ_COEFF_DATA_REG;


typedef BP_PACKED struct
{   
    BP_BIT_FIELD eq_ptr:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_EQ_COEFF_TABLE_PTR;     

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dslice:8;
} BP_PACKED2 FR8370_DATA_SLICER_THRESHOLD;


typedef BP_PACKED struct
{   
    BP_BIT_FIELD cslice:8;
} BP_PACKED2 FR8370_CLOCK_SLICER_THRESHOLD;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD vthresh:4;
    BP_BIT_FIELD vauto:1;
    BP_BIT_FIELD pq_stat:1;
    BP_BIT_FIELD peq:1;
} BP_PACKED2 FR8370_PRE_EQ;                 


/*********************************/
/*         Receive               */
/*         Registers             */
/*********************************/


typedef BP_PACKED struct
{   
    BP_BIT_FIELD rzcs:1;
    BP_BIT_FIELD rlofa:1;
    BP_BIT_FIELD rlofb:1;
    BP_BIT_FIELD rlofc:1;
    BP_BIT_FIELD rlofd:1;
    BP_BIT_FIELD rforce:1;
    BP_BIT_FIELD rabort:1;
    BP_BIT_FIELD rami:1;
} BP_PACKED2 FR8370_RECR_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rpatt:2;
    BP_BIT_FIELD zlimit:1;
    BP_BIT_FIELD framed:1;
    BP_BIT_FIELD bstart:1;
    BP_BIT_FIELD reseed:1;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_REC_TEST_PATTERN_CONF;        

typedef BP_PACKED struct
{   
    BP_BIT_FIELD up_len:2;
    BP_BIT_FIELD dn_len:2;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_REC_LB_CODE_DET_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD lba:7;
} BP_PACKED2 FR8370_LB_ACTIVATE_CODE_PATTERN;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD lbd:7;
} BP_PACKED2 FR8370_LB_DEACTIVATE_CODE_PAT;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rpcm_ais:1;
    BP_BIT_FIELD rpcm_yel:1;
    BP_BIT_FIELD rlof_integ:1;
    BP_BIT_FIELD yel_integ:1;
    BP_BIT_FIELD exz_lcv:1;
    BP_BIT_FIELD fs_nfas:1;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_REC_ALARM_SIGNAL_CONF;           

typedef BP_PACKED struct
{   
    BP_BIT_FIELD latch_alm:1;
    BP_BIT_FIELD latch_err:1;
    BP_BIT_FIELD latch_cnt:1;
    BP_BIT_FIELD stop_cnt:1;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_ERROR_LATCH_CONF;

typedef BP_PACKED struct
{   
    BP_BIT_FIELD shape:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_TX_PULSE_SHAPE_CONF;            /* 060 - 067 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD aisclk:1;
    BP_BIT_FIELD pulse:3;
    BP_BIT_FIELD lbo:2;
    BP_BIT_FIELD term:1;
    BP_BIT_FIELD turns:1;
} BP_PACKED2 FR8370_TX_LIU_CONF;                     /* 068 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tframe:4;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_TX_FRAMER_CONF;                  /* 070 */


typedef BP_PACKED struct
{   
    BP_BIT_FIELD tzcs:2;
    BP_BIT_FIELD tlofa:1;
    BP_BIT_FIELD tlofb:1;
    BP_BIT_FIELD tlofc:1;
    BP_BIT_FIELD tforce:1;
    BP_BIT_FIELD tabort:1;
    BP_BIT_FIELD tnzr:1;
} BP_PACKED2 FR8370_TRANSMITER_CONF;                   /* 071 -0A1 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD ins_fbit:1;
    BP_BIT_FIELD ins_crc:1;
    BP_BIT_FIELD ins_fe:1;
    BP_BIT_FIELD ins_mf:1;
    BP_BIT_FIELD ins_yel:1;
    BP_BIT_FIELD ins_myel:1;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_TX_FRAME_FORMAT;                 /* 072 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tverr:1;
    BP_BIT_FIELD tferr:1;
    BP_BIT_FIELD tcerr:1;
    BP_BIT_FIELD tcofa:1;
    BP_BIT_FIELD bslip:1;
    BP_BIT_FIELD tberr:1;
    BP_BIT_FIELD tmerr:1;
    BP_BIT_FIELD tserr:1;
} BP_PACKED2 FR8370_TX_ERROR_INSERT;                 /* 073 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tfebe:1;
    BP_BIT_FIELD febe2:1;
    BP_BIT_FIELD febe1:1;
    BP_BIT_FIELD ins_sa:5;
} BP_PACKED2 FR8370_TX_SA_BYTE_FEBE_CONF;     /* 074 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tais:1;
    BP_BIT_FIELD tyel:1;
    BP_BIT_FIELD tmyel:1;
    BP_BIT_FIELD auto_ais:1;
    BP_BIT_FIELD auto_yel:1;
    BP_BIT_FIELD auto_myel:1;
    BP_BIT_FIELD reserved :2;
} BP_PACKED2 FR8370_TX_ALARM_SIGNAL_CONF;            /* 075 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tpatt:2;
    BP_BIT_FIELD zlimilt:1;
    BP_BIT_FIELD framed:1;
    BP_BIT_FIELD ttpstart:1;
    BP_BIT_FIELD reserved:3;
} BP_PACKED2 FR8370_TX_TEST_PATTERN_CONF;             /* 076 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lbstart:1;
    BP_BIT_FIELD unframed:1;
    BP_BIT_FIELD lb_len:2;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_TX_INBAND_LB_CODE_CONF;           /* 077 */      

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD lbp:7;
} BP_PACKED2 FR8370_TX_INBAND_LB_CODE_PAT;       /* 078 */


typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa4:8;
} BP_PACKED2 FR8370_TX_SA4_BYTE_BUFFER;              /* 07B */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa5:8;
} BP_PACKED2 FR8370_TX_SA5_BYTE_BUFFER;              /* 07C */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa6:8;
} BP_PACKED2 FR8370_TX_SA6_BYTE_BUFFER;              /* 07D */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa7:8;
} BP_PACKED2 FR8370_TX_SA7_BYTE_BUFFER;              /* 07E */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsa8:8;
} BP_PACKED2 FR8370_TX_SA8_BYTE_BUFFER;              /* 07F */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lfgain:4;
    BP_BIT_FIELD xsel:3;
    BP_BIT_FIELD cen:1;
} BP_PACKED2 FR8370_CLOCK_RATE_ADAPTOR_CONF;           /* 090 */    

typedef BP_PACKED struct
{   
    BP_BIT_FIELD osel:4;
    BP_BIT_FIELD vsel:4;
} BP_PACKED2 FR8370_CLAD_FREQUENCY_SELECT;             /* 091 */    

typedef BP_PACKED struct
{   
    BP_BIT_FIELD vscale:3;
    BP_BIT_FIELD reserved2:1;
    BP_BIT_FIELD rscale:3;
    BP_BIT_FIELD reserved1:1;
} BP_PACKED2 FR8370_CLAD_PHASE_DETECTOR;       /* 092 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD jinit:1;
    BP_BIT_FIELD rwini:1;
    BP_BIT_FIELD tbus:1;
    BP_BIT_FIELD d20a:1;
    BP_BIT_FIELD pnsel:1;
    BP_BIT_FIELD reserved:3;
} BP_PACKED2 FR8370_CLAD_TEST;                         /* 093 */    

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tbop_mode:2;
    BP_BIT_FIELD tbop_len:2;
    BP_BIT_FIELD rbop_len:2;
    BP_BIT_FIELD rbop_integ:1;
    BP_BIT_FIELD rbop_start:1;
} BP_PACKED2 FR8370_BOP_TRANSCEIVER;        /* 0A0 */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tframe:4;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_TX_BOP_CODEWORD;                 /* 0A1 */


typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl1_ts:8;
} BP_PACKED2 FR8370_DL1_TIMESLOT_ENABLE;               /* 0A4 DL REG */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl1_bit:8;
} BP_PACKED2 FR8370_DL1_BIT_ENABLE;                    /* 0A5  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rdl1_en:1;
    BP_BIT_FIELD tdl1_en:1;
    BP_BIT_FIELD dl1:2;
    BP_BIT_FIELD tdl1_rpt:1;
    BP_BIT_FIELD reserved1:3;

} BP_PACKED2 FR8370_DL1_CONTROL;                       /* 0A6  */   

typedef BP_PACKED struct
{   
    BP_BIT_FIELD ffc:6;
    BP_BIT_FIELD msg_fil:2;
} BP_PACKED2 FR8370_RDL1_FIFO_FILL_CONTROL;            /* 0A7  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD send_prm:1;
    BP_BIT_FIELD auto_sl:1;
    BP_BIT_FIELD prm_sl:1;
    BP_BIT_FIELD prm_u2:1;
    BP_BIT_FIELD prm_u1:1;
    BP_BIT_FIELD prm_r:1;
    BP_BIT_FIELD prm_cr:1;
    BP_BIT_FIELD auto_prm:1;
} BP_PACKED2 FR8370_PERF_REPORT_MESSAGE;        /* 0AA  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD fec:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_TDL1_FIFO_EMPTY_CONTROL;           /* 0AB  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:8;
} BP_PACKED2 FR8370_TDL1_EOM_CONTROL;       /* 0AC  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tdl1:8;
} BP_PACKED2 FR8370_TX_DATA_LINK_FIFO;               /* 0AD  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tfull:1;
    BP_BIT_FIELD tnear:1;
    BP_BIT_FIELD tmpty:1;
    BP_BIT_FIELD tmsg1:1;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_TDL1_STATUS;                       /* 0AE  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD lds_2:8;
} BP_PACKED2 FR8370_DL2_TIMESLOT_ENABLE;               /* 0AF  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl2_bit:8;
} BP_PACKED2 FR8370_DL2_BIT_ENABLE;                    /* 0B0  */   

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rdl2_en:1;
    BP_BIT_FIELD tdl2_en:1;
    BP_BIT_FIELD dl2:2;
    BP_BIT_FIELD tdl2_rpt:1;
    BP_BIT_FIELD reserved:3;
} BP_PACKED2 FR8370_DL2_CONTROL;                       /* 0B1  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD fcc:6;
    BP_BIT_FIELD msg_fill:2;
} BP_PACKED2 FR8370_RDL2_FIFO_FILL_CONTROL;            /* 0B2  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD fec:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_TDL2_FIFO_EMPTY_CONTROL;           /* 0B6  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD reserved:8;
} BP_PACKED2 FR8370_TDL2_EOM_CONTROL;       /* 0B7  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tdl2:8;
} BP_PACKED2 FR8370_TX_DATA_LINK_FIFO2;              /* 0B8  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl_test:4;
    BP_BIT_FIELD reserved:4;
} BP_PACKED2 FR8370_DLINK_TEST_CONF1;                  /* 0BA  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl_test2:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_DLINK_TEST_STATUS2;                /* 0BB  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD send_prm:1;
    BP_BIT_FIELD dl_test3:6;
    BP_BIT_FIELD reserved:2;
} BP_PACKED2 FR8370_DLINK_TEST_STATUS3;                /* 0BC  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl_test4:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_DLINK_TEST_CONTROL1;      /* 0BD  */      

typedef BP_PACKED struct
{   
    BP_BIT_FIELD dl_test5:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_DLINK_TEST_CONTROL2;      /* 0BE  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD sbi:4;
    BP_BIT_FIELD embed:1;
    BP_BIT_FIELD emf:1;
    BP_BIT_FIELD sbi_oe:1;
    BP_BIT_FIELD x2clk:1;
} BP_PACKED2 FR8370_SYS_BUS_INTERFACE_CONF;            /* 0D0  */      

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rsbi:2;
    BP_BIT_FIELD rsb_ctr:1;
    BP_BIT_FIELD bus_frz:1;
    BP_BIT_FIELD rsyn_neg:1;
    BP_BIT_FIELD rpcm_neg:1;
    BP_BIT_FIELD sig_off:1;
    BP_BIT_FIELD bus_rsb:1;
} BP_PACKED2 FR8370_REC_SYS_BUS_CONF;                  /* 0D1  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD offset:3;
    BP_BIT_FIELD reserved:5;
} BP_PACKED2 FR8370_RSB_SYNC_BIT_OFFSET;               /* 0D2  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD offset:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_RSB_SYNC_TIMESLOT_OFFSET;          /* 0D3  */         

typedef BP_PACKED struct
{   
    BP_BIT_FIELD tsbi:2;
    BP_BIT_FIELD tsb_ctr:1;
    BP_BIT_FIELD tsb_align:1;
    BP_BIT_FIELD tsyn_neg:1;
    BP_BIT_FIELD tpcm_neg:1;
    BP_BIT_FIELD tx_align:1;
    BP_BIT_FIELD bus_tsb:1;
} BP_PACKED2 FR8370_TX_SYS_BUS_CONF;                 /* 0D4  */
                                                   
typedef BP_PACKED struct
{   
    BP_BIT_FIELD offset:3;
    BP_BIT_FIELD reserved:5;
} BP_PACKED2 FR8370_TSB_SYNC_BIT_OFFSET;               /* 0D5  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD offset:7;
    BP_BIT_FIELD reserved:1;
} BP_PACKED2 FR8370_TSB_SYNC_TIMESLOT_OFFSET;          /* 0D6  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD thru:1;
    BP_BIT_FIELD frz_on:1;
    BP_BIT_FIELD frz_off:1;
    BP_BIT_FIELD debounce:1;
    BP_BIT_FIELD unicode:1;
    BP_BIT_FIELD set_sig:1;
    BP_BIT_FIELD set_rsig:1;
    BP_BIT_FIELD reserved:1;

} BP_PACKED2 FR8370_REC_SIGNALING_CONF;                /* 0D7  */

typedef BP_PACKED struct
{   
    BP_BIT_FIELD offset:5;
    BP_BIT_FIELD reserved:3;
} BP_PACKED2 FR8370_RSYNC_FRAME_OFFSET;   /* 0D8  */      

typedef BP_PACKED struct
{   
    BP_BIT_FIELD rdly:1;
    BP_BIT_FIELD ruslip:1;
    BP_BIT_FIELD rfslip:1;
    BP_BIT_FIELD rsdir:1;
    BP_BIT_FIELD tdly:1;
    BP_BIT_FIELD tuslip:1;
    BP_BIT_FIELD tfslip:1;
    BP_BIT_FIELD tsdir:1;
} BP_PACKED2 FR8370_SLIP_BUFFER_STATUS;                /* 0D9  */

#endif /* end not BIT_REVERSE */

typedef BP_PACKED struct
{
   BP_U_8BIT version;                         /*  000  */
   BP_U_8BIT primary_ctrl_reg;                /*  001  */
   BP_U_8BIT jitter_attenuator_conf;          /*  002  */
   BP_U_8BIT int_request_reg;                 /*  003  */
   BP_U_8BIT alm_1_int_status;                /*  004  */
   BP_U_8BIT alm_2_int_status;                /*  005  */
   BP_U_8BIT err_int_status;                  /*  006  */
   BP_U_8BIT count_ovrfl_int_status;          /*  007  */
   BP_U_8BIT timer_int_status;                /*  008  */
   BP_U_8BIT dlink_1_int_status;              /*  009  */
   BP_U_8BIT dlink_2_int_status;              /*  00A  */
   BP_U_8BIT pat_int_status;                  /*  00B  */
   BP_U_8BIT alm_1_int_en_reg;                /*  00C  */
   BP_U_8BIT alm_2_int_en_reg;                /*  00D  */
   BP_U_8BIT err_int_en_reg;                  /*  00E  */
   BP_U_8BIT count_ovrfl_int_en_reg;          /*  00F  */
   BP_U_8BIT timer_int_en_reg;                /*  010  */
   BP_U_8BIT dlink_1_int_en_reg;              /*  011  */
   BP_U_8BIT dlink_2_int_en_reg;              /*  012  */
   BP_U_8BIT pat_int_en_reg;                  /*  013  */
   BP_U_8BIT lb_conf_reg;                     /*  014  */
   BP_U_8BIT ext_dlink_ts;                    /*  015  */
   BP_U_8BIT ext_dlink_bit;                   /*  016  */
   BP_U_8BIT offline_framer_status;           /*  017  */
   BP_U_8BIT program_input_output;            /*  018  */
   BP_U_8BIT program_output_en;               /*  019  */
   BP_U_8BIT clock_input_mux;                 /*  01A  */
   BP_U_8BIT test_mux_conf;                   /*  01B  */
   BP_U_8BIT test_conf;                       /*  01C  */
   BP_U_8BIT reserved_a[3];                   /*  01D -1F  */
   BP_U_8BIT liu_conf;                        /*  020  */
   BP_U_8BIT rec_liu_status;                  /*  021  */
   BP_U_8BIT rec_liu_conf;                    /*  022  */
   BP_U_8BIT rpll_low_pass_filter;            /*  023  */
   BP_U_8BIT variable_gain_amp_max;           /*  024  */
   BP_U_8BIT eq_coeff_dt_reg;                 /*  025  */
   BP_U_8BIT eq_coeff_table_ptr;              /*  026  */
   BP_U_8BIT dt_slicer_threshold;             /*  027  */          
   BP_U_8BIT clock_slicer_threshold;          /*  028  */
   BP_U_8BIT variable_gain_amp_status;        /*  029  */
   BP_U_8BIT pre_eq;                          /*  02A  */
   BP_U_8BIT reserved_b[5];                   /*  02B - 02F  */
   BP_U_8BIT lms_adj_eq_coeff_status[8];      /*  030 - 037  */          
   BP_U_8BIT eq_gain_thresholds[5];           /*  038 - 03C  */          
   BP_U_8BIT reserved_c[3];                   /*  03D - 03F  */

/*********************************/
/*         Receive               */
/*         Registers             */
/*********************************/
   BP_U_8BIT recr_conf;                       /*  040  */
   BP_U_8BIT rec_test_pat_conf;               /*  041  */
   BP_U_8BIT rec_lb_code_det_conf;            /*  042  */
   BP_U_8BIT lb_active_code_pat;              /*  043  */
   BP_U_8BIT lb_deactive_code_pat;            /*  044  */
   BP_U_8BIT rec_alm_signal_conf;             /*  045  */          
   BP_U_8BIT alm_err_count_latch_conf;        /*  046  */
   BP_U_8BIT alm_1_status;                    /*  047  */
   BP_U_8BIT alm_2_status;                    /*  048  */          
   BP_U_8BIT alm_3_status;                    /*  049  */          
   BP_U_8BIT reserved_d[6];                   /*  04A - 04F  */

/*********************************/
/*    Performance Monitoring     */
/*         Registers             */
/*********************************/
   BP_U_8BIT frame_bit_err_count_lsb;         /*  050  */
   BP_U_8BIT frame_bit_err_count_msb;         /*  051  */
   BP_U_8BIT crc_err_count_lsb;               /*  052  */
   BP_U_8BIT crc_err_count_msb;               /*  053  */
   BP_U_8BIT line_cd_viol_count_lsb;          /*  054  */
   BP_U_8BIT line_cd_viol_count_msb;          /*  055  */
   BP_U_8BIT farend_blck_err_count_lsb;       /*  056  */
   BP_U_8BIT farend_blck_err_count_msb;       /*  057  */
   BP_U_8BIT prbs_bit_err_count_lsb;          /*  058  */
   BP_U_8BIT prbs_bit_err_count_msb;          /*  059  */
   BP_U_8BIT sef_lof_cofa_alm_count;          /*  05A  */
   BP_U_8BIT rec_sa4_byte_buff;               /*  05B  */
   BP_U_8BIT rec_sa5_byte_buff;               /*  05C  */
   BP_U_8BIT rec_sa6_byte_buff;               /*  05D  */
   BP_U_8BIT rec_sa7_byte_buff;               /*  05E  */
   BP_U_8BIT rec_sa8_byte_buff;               /*  05F  */

/*********************************/
/*        Transmit LIU           */
/*         Registers             */

/*********************************/
   BP_U_8BIT tran_pulse_shape_conf[8];        /*  060 - 067  */
   BP_U_8BIT tran_liu_conf;                   /*  068  */
   BP_U_8BIT reserved_e[7];                   /*  069 - 06F  */

/*********************************/
/*         Transmit              */
/*         Registers             */
/*********************************/
   BP_U_8BIT tran_framer_conf;                /*  070  */
   BP_U_8BIT transmiter_conf;                 /*  071  */
   BP_U_8BIT tran_frame_format;               /*  072  */
   BP_U_8BIT tran_err_insert;                 /*  073  */
   BP_U_8BIT tran_man_sa_bt_febe_conf;        /*  074  */
   BP_U_8BIT tran_alm_signal_conf;            /*  075  */
   BP_U_8BIT tran_test_pat_conf;              /*  076  */
   BP_U_8BIT tran_inband_lb_code_conf;        /*  077  */
   BP_U_8BIT tran_inband_lb_code_pat;         /*  078  */
   BP_U_8BIT reserved_f[2];                   /*  079 - 07A  */

/*********************************/
/*      Transmit Sa_Byte         */
/*         Registers             */
/*********************************/
   BP_U_8BIT tran_sa4_byte_buffer;            /*  07B  */
   BP_U_8BIT tran_sa5_byte_buffer;            /*  07C  */
   BP_U_8BIT tran_sa6_byte_buffer;            /*  07D  */
   BP_U_8BIT tran_sa7_byte_buffer;            /*  07E  */
   BP_U_8BIT tran_sa8_byte_buffer;            /*  07F  */
   BP_U_8BIT reserved_g[16];                  /*  080 - 08F  */

/*********************************/
/*      Clock Rate Adapt         */
/*         Registers             */
/*********************************/
   BP_U_8BIT clock_rate_adaptor_conf;         /*  090  */
   BP_U_8BIT clad_frequency_select;           /*  091  */
   BP_U_8BIT clad_phase_det_scale_factor;     /*  092  */
   BP_U_8BIT clad_test;                       /*  093  */
   BP_U_8BIT reserved_h[12];                  /*  094 - 09F  */

/*********************************/
/*      Bit-Orientated Protocol  */
/*         Registers             */
/*********************************/
   BP_U_8BIT bit_orient_protocol_tx;          /*  0A0  */
   BP_U_8BIT tran_bop_codeword;               /*  0A1  */
   BP_U_8BIT rec_bop_codeword;                /*  0A2  */
   BP_U_8BIT bop_status;                      /*  0A3  */

/*********************************/
/*         Data Link             */
/*         Registers             */
/*********************************/
   BP_U_8BIT dl1_ts_en;                       /*  0A4  */
   BP_U_8BIT dl1_bit_en;                      /*  0A5  */
   BP_U_8BIT dl1_ctrl;                        /*  0A6  */
   BP_U_8BIT rdl1_fifo_fill_ctrl;             /*  0A7  */
   BP_U_8BIT rec_dlink_fifo1;                 /*  0A8  */
   BP_U_8BIT rdl1_status;                     /*  0A9  */
   BP_U_8BIT performance_report_mess;         /*  0AA  */
   BP_U_8BIT tdl1_fifo_empty_ctrl;            /*  0AB  */
   BP_U_8BIT tdl1_end_of_mess_ctrl;           /*  0AC  */
   BP_U_8BIT tran_dlink_fifo;                 /*  0AD  */
   BP_U_8BIT tdl1_status;                     /*  0AE  */
   BP_U_8BIT dl2_ts_en;                       /*  0AF  */
   BP_U_8BIT dl2_bit_en;                      /*  0B0  */
   BP_U_8BIT dl2_ctrl;                        /*  0B1  */
   BP_U_8BIT rdl2_fifo_fill_ctrl;             /*  0B2  */
   BP_U_8BIT rec_dlink_fifo2;                 /*  0B3  */
   BP_U_8BIT rdl2_status;                     /*  0B4  */
   BP_U_8BIT reserved_i[1];                   /*  0B5  */
   BP_U_8BIT tdl2_fifo_empty_ctrl;            /*  0B6  */
   BP_U_8BIT tdl2_end_of_mess_ctrl;           /*  0B7  */
   BP_U_8BIT tran_dlink_fifo2;                /*  0B8  */
   BP_U_8BIT tdl2_status;                     /*  0B9  */
   BP_U_8BIT dlink_test_conf1;                /*  0BA  */
   BP_U_8BIT dlink_test_status2;              /*  0BB  */
   BP_U_8BIT dlink_test_status3;              /*  0BC  */
   BP_U_8BIT dlink_test_control1;             /*  0BD  */
   BP_U_8BIT dlink_test_control2;             /*  0BE  */
   BP_U_8BIT reserved_j[17];                  /*  0BF - 0CF  */

/*********************************/
/*         System Bus            */
/*         Registers             */
/*********************************/
   BP_U_8BIT sys_bus_interface_conf;          /*  0D0  */
   BP_U_8BIT rec_sys_bus_conf;                /*  0D1  */
   BP_U_8BIT rsb_sync_bit_offset;             /*  0D2  */
   BP_U_8BIT rsb_sync_ts_offset;              /*  0D3  */
   BP_U_8BIT tran_sys_bus_conf;               /*  0D4  */
   BP_U_8BIT tsb_sync_bit_offset;             /*  0D5  */
   BP_U_8BIT tsb_sync_ts_offset;              /*  0D6  */
   BP_U_8BIT rec_sig_conf;                    /*  0D7  */
   BP_U_8BIT rsync_frame_offset;          /*  0D8  */
   BP_U_8BIT slip_buffer_status;              /*  0D9  */
   BP_U_8BIT rec_sig_stack;                   /*  0DA  */
   BP_U_8BIT rslip_phase_status;              /*  0DB  */
   BP_U_8BIT tslip_phase_status;              /*  0DC  */
   BP_U_8BIT ram_parity_status;               /*  0DD  */
   
} BP_PACKED2 FR8370_PTR;

typedef BP_PACKED struct 
{                                                             /* Addr (Hex)  */
    /**********************/                                  /* Base Address*/
    /* ctrl and status */
    /**********************/

   FRAMER_VERSION version;                                         /*  000  */
   FR8370_PRIMARY_CONTROL_REG primary_ctrl_reg;                    /*  001  */
   FR8370_JITTER_ATTEN_CONF jitter_attenuator_conf;                /*  002  */
   BP_U_8BIT int_request_reg;                                      /*  003  */
   FR8370_ALARM_1_INT_STATUS alm_1_int_status;                     /*  004  */
   BP_U_8BIT alm_2_int_status;                                     /*  005  */
   FR8370_ERROR_INT_STATUS err_int_status;                         /*  006  */
   BP_U_8BIT count_ovrfl_int_status;                               /*  007  */
   FR8370_TIMER_INT_STATUS timer_int_status;                       /*  008  */
   BP_U_8BIT dlink_1_int_status;                                   /*  009  */
   BP_U_8BIT dlink_2_int_status;                                   /*  00A  */
   BP_U_8BIT pat_int_status;                                       /*  00B  */
   FR8370_ALARM_1_INT_ENABLE_REG alm_1_int_en_reg;                 /*  00C  */
   FR8370_ALARM_2_INT_ENABLE_REG alm_2_int_en_reg;                 /*  00D  */
   FR8370_ERROR_INT_ENABLE_REG err_int_en_reg;                     /*  00E  */
   FR8370_COUNT_OVRFL_INT_EN_REG count_ovrfl_int_en_reg;       /*  00F  */
   FR8370_TIMER_INT_ENABLE_REG timer_int_en_reg;                   /*  010  */
   FR8370_DATA_LINK_1_INT_EN_REG dlink_1_int_en_reg;           /*  011  */
   FR8370_DATA_LINK_2_INT_EN_REG dlink_2_int_en_reg;           /*  012  */
   FR8370_PATTERN_INT_ENABLE_REG pat_int_en_reg;                   /*  013  */
   FR8370_LB_CONF_REG lb_conf_reg;                                 /*  014  */
   FR8370_EXT_DATA_LINK_TIMESLOT ext_dlink_ts;                /*  015  */
   FR8370_EXTERNAL_DATA_LINK_BIT ext_dlink_bit;                    /*  016  */
   FR8370_OFFLINE_FRAMER_STATUS offline_framer_status;             /*  017  */
   FR8370_PROGRAM_INPUT_OUTPUT program_input_output;               /*  018  */  
   FR8370_PROGRAM_OUTPUT_ENABLE program_output_en;                 /*  019  */   
   FR8370_CLOCK_INPUT_MUX clock_input_mux;                         /*  01A  */
   FR8370_TEST_MUX_CONF test_mux_conf;                             /*  01B  */
   FR8370_TEST_CONF test_conf;                                     /*  01C  */
   BP_U_8BIT reserved_a[3];                                        /*  01D-01F  */
   FR8370_LIU_CONF liu_conf;                                       /*  020  */
   BP_U_8BIT rec_liu_status;                                       /*  021  */
   FR8370_REC_LIU_CONF rec_liu_conf;                               /*  022  */
   FR8370_RPLL_LOW_PASS_FILTER rpll_low_pass_filter;               /*  023  */
   FR8370_VARIABLE_GAIN_AMP_MAX variable_gain_amp_max;             /*  024  */
   FR8370_EQ_COEFF_DATA_REG eq_coeff_dt_reg;                       /*  025  */
   FR8370_EQ_COEFF_TABLE_PTR eq_coeff_table_ptr;                   /*  026  */
   FR8370_DATA_SLICER_THRESHOLD dt_slicer_threshold;               /*  027  */
   FR8370_CLOCK_SLICER_THRESHOLD clock_slicer_threshold;           /*  028  */
   BP_U_8BIT variable_gain_amp_status;                             /*  029  */
   FR8370_PRE_EQ pre_eq;                                           /*  02A  */
   BP_U_8BIT reserved_b[5];                                        /*  02B-02F  */
   BP_U_8BIT lms_adj_eq_coeff_status[8];                           /*  030-037  */
   BP_U_8BIT eq_gain_thresholds[5];                                /*  038-03C  */
   BP_U_8BIT reserved_c[3];                                        /*  03D-03F  */
   FR8370_RECR_CONF recr_conf;                                     /*  040  */
   FR8370_REC_TEST_PATTERN_CONF rec_test_pat_conf;                 /*  041  */
   FR8370_REC_LB_CODE_DET_CONF recieve_lb_code_det_conf;           /*  042  */
   FR8370_LB_ACTIVATE_CODE_PATTERN lb_active_code_pat;             /*  043  */
   FR8370_LB_DEACTIVATE_CODE_PAT lb_deactive_code_pat;         /*  044  */
   FR8370_REC_ALARM_SIGNAL_CONF rec_alm_signal_conf;               /*  045  */
   FR8370_ERROR_LATCH_CONF alm_err_count_latch_conf;   /*  046  */
   FR8370_ALARM_1_INT_STATUS alm_1_status;                         /*  047  */
   BP_U_8BIT alm_2_status;                                         /*  048  */
   BP_U_8BIT alm_3_status;                                         /*  049  */
   BP_U_8BIT reserved_d[6];                                        /*  04A-04F  */
   BP_U_8BIT frame_bit_err_count_lsb;                              /*  050  */
   BP_U_8BIT frame_bit_err_count_msb;                              /*  051  */
   BP_U_8BIT crc_err_count_lsb;                                    /*  052  */
   BP_U_8BIT crc_err_count_msb;                                    /*  053  */
   BP_U_8BIT line_cd_viol_count_lsb;                               /*  054  */
   BP_U_8BIT line_cd_viol_count_msb;                               /*  055  */
   BP_U_8BIT farend_blck_err_count_lsb;                            /*  056  */
   BP_U_8BIT farend_blck_err_count_msb;                            /*  057  */
   BP_U_8BIT prbs_bit_err_count_lsb;                               /*  058  */
   BP_U_8BIT prbs_bit_err_count_msb;                               /*  059  */
   BP_U_8BIT sef_lof_cofa_alm_count;                               /*  05A  */
   BP_U_8BIT rec_sa4_byte_buff;                                    /*  05B  */
   BP_U_8BIT rec_sa5_byte_buff;                                    /*  05C  */
   BP_U_8BIT rec_sa6_byte_buff;                                    /*  05D  */
   BP_U_8BIT rec_sa7_byte_buff;                                    /*  05E  */
   BP_U_8BIT rec_sa8_byte_buff;                                    /*  05F works to here */
   FR8370_TX_PULSE_SHAPE_CONF tran_pulse_shape_conf[8];          /*  060-067  */
   FR8370_TX_LIU_CONF tran_liu_conf;                             /*  068  */
   BP_U_8BIT reserved_e[7];                                        /*  069-06F  */
   FR8370_TX_FRAMER_CONF tran_framer_conf;                       /*  070  */
   FR8370_TRANSMITER_CONF transmiter_conf;                         /*  071  */
   FR8370_TX_FRAME_FORMAT tran_frame_format;                     /*  072  */
   FR8370_TX_ERROR_INSERT tran_err_insert;                       /*  073  */
   FR8370_TX_SA_BYTE_FEBE_CONF tran_man_sa_bt_febe_conf;  /*  074  */
   FR8370_TX_ALARM_SIGNAL_CONF tran_alm_signal_conf;             /*  075  */
   FR8370_TX_TEST_PATTERN_CONF tran_test_pat_conf;               /*  076  */
   FR8370_TX_INBAND_LB_CODE_CONF tran_inband_lb_code_conf;       /*  077  */
   FR8370_TX_INBAND_LB_CODE_PAT tran_inband_lb_code_pat;     /*  078  */
   BP_U_8BIT reserved_f[2];                                        /*  079-07A  */
   FR8370_TX_SA4_BYTE_BUFFER tran_sa4_byte_buffer;               /*  07B  */
   FR8370_TX_SA5_BYTE_BUFFER tran_sa5_byte_buffer;               /*  07C  */
   FR8370_TX_SA6_BYTE_BUFFER tran_sa6_byte_buffer;               /*  07D  */
   FR8370_TX_SA7_BYTE_BUFFER tran_sa7_byte_buffer;               /*  07E  */
   FR8370_TX_SA8_BYTE_BUFFER tran_sa8_byte_buffer;               /*  07F  */
   BP_U_8BIT reserved_g[16];                                       /*  080-08F  */
   FR8370_CLOCK_RATE_ADAPTOR_CONF clock_rate_adaptor_conf;         /*  090  */
   FR8370_CLAD_FREQUENCY_SELECT clad_frequency_select;             /*  091  */
   FR8370_CLAD_PHASE_DETECTOR clad_phs_det_scale_factor;   /*  092  */
   FR8370_CLAD_TEST clad_test;                                     /*  093  */
   BP_U_8BIT reserved_h[12];                                       /*  094-09F  */
   FR8370_BOP_TRANSCEIVER bit_orient_protocol_tx;       /*  0A0  */
   FR8370_TX_BOP_CODEWORD tran_bop_codeword;                     /*  0A1  */
   BP_U_8BIT rec_bop_codeword;                                     /*  0A2  */
   BP_U_8BIT bop_status;                                           /*  0A3  */
   FR8370_DL1_TIMESLOT_ENABLE dl1_ts_en;                           /*  0A4  */
   FR8370_DL1_BIT_ENABLE dl1_bit_en;                               /*  0A5  */
   FR8370_DL1_CONTROL dl1_ctrl;                                    /*  0A6  */
   FR8370_RDL1_FIFO_FILL_CONTROL rdl1_fifo_fill_ctrl;              /*  0A7  */
   BP_U_8BIT rec_dlink_fifo1;                                      /*  0A8  */
   BP_U_8BIT rdl1_status;                                          /*  0A9  */
   FR8370_PERF_REPORT_MESSAGE perform_report_mess;          /*  0AA  */
   FR8370_TDL1_FIFO_EMPTY_CONTROL tdl1_fifo_empty_ctrl;            /*  0AB  */
   FR8370_TDL1_EOM_CONTROL tdl1_end_mess_ctrl;          /*  0AC  */
   FR8370_TX_DATA_LINK_FIFO tran_dlink_fifo;                     /*  0AD  */
   FR8370_TDL1_STATUS tdl1_status;                                 /*  0AE  */
   FR8370_DL2_TIMESLOT_ENABLE dl2_ts_en;                           /*  0AF  */
   FR8370_DL2_BIT_ENABLE dl2_bit_en;                               /*  0B0  */
   FR8370_DL2_CONTROL dl2_ctrl;                                    /*  0B1  */
   FR8370_RDL2_FIFO_FILL_CONTROL rdl2_fifo_fill_ctrl;              /*  0B2  */
   BP_U_8BIT rec_dlink_fifo2;                                      /*  0B3  */
   BP_U_8BIT rdl2_status;                                          /*  0B4  */
   BP_U_8BIT reserved_i[1];                                        /*  0B5  */
   FR8370_TDL2_FIFO_EMPTY_CONTROL tdl2_fifo_empty_ctrl;            /*  0B6  */
   FR8370_TDL2_EOM_CONTROL tdl2_end_of_mess_ctrl;       /*  0B7  */
   FR8370_TX_DATA_LINK_FIFO2 tran_dlink_fifo2;                   /*  0B8  */
   BP_U_8BIT tdl2_status;                                          /*  0B9  */
   FR8370_DLINK_TEST_CONF1 dlink_test_conf1;                       /*  0BA  */
   FR8370_DLINK_TEST_STATUS2 dlink_test_status2;                   /*  0BB  */
   FR8370_DLINK_TEST_STATUS3 dlink_test_status3;                   /*  0BC  */
   FR8370_DLINK_TEST_CONTROL1 dlink_test_control1;                 /*  0BD  */
   FR8370_DLINK_TEST_CONTROL2 dlink_test_control2;                 /*  0BE  */
   BP_U_8BIT reserved_j[17];                                       /*  0BF-0CF  */
   FR8370_SYS_BUS_INTERFACE_CONF sys_bus_interface_conf;           /*  0D0  */
   FR8370_REC_SYS_BUS_CONF rec_sys_bus_conf;                       /*  0D1  */
   FR8370_RSB_SYNC_BIT_OFFSET rsb_sync_bit_offset;                 /*  0D2  */
   FR8370_RSB_SYNC_TIMESLOT_OFFSET rsb_sync_ts_offset;             /*  0D3  */
   FR8370_TX_SYS_BUS_CONF tran_sys_bus_conf;                     /*  0D4  */
   FR8370_TSB_SYNC_BIT_OFFSET tsb_sync_bit_offset;                 /*  0D5  */
   FR8370_TSB_SYNC_TIMESLOT_OFFSET tsb_sync_ts_offset;             /*  0D6  */
   FR8370_REC_SIGNALING_CONF rec_sig_conf;                         /*  0D7  */
   FR8370_RSYNC_FRAME_OFFSET rsync_frame_offset;  /*  0D8  */
   FR8370_SLIP_BUFFER_STATUS slip_buffer_status;                   /*  0D9  */
   BP_U_8BIT rec_sig_stack;                                        /*  0DA  */
   BP_U_8BIT rslip_phase_status;                                   /*  0DB  */
   BP_U_8BIT tslip_phase_status;                                   /*  0DC  */
   BP_U_8BIT ram_parity_status;                                    /*  0DD  */
} BP_PACKED2 FR8370_MODE_PTR;                                                                  


typedef BP_PACKED struct
{
  
   BP_U_8BIT sys_bus_per_chan_ctrl[32];                /*  0E0 - 0FF  */
   BP_U_8BIT tran_per_chan_ctrl[32];                   /*  100 - 11F  */
   BP_U_8BIT tran_sig_buff[32];                        /*  120 - 13F  */
   BP_U_8BIT tran_pcm_slip_buff_lo[32];                /*  140 - 15F  */
   BP_U_8BIT tran_pcm_slip_buff_hi[32];                /*  160 - 17F  */
   BP_U_8BIT rec_per_chan_ctrl[32];                    /*  180 - 19F  */
   BP_U_8BIT rec_sig_buff[32];                         /*  1A0 - 1BF  */
   BP_U_8BIT rec_pcm_slip_bufflo[32];                  /*  1C0 - 1DF  */
   BP_U_8BIT rec_pcm_slip_buffhi[32];                  /*  1E0 - 1FF  */

} BP_PACKED2 FR8370_RAM_BUFFER_PTR;

extern FR8370_PTR BP_XDATA * BP_XDATA fr8370_ptr; 
extern FR8370_MODE_PTR BP_XDATA * BP_XDATA fr8370_mode_ptr;
extern FR8370_RAM_BUFFER_PTR BP_XDATA * BP_XDATA fr8370_ram_buffer_ptr;

#endif /* BT8370_FRAMER */
#endif /*T1E1_FRAMER*/

