#ifdef T1E1_FRAMER


#ifdef BT8360_FRAMER

/* still need to add BIT_REVERSE support */

/*
 * BT8360 Framer Structures
 */

typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_esf_mode:1;
    BP_BIT_FIELD enable_zbtsi:1;
    BP_BIT_FIELD enable_b8zs_transmit:1;
    BP_BIT_FIELD enable_b8zs_receive:1;
    BP_BIT_FIELD enable_forced_vazo:1;
    BP_BIT_FIELD enable_t1dm:1;
    BP_BIT_FIELD enable_internal_transmit_clock:1;
    BP_BIT_FIELD enable_clock_recovery:1;
} BP_PACKED2 FR8360_CONFIGURATION_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD buffer_mode_control:2;
    BP_BIT_FIELD enable_transmit_frame_snyc:1;
    BP_BIT_FIELD enable_slip_buffer_frame_sync:1;
    BP_BIT_FIELD input_clock_freq_select:2;
    BP_BIT_FIELD output_clock_freq_select:2;
} BP_PACKED2 FR8360_INTERFACE_CLK_CNTRL_REG;


typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_external_fbit:1;
    BP_BIT_FIELD enable_external_crc_bit:1;
    BP_BIT_FIELD enable_external_dl_bit:1;
    BP_BIT_FIELD enable_external_zbit:1;
    BP_BIT_FIELD enable_network_loopback:1;
    BP_BIT_FIELD enable_line_loopback:1;
    BP_BIT_FIELD enable_equipment_loopback:1;
    BP_BIT_FIELD enable_payload_loopback:1;
} BP_PACKED2 FR8360_FRAME_BIT_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD sig_reinsertion_frame_offset:5;
    BP_BIT_FIELD freeze_signaling:1;
    BP_BIT_FIELD debounce_signaling:1;
    BP_BIT_FIELD disable_signaling_freeze:1;
} BP_PACKED2 FR8360_SIGNALING_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_crc_check:1;
    BP_BIT_FIELD enable_ft_only_framing:1;
    BP_BIT_FIELD enable_sf_transmit_framing:1;
    BP_BIT_FIELD enable_esf_transmit_framing:1;
    BP_BIT_FIELD enable_2_of_5_oof:1;
    BP_BIT_FIELD enable_2_of_6_oof:1;
    BP_BIT_FIELD disable_framing:1;
    BP_BIT_FIELD force_framing:1;
} BP_PACKED2 FR8360_FRAMING_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD slip_buffer_mvip_mode:1;
    BP_BIT_FIELD transmit_buffer_mvip_mode:1;
    BP_BIT_FIELD force_bipolar_violation:1;
    BP_BIT_FIELD force_frame_bit_error:1;
    BP_BIT_FIELD unicode_detection:1;
    BP_BIT_FIELD force_short_slip_buffer_delay:1;
    BP_BIT_FIELD enable_internal_slip_buffer_clk:1;
    BP_BIT_FIELD inhibit_signaling_reinsertion:1;
} BP_PACKED2 FR8360_SLIP_BUFFER_CONTROL_REG;


typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_transmit_ais:1;
    BP_BIT_FIELD enable_transmit_yellow_alarm:1;
    BP_BIT_FIELD enable_receive_ais:1;
    BP_BIT_FIELD enable_receive_yellow_alarm:1;
    BP_BIT_FIELD enable_oof_integration:1;
    BP_BIT_FIELD enable_sf_yellow_alarm_intg:1;
    BP_BIT_FIELD enable_excess_zero_counts:1;
    BP_BIT_FIELD enable_fs_ft_monitoring:1;
} BP_PACKED2 FR8360_ALARM_SIGNAL_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_los:1;
    BP_BIT_FIELD enable_oof:1;
    BP_BIT_FIELD enable_ais:1;
    BP_BIT_FIELD enable_yellow_alarm:1;
    BP_BIT_FIELD enable_signal_freeze:1;
    BP_BIT_FIELD enable_1_sec_latching_alarms:1;
    BP_BIT_FIELD enable_1_sec_latching_erros:1;
    BP_BIT_FIELD enable_1_sec_latching_counters:1;
} BP_PACKED2 FR8360_ALARM_AND_TIMING_INT_REG;


typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_pulse_density_violation:1;
    BP_BIT_FIELD enable_crc_error:1;
    BP_BIT_FIELD enable_frame_slip:1;
    BP_BIT_FIELD enable_severely_error_sf:1;
    BP_BIT_FIELD enable_bpv_counter:1;
    BP_BIT_FIELD enable_frame_bit_error_counter:1;
    BP_BIT_FIELD enable_crc_error_counter:1;
    BP_BIT_FIELD enable_cofa_counter:1;
} BP_PACKED2 FR8360_ERR_CNTR_INT_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD send_idle:1;
    BP_BIT_FIELD send_fcs:1;
    BP_BIT_FIELD send_abort:1;
    BP_BIT_FIELD enable_mop_mode:1;
    BP_BIT_FIELD message_octet_pointer:4;
} BP_PACKED2 FR8360_TX_DATA_LINK_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_rx_data_link_mop_int:1;
    BP_BIT_FIELD enable_rx_data_link_bop_int:1;
    BP_BIT_FIELD enable_2_kbits_rx_data_link:1;
    BP_BIT_FIELD enable_receive_unformatted_mode:1;
    BP_BIT_FIELD enable_g802_compatibility_mode:1;
    BP_BIT_FIELD enable_rx_output_frame_pattern:1;
    BP_BIT_FIELD enable_2_kbits_tx_data_link:1;
    BP_BIT_FIELD enable_signaling_stack_int:1;
} BP_PACKED2 FR8360_RX_DATA_LINK_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD enable_code_generation:1;
    BP_BIT_FIELD overwrite_frame_bit:1;
    BP_BIT_FIELD generation_code_len:2;
    BP_BIT_FIELD rx_activate_detect_code_len:2;
    BP_BIT_FIELD rx_deactivate_detect_code_len:2;
} BP_PACKED2 FR8360_LOOPBACK_CONTROL_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD reserved:1;
    BP_BIT_FIELD generation_code_sequence:7;
} BP_PACKED2 FR8360_LOOPBACK_GENERATION_REG;


typedef BP_PACKED struct
{
    BP_BIT_FIELD loopback_active_code_int:1;
    BP_BIT_FIELD loopback_active_code_sequence:7;
} BP_PACKED2 FR8360_LOOPBACK_ACTIVATE_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD loopback_deactive_code_int:1;
    BP_BIT_FIELD loopback_deactive_code_sequence:7;
} BP_PACKED2 FR8360_LOOPBACK_DEACTIVATE_REG;

typedef BP_PACKED struct
{
    BP_BIT_FIELD loss_of_signal:1;
    BP_BIT_FIELD out_of_frame:1;
    BP_BIT_FIELD alarm_indication_signal:1;
    BP_BIT_FIELD yellow_alarm:1;
    BP_BIT_FIELD signaling_freeze:1;
    BP_BIT_FIELD loopback_activate_detect:1;
    BP_BIT_FIELD loopback_deactivate_detect:1;
    BP_BIT_FIELD signaling_stack_interrupt:1;
} BP_PACKED2 FR8360_ALARM_STATUS;


typedef BP_PACKED struct
{
    BP_BIT_FIELD alarm_signal:1;
    BP_BIT_FIELD error:1;
    BP_BIT_FIELD rx_data_link:1;
    BP_BIT_FIELD tx_data_link:1;
    BP_BIT_FIELD bpv_counter:1;
    BP_BIT_FIELD f_bit_error_counter:1;
    BP_BIT_FIELD crc_error_counter:1;
    BP_BIT_FIELD cofa_counter:1;
} BP_PACKED2 FR8360_INTERRUPT_SOURCE;


typedef BP_PACKED struct 
{                                           /* Addr (Hex) */
    /***********/
    /* control */
    /***********/
    BP_U_8BIT configuration;                /*     00     */
    BP_U_8BIT clock_control;                /*     01     */
    BP_U_8BIT frame_bit_loopback_control;   /*     02     */
    BP_U_8BIT signaling_control;            /*     03     */ 
    BP_U_8BIT framing_control;              /*     04     */
    BP_U_8BIT slip_buffer_control;          /*     05     */
    BP_U_8BIT alarm_signal_control;         /*     06     */
    BP_U_8BIT alarm_timing_interrupt;       /*     07     */
    BP_U_8BIT error_counter_interrupt;      /*     08     */
    BP_U_8BIT transmit_data_link;           /*     09     */
    BP_U_8BIT receive_data_link;            /*     0A     */
    BP_U_8BIT lb_detection;                 /*     0B     */
    BP_U_8BIT lb_code_generation;           /*     0C     */
    BP_U_8BIT lb_activate_code;             /*     0D     */
    BP_U_8BIT lb_deactivate_code;           /*     0E     */

    /**********/
    /* status */
    /**********/
    BP_U_8BIT misc_status;                  /*     0F     */
    BP_U_8BIT alarm_status;                 /*     10     */
    BP_U_8BIT error_status;                 /*     11     */
    BP_U_8BIT rx_data_link_status;          /*     12     */
    BP_U_8BIT bipolar_violation0;           /*     13     */
    BP_U_8BIT bipolar_violation1;           /*     14     */
    BP_U_8BIT f_bit_err;                    /*     15     */
    BP_U_8BIT crc_err;                      /*     16     */
    BP_U_8BIT cofa;                         /*     17     */
    BP_U_8BIT interrupt_source;             /*     18     */
    BP_U_8BIT version;                      /*     19     */
    BP_U_8BIT framing_status;               /*     1A     */
    BP_U_8BIT signaling_change_reg;         /*     1B     */
} BP_PACKED2 FR8360_PTR;


typedef BP_PACKED struct
{                                                             /* Addr (Hex) */
    /***********/
    /* control */
    /***********/
    FR8360_CONFIGURATION_REG configuration;                   /*     00     */
    FR8360_INTERFACE_CLK_CNTRL_REG clock_control;         /*     01     */
    FR8360_FRAME_BIT_CONTROL_REG frame_bit_loopback_control;  /*     02     */
    FR8360_SIGNALING_CONTROL_REG signaling_control;           /*     03     */ 
    FR8360_FRAMING_CONTROL_REG framing_control;               /*     04     */
    FR8360_SLIP_BUFFER_CONTROL_REG slip_buffer_control;       /*     05     */
    FR8360_ALARM_SIGNAL_CONTROL_REG alarm_signal_control;     /*     06     */
    FR8360_ALARM_AND_TIMING_INT_REG alarm_timing_interrupt;   /*     07     */
    FR8360_ERR_CNTR_INT_REG error_counter_interrupt; /*     08     */
    FR8360_TX_DATA_LINK_CONTROL_REG transmit_data_link; /*     09     */
    FR8360_RX_DATA_LINK_CONTROL_REG receive_data_link;   /*     0A     */
    FR8360_LOOPBACK_CONTROL_REG lb_detection;                 /*     0B     */
    FR8360_LOOPBACK_GENERATION_REG lb_code_generation;        /*     0C     */
    FR8360_LOOPBACK_ACTIVATE_REG lb_activate_code;            /*     0D     */
    FR8360_LOOPBACK_DEACTIVATE_REG lb_deactivate_code;        /*     0E     */

    /**********/
    /* status */
    /**********/
    BP_U_8BIT misc_status;                      /*     0F     */
    FR8360_ALARM_STATUS alarm_status;           /*     10     */
    BP_U_8BIT error_status;                     /*     11     */
    BP_U_8BIT rx_data_link_status;              /*     12     */
    BP_U_8BIT bipolar_violation0;               /*     13     */
    BP_U_8BIT bipolar_violation1;               /*     14     */
    BP_U_8BIT f_bit_err;                        /*     15     */
    BP_U_8BIT crc_err;                          /*     16     */
    BP_U_8BIT cofa;                             /*     17     */
    FR8360_INTERRUPT_SOURCE interrupt_source;   /*     18     */
    BP_U_8BIT version;                          /*     19     */
    BP_U_8BIT framing_status;                   /*     1A     */
    BP_U_8BIT signaling_change_reg;             /*     1B     */
} BP_PACKED2 FR8360_MODE_PTR;


typedef BP_PACKED struct
{
    BP_U_8BIT rate_convertor[32];           /* 100 -- 11F */
    BP_U_8BIT unused_1;                     /*    120     */
    BP_U_8BIT tx_pcm_control[24];           /* 121 -- 138 */
    BP_U_8BIT unused_2[8];                  /* 139 -- 140 */
    BP_U_8BIT rx_pcm_control[24];           /* 141 -- 158 */
    BP_U_8BIT unused_3[7];                  /* 159 -- 15F */
    BP_U_8BIT tx_rx_pcm_buffer[89];         /* 160 -- 1B8 */
    BP_U_8BIT unused_4[7];                  /* 1B9 -- 1BF */
    BP_U_8BIT tx_rx_signaling_buffer[64];   /* 1C0 -- 1FF */
} BP_PACKED2 FR8360_RAM_BUFFER_PTR;

extern FR8360_PTR BP_XDATA * BP_XDATA fr8360_ptr;
extern FR8360_MODE_PTR BP_XDATA * BP_XDATA fr8360_mode_ptr;
extern FR8360_RAM_BUFFER_PTR BP_XDATA * BP_XDATA fr8360_ram_buffer_ptr;

#endif /* BT8360_FRAMER */
#endif /* T1E1_FRAMER */
