/***************************************************
 *         Channel Unit Utility Header File        *
 ***************************************************/

extern BP_U_8BIT BP_XDATA num_bit_pumps;
extern BP_U_8BIT BP_XDATA bp_position[_NO_OF_LOOPS];



/*  -----------------------------------
 *  Function Prototypes:
 *      Channel unit utility functions.
 *  -----------------------------------*/
void _CuResetTxFIFO(void);
void _CuResetRxFIFO(void);
void _CuResetReceiver(void);
void _CuHandleFlags(void);
void _CuClearCounters(BP_U_8BIT loop, BP_U_8BIT cntr);
void _CuWriteMasterCmd5(void);
void _CuDpllOperation(BP_U_8BIT mode);
void _CuHdslToPra(BP_U_8BIT loop,BP_U_8BIT state);
void _CuUseSameTap(BP_U_8BIT loop,BP_U_8BIT tap);

#ifdef REPEATER
void _CuRepeaterConfigure(unsigned char state);
#endif

TX_WR *get_tx_wr_ptr(BP_U_8BIT loop);
RX_WR *get_rx_wr_ptr(BP_U_8BIT loop);
TX_RD *get_tx_rd_ptr(BP_U_8BIT loop);
RX_RD *get_rx_rd_ptr(BP_U_8BIT loop);
