#ifdef CHAN_UNIT

/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      cu_table.h
 *
 * FILE CREATED:  November 22, 1994
 *
 * LAST MODIFIED: [4-3-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   This file contains the Table Values for 2T1, 2E1, & 3E1.
 *                The actual array is defined in 'chanunit.c'
 *
 * FUNCTION LIST:
 *
 */

#ifdef MCLK_1024
#define CMD_1_INDEX                 0
#define TFRAME_LOC_LO_INDEX         1
#define TMF_LOC_INDEX               2
#define HFRAME_LEN_INDEX            3
#define FRAME_LEN_LO_INDEX          4
#define MFRAME_LEN_INDEX            5
#define MFRAME_CNT_INDEX            6
#define RFIFO_WL_LO_INDEX           7
#define STF_THRESH_A_LO_INDEX       8
#define STF_THRESH_B_LO_INDEX       9
#define STF_THRESH_C_LO_INDEX       10
#define DPLL_RESID_LO_INDEX         11
#define DPLL_RESID_HI_INDEX         12
#define DPLL_FACTOR_INDEX           13
#define DPLL_DLY_LO_INDEX           14
#define DPLL_PINI_INDEX             15
#else
#define CMD_1_INDEX                 0
#define TFRAME_LOC_LO_INDEX         1
#define TMF_LOC_INDEX               2
#define HFRAME_LEN_INDEX            3
#define HFRAME_LEN_HI_INDEX         4
#define HFRAME2_LEN_INDEX           5
#define HFRAME2_LEN_HI_INDEX        6
#define HFRAME3_LEN_INDEX           7
#define HFRAME3_LEN_HI_INDEX        8
#define FRAME_LEN_LO_INDEX          9
#define MFRAME_LEN_INDEX            10
#define MFRAME_CNT_INDEX            11
#define RFIFO_WL_LO_INDEX           12
#define RFIFO_WL_HI_INDEX           13
#define STF_THRESH_A_LO_INDEX       14
#define STF_THRESH_A_HI_INDEX       15
#define STF_THRESH_B_LO_INDEX       16
#define STF_THRESH_B_HI_INDEX       17
#define STF_THRESH_C_LO_INDEX       18
#define STF_THRESH_C_HI_INDEX       19
#define DPLL_RESID_LO_INDEX         20
#define DPLL_RESID_HI_INDEX         21
#define DPLL_FACTOR_INDEX           22
#define DPLL_DLY_LO_INDEX           23
#define DPLL_PINI_INDEX             24
#define RFRAME_LOC_LO_INDEX         25
#define RMF_LOC_INDEX               26
#endif /*not MCLK_1024*/
                      

extern BP_U_8BIT BP_XDATA rate_index;
#ifdef MCLK_1024                    
extern BP_U_8BIT BP_XDATA rate_values[][4];
#else /*not 1024*/
extern BP_U_8BIT BP_XDATA rate_values[][6];
#endif /*1024*/
extern BP_U_8BIT BP_XDATA htu_index;

#endif /* CHAN_UNIT */
