/*****************************************  
 *  Performance Monitoring Header File   *
 *****************************************/

/* Interval definitions for network managements                     */
#define INTERVAL1 900 /* 15 * 60 = 900; 15 minutes for every second */
#define INTERVAL2 96  /* 24h * 4 = 96; 1h = 4 quarters              */
#define INTERVAL3 7   /* 1w = 7 days;                               */

/* Global variables needed for network managements */
extern BP_U_32BIT   APPL_SW_MSPACE running_seconds[_NO_OF_LOOPS];
extern BP_U_8BIT    APPL_SW_MSPACE frame_cnt[_NO_OF_LOOPS];/*slipflag[_NO_OF_LOOPS];*/

extern BP_U_16BIT   APPL_SW_MSPACE head1[_NO_OF_LOOPS], tail1[_NO_OF_LOOPS], interval1_count[_NO_OF_LOOPS];
extern BP_U_8BIT    APPL_SW_MSPACE head2[_NO_OF_LOOPS], tail2[_NO_OF_LOOPS], interval2_count[_NO_OF_LOOPS];
extern BP_U_8BIT    APPL_SW_MSPACE head3[_NO_OF_LOOPS], tail3[_NO_OF_LOOPS], interval3_count[_NO_OF_LOOPS];
extern BP_U_32BIT   APPL_SW_MSPACE available_sec[_NO_OF_LOOPS];
extern BP_U_8BIT    APPL_SW_MSPACE crc_interval1[INTERVAL1][_NO_OF_LOOPS];
extern BP_U_8BIT    APPL_SW_MSPACE febe_interval1[INTERVAL1][_NO_OF_LOOPS];
extern BP_U_32BIT   APPL_SW_MSPACE crc_interval2[INTERVAL2][_NO_OF_LOOPS];
extern BP_U_32BIT   APPL_SW_MSPACE febe_interval2[INTERVAL2][_NO_OF_LOOPS];
extern BP_U_32BIT   APPL_SW_MSPACE crc_interval3[INTERVAL3][_NO_OF_LOOPS];
extern BP_U_32BIT   APPL_SW_MSPACE febe_interval3[INTERVAL3][_NO_OF_LOOPS];

/* Function Prototypes */
void UpdatePMRecord( BP_U_8BIT loop );
void InitPMRecord( BP_U_8BIT loop );
void UpdateInterval1( BP_U_8BIT loop );
void UpdateInterval2( BP_U_8BIT loop );
void UpdateInterval3( BP_U_8BIT loop );
