/***********************************************************/
/*    CU_PERF.C                                            */
/*    (C) Copyright 1998 by Rockwell Semiconductor Systems */
/*                                                         */
/*                                                         */
/* Description:                                            */
/*    These are the performance monitoring functions.      */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*                                                         */
/* List of Functions found in this module:                 */
/*                                                         */
/*      - UpdatePMRecord( BP_U_8BIT loop );                */
/*      - InitPMRecord( BP_U_8BIT loop );                  */
/*      - UpdateInterval1( BP_U_8BIT loop );               */
/*      - UpdateInterval2( BP_U_8BIT loop );               */
/*      - UpdateInterval3( BP_U_8BIT loop );               */
/*                                                         */
/* Revision History:                                       */
/*     date/name of reviser                                */
/*                                                         */
/* Oct 98 - New: Laura Yuan                                */
/*                                                         */
/***********************************************************/

#include "chanunit.h"

#ifdef CHAN_UNIT
#ifdef PERF_MONITOR

BP_U_8BIT   APPL_SW_MSPACE frame_cnt[_NO_OF_LOOPS];
BP_U_32BIT  APPL_SW_MSPACE running_seconds[_NO_OF_LOOPS];
BP_U_16BIT  APPL_SW_MSPACE head1[_NO_OF_LOOPS], tail1[_NO_OF_LOOPS], interval1_count[_NO_OF_LOOPS];
BP_U_8BIT   APPL_SW_MSPACE head2[_NO_OF_LOOPS], tail2[_NO_OF_LOOPS], interval2_count[_NO_OF_LOOPS];
BP_U_8BIT   APPL_SW_MSPACE head3[_NO_OF_LOOPS], tail3[_NO_OF_LOOPS], interval3_count[_NO_OF_LOOPS];
BP_U_32BIT  APPL_SW_MSPACE available_sec[_NO_OF_LOOPS];
BP_U_8BIT   APPL_SW_MSPACE crc_interval1[INTERVAL1][_NO_OF_LOOPS]; 
BP_U_8BIT   APPL_SW_MSPACE febe_interval1[INTERVAL1][_NO_OF_LOOPS];            
BP_U_32BIT  APPL_SW_MSPACE crc_interval2[INTERVAL2][_NO_OF_LOOPS];
BP_U_32BIT  APPL_SW_MSPACE febe_interval2[INTERVAL2][_NO_OF_LOOPS];
BP_U_32BIT  APPL_SW_MSPACE crc_interval3[INTERVAL3][_NO_OF_LOOPS];
BP_U_32BIT  APPL_SW_MSPACE febe_interval3[INTERVAL3][_NO_OF_LOOPS];


void UpdatePMRecord( BP_U_8BIT loop )
{
    UpdateInterval1(loop);
    if ( ( running_seconds[loop] - interval1_count[loop] * INTERVAL1 ) >= INTERVAL1 )
    {
        interval1_count[loop]++;     
        UpdateInterval2(loop);
        if ( (interval1_count[loop] - interval2_count[loop] * INTERVAL2 ) >= INTERVAL2 )                 
        {  
            interval2_count[loop]++;
            UpdateInterval3(loop);
            if ( (interval2_count[loop] - interval3_count[loop] * INTERVAL3 ) >= INTERVAL3 )
                interval3_count[loop]++;
        }
    }    
}/* End of UpdatePMRecord */

void UpdateInterval1( BP_U_8BIT loop)
{
    tail1[loop]++;
    tail1[loop] = tail1[loop] % INTERVAL1;
    
    if ( interval1_count[loop] != 0 )
    {    
        head1[loop]++;
        head1[loop] = head1[loop] % INTERVAL1;                  
    }
    
    /* Check the current CRC errors */
    crc_interval1[tail1[loop]][loop] = LOW( error_ctrs[_CU_CRC_ERR_CTR][loop] );
    febe_interval1[tail1[loop]][loop] = LOW ( error_ctrs[_CU_FEBE_ERROR_CTR][loop] );        
}

void UpdateInterval2( BP_U_8BIT loop )
{
    BP_U_16BIT i;

    tail2[loop]++;
    tail2[loop] = tail2[loop] % INTERVAL2;
        
    if ( interval2_count[loop] != 0 )
    {          
        head2[loop]++;
        head2[loop] = head2[loop] % INTERVAL2;
    }
    
    crc_interval2[tail2[loop]][loop] = 0;
    febe_interval2[tail2[loop]][loop] = 0;
    
    /* Calculate the sum of all the crc errors happened in the last INTERVAL1 time frame */
    for ( i = 0; i < INTERVAL1; i++ )
    {
        crc_interval2[tail2[loop]][loop] += crc_interval1[i][loop];
        febe_interval2[tail2[loop]][loop] += febe_interval1[i][loop];
    }
}

void UpdateInterval3( BP_U_8BIT loop )
{
    BP_U_16BIT i;

    tail3[loop]++;
    tail3[loop] = tail3[loop] % INTERVAL3;
        
    if ( interval3_count[loop] != 0 )
    {          
        head3[loop]++;
        head3[loop] = head3[loop] % INTERVAL3;
    }
    
    crc_interval3[tail3[loop]][loop] = 0;
    febe_interval3[tail3[loop]][loop] = 0;
    
    /* Calculate the sum of all the crc errors happened in the last INTERVAL2 time frame */
    for ( i = 0; i < INTERVAL2; i++ )
    {
        crc_interval3[tail3[loop]][loop] += crc_interval2[i][loop];
        febe_interval3[tail3[loop]][loop] += febe_interval2[i][loop];
    }
}

void InitPMRecord( BP_U_8BIT loop )
{
    BP_U_16BIT i;

    for ( i = 0; i < INTERVAL1; i++ )
    {
        crc_interval1[i][loop] = 0;
        febe_interval1[i][loop] = 0;
    }

    for ( i = 0; i < INTERVAL2; i++ )
    {
        crc_interval2[i][loop] = 0;
        febe_interval2[i][loop] = 0;
    }

    for ( i = 0; i < INTERVAL3; i++ )
    {
        crc_interval3[i][loop] = 0;
        febe_interval3[i][loop] = 0;
    }

    running_seconds[loop] = 0;
    interval1_count[loop] = 0;
    interval2_count[loop] = 0;
    interval3_count[loop] = 0;
    head1[loop] = 0;
    tail1[loop] = -1;
    head2[loop] = 0;
    tail2[loop] = -1;
    head3[loop] = 0;
    tail3[loop] = -1;
    frame_cnt[loop] = 0;
    system_flags[loop].bits.slipflag = 0;

}/* End of InitPMRecord */

#endif /* PERF_MONITOR */
#endif /* CHAN_UNIT */
