#ifdef CHAN_UNIT


/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      cu_led.c
 *
 * FILE CREATED:  October 11, 1994
 *
 * LAST MODIFIED: [5-28-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   This file contains Channel Unit LED functions.
 *
 *
 * FUNCTION LIST:
 *                set_LED_block()
 */

#include "chanunit.h"

#ifdef CU_LED
/*
 * Globals
 */
CU_PCM_LED_BLOCK BP_XDATA cu_pcm_led_block;
CU_BP_LED_BLOCK BP_XDATA cu_bp_led_block[_NUM_BP_LED_BYTES];
CU_LED_BLOCK BP_XDATA cu_led_block[_NO_OF_LOOPS];
MISC_TERM BP_XDATA misc_term;        
MISC_TEST_P BP_XDATA misc_test_p; 


/* [CU1 & CU2], [CU3 & PCM], [BP1/2, BP3/SPARE], MISC_TERM */
BP_U_8BIT BP_XDATA led_blocks[] = {0x00, 0x00, 0x00, 0x00}; 

/*
 * Definitions
 */                          
#define CH1_LED_ADDR        0xC600
#define CH2_LED_ADDR        0xC600    
#define CH3_LED_ADDR        0xC800    
#define PCM_LED_ADDR        0xC800
#define BP12_LED_ADDR       0xCA00      
#define BP3S_LED_ADDR       0xCA00
#define MISC_TERM_ADDR      0xCC00      
#define MISC_SPAR_ADDR      0xCC00


/*
 * FUNCTION:   set_LED_block
 *
 * PARAMETERS: no - which block
 *             request - SET/ON/OFF
 *             parameter - data
 *
 * PURPOSE:    This function sets the specified LED block.  The bits of
 *             a register block can be set ON/OFF individually or as a
 *             whole.
 *             
 * RETURN:     SUCCESS - Successfully Completed Operation
 *
 * NOTES:      
 *
 * CHANGES:    October 11, 1994    NEW   -   Dean Rasmussen
 */
void set_LED_block (BP_U_8BIT no, BP_U_8BIT request, BP_U_8BIT parameter)
{
    BP_U_8BIT BP_XDATA *led_addr_ptr;
    BP_U_8BIT nibble, index;

    switch ( no ){

        case _BP_LED_BLOCK1_2:      
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)BP12_LED_ADDR;
            index = 2;
            nibble = 0;
            break;

        case _BP_LED_BLOCK3_SP:
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)BP3S_LED_ADDR;
            index = 2;
            nibble = 1;
            break;

        case _MISC_TERM:   
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)MISC_TERM_ADDR;
            index = 3;
            nibble = 0;
            break;

        case _MISC_TEST_P:
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)MISC_SPAR_ADDR;
            index = 3;
            nibble = 1;
            break;

        case _CU_LED_CHAN1:    
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)CH1_LED_ADDR;
            index = 0;
            nibble = 0;
            break;

        case _CU_LED_CHAN2:    
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)CH2_LED_ADDR;
            index = 0;
            nibble = 1;
            break;

        case _CU_LED_CHAN3:    
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)CH3_LED_ADDR;
            index = 1;
            nibble = 0;
            break;

        case _CU_PCM_COMMON: 
            led_addr_ptr = (BP_U_8BIT BP_XDATA *)PCM_LED_ADDR;
            index = 1;
            nibble = 1;
            break;

         }   /* end switch no */

    switch ( request ){
        case _CU_LED_BLOCK_SET:
            if ( nibble == 0 )
                {    /* LOWER */
                led_blocks[index] &= 0xF0;
                led_blocks[index] |= (parameter & 0x0F);
                }
            else
                {                        /* UPPER */
                led_blocks[index] &= 0x0F;
                led_blocks[index] |= ( (parameter<<4) & 0xF0);
                }
            break;

        case _CU_LED_BLOCK_ON:
            if ( nibble == 0 )
                {   /* LOWER */
                led_blocks[index] |= (parameter & 0x0F);
                }
            else
                {                       /* UPPER */
                led_blocks[index] |= ( (parameter<<4) & 0xF0);
                }
            break;

        case _CU_LED_BLOCK_OFF:
            if ( nibble == 0 )
                {    /* LOWER */
                led_blocks[index] &= ~(parameter & 0x0F);
                }
            else
                {                        /* UPPER */
                led_blocks[index] &= ~( (parameter<<4) & 0xF0);
                }
            break;

        }   /* end switch request */
    
    *led_addr_ptr = led_blocks[index];

} /* end set_LED_block */

#endif /* CU_LED */
#endif /* CHAN_UNIT */


