#ifdef CHAN_UNIT

/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      chanunit.c
 *
 * FILE CREATED:  June 29, 1994
 *
 * LAST MODIFIED: [4-19-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   This file contains the Initializing routines
 *                for the Bt8953 Channel Unit
 *
 * FUNCTION LIST:
 *                _CuInitCommonRegisters()
 *                _CuInitHdslLoops()
 *                _CuInitChannelUnit()
 *                _CuInitAddresses()
 */

#include "chanunit.h"
CU_WR BP_XDATA * BP_XDATA cu_wr;
CU_RD BP_XDATA * BP_XDATA cu_rd;

CU_REG_COPY BP_XDATA cu_reg_copy;
CU_RX_HOH BP_XDATA cu_rx_hoh;

CU_FLAGS BP_XDATA _CuFlags;

BP_U_8BIT BP_XDATA rate_index = _2T1;

#ifdef MCLK_1024
BP_U_8BIT BP_XDATA rate_values[][4] =
{
 /* Bt8973 Support 
  *
  * The Channel unit MCLK is driven by the XTAL output (XTALO)
  * from the Rs8973. XTALO is set to 10.24MHz and does not
  * change as a function of the HDSL data rate.
  *
  * CUSTOM is set for 35HDSL & 32PCM (experiment)
  */

 /*  2T1   2E1   3E1  CUSTOM  1T1   1E1  */
    0x29, 0xA9, 0xA9,  0xA9, /* 0x29, 0xA9,*/      /* CMD_1 */
     190,  253,  253,   253, /*  190,  253,*/      /* TFRAME_LOC_LO */
      22,   14,   14,    14, /*   14,   14,*/      /* TMF_LOC */
      96,  144,   96,  0x18, /*  192, 0x20,*/      /* HFRAME_LEN_LO */
/*     0,    0,    0,     1,       0,    1,      HFRAME_LEN_HI  */
/*    96,  144,   96,  0x18,     192, 0x20,      HFRAME_LEN2_LO */
/*     0,    0,    0,     1,       0,    1,      HFRAME_LEN2_HI */
/*    96,  144,   96,  0x18,     192, 0x20,      HFRAME_LEN3_LO */
/*     0,    0,    0,     1,       0,    1,      HFRAME_LEN3_HI */
     192,  255,  255,   255, /* 192,  255, */      /* FRAME_LEN_LO */
      23,   15,   15,    15, /*  15,   15, */      /* MFRAME_LEN */
       1,    2,    2,     2, /*   2,    2, */      /* MFRAME_CNT */
    0xC0, 0x88, 0x88,  0x64, /* 0x64, 0x64,*/      /* RFIFO_WL_LO */
/*    0x00, 0x00, 0x00,  0x00,  0x00, 0x00,*/      /* RFIFO_WL_HI */
    0x79, 0x75, 0xA1,  0x75, /* 0x3D, 0x75,*/      /* STF_THRESH_A_LO */
/*       0,    0,    0,     0,     0,    0,*/      /* STF_THRESH_A_HI */
    0xB6, 0x8B, 0xBF,  0x8C, /* 0x5C, 0x8C,*/      /* STF_THRESH_B_LO */
/*       0,    0,    0,     0,     0,    0,*/      /* STF_THRESH_B_HI */
    0x6D,    0, 0x60,  0x00, /* 0xB8, 0x00,*/      /* STF_THRESH_C_LO */
/*    0x01, 0x01, 0x01,  0x01      0,    1,*/      /* STF_THRESH_C_HI */
    0x61, 0x00, 0x00,  0x00, /* 0x61, 0x00,*/      /* DPLL_RESID_LO */
    0x36, 0x80, 0x80,  0x80, /* 0x36, 0x80,*/      /* DPLL_RESID_HI */
    0xEA, 0xF0, 0xF0,  0xF0, /* 0xEA, 0xF0,*/      /* DPLL_FACTOR */
    0x5F, 0x90, 0x96,  0x90, /* 0x90, 0x90,*/      /* DPLL_DLY_LO */
    0x09, 0x0C, 0x09,  0x18 /* 0x18, 0x18,*/      /* DPLL_PINI */
/*       1,    1,    1,     1,     1,    1,*/      /* RFRAME_LOC_LO */
/*       0,    0,    0,     0,     0,    0 */      /* RMF_LOC */
};

#else
 /* The Channel unit MCLK is driven by either: 
  *               1) HCLK from Rs8973 
  *               2) XTALO or HCLK from Bt8970 
  * All of these outputs from either bitpump are a function of the 
  * HDSL data rate.
  */
BP_U_8BIT BP_XDATA rate_values[][6] =
{
              /* CUSTOM = 35HDSL & 32PCM */

 /*  2T1   2E1   3E1  CUSTOM  1T1   1E1  */
    0x25, 0xA8, 0xA5,  0xA9, 0xAC, 0xAC,      /* CMD_1 */
     190,  253,  253,   253,  253,  253,      /* TFRAME_LOC_LO */
      22,   14,   14,    14,   14,   14,      /* TMF_LOC */
      96,  144,   96,  0x18, 0x20, 0x20,      /* HFRAME_LEN_LO */
       0,    0,    0,     1,    0,    1,      /* HFRAME_LEN_HI */
      96,  144,   96,  0x18,  192, 0x20,      /* HFRAME_LEN2_LO */
       0,    0,    0,     1,    0,    1,      /* HFRAME_LEN2_HI */
      96,  144,   96,  0x18,  192, 0x20,      /* HFRAME_LEN3_LO */
       0,    0,    0,     1,    0,    1,      /* HFRAME_LEN3_HI */
     192,  255,  255,   255,  255,  255,      /* FRAME_LEN_LO */
      23,   15,   15,    15,   15,   15,      /* MFRAME_LEN */
       1,    2,    2,     2,    2,    2,      /* MFRAME_CNT */
    0xC0, 0x88, 0x88,  0x64, 0x64, 0x64,      /* RFIFO_WL_LO */
    0x00, 0x00, 0x00,  0x00, 0x00, 0x00,      /* RFIFO_WL_HI */
    0xA1, 0x75, 0xA1,  0x75, 0x75, 0x75,      /* STF_THRESH_A_LO */
       0,    0,    0,     0,    0,    0,      /* STF_THRESH_A_HI */
    0xBF, 0x8B, 0xBF,  0x8C, 0x8B, 0x8B,      /* STF_THRESH_B_LO */
       0,    0,    0,     0,    0,    0,      /* STF_THRESH_B_HI */
    0x60,    0, 0x60,  0x00,    0,    0,      /* STF_THRESH_C_LO */
    0x01, 0x01, 0x01,     1, 0x01, 0x01,      /* STF_THRESH_C_HI */
    0x8B, 0x00, 0x00,  0x00, 0x00, 0x00,      /* DPLL_RESID_LO */
    0x57, 0x40, 0xD8,  0x80, 0x20, 0x20,      /* DPLL_RESID_HI */
    0xEB, 0xEF, 0xF1,  0xF0, 0xEF, 0xEF,      /* DPLL_FACTOR */
    0x5F, 0x90, 0x96,  0x90, 0x90, 0x90,      /* DPLL_DLY_LO */
    0x09, 0x0C, 0x09,  0x18, 0x18, 0x18,      /* DPLL_PINI */
       1,    1,    1,     1,    1,    1,      /* RFRAME_LOC_LO */
       0,    0,    0,     0,    0,    0      /* RMF_LOC */
};
#endif /* MCLK_1024 */



BP_U_8BIT BP_XDATA htu_index = _HTUC;

extern BP_U_8BIT BP_XDATA loop_sync_state[_NO_OF_LOOPS];

/*
 * FUNCTION:   _CuInitCommonRegisters
 *
 * PARAMETERS: none
 *
 * PURPOSE:    This function initializes the Channel Unit's Common Registers
 *             
 * RETURN:     nothing
 *
 * NOTES:      
 *
 * CHANGES:    July 11, 1994    NEW   -   Dean Rasmussen
 */
void _CuInitCommonRegisters (void)
{
    COMMON_WR BP_XDATA * common_wr_ptr;
    
    common_wr_ptr = &(cu_wr->common_wr_regs);

    /***************/
    /*   COMMAND   */
    /***************/

    /* E1_MODE, PLL_DIS, PLL_DIV, PLL_MUL */
    cu_reg_copy.cmd_1.reg = rate_values[CMD_1_INDEX][rate_index];
    common_wr_ptr->cmd_1 = cu_reg_copy.cmd_1.reg;

    /* TEST1, PCM_FLOAT, HP_LOOP, PP_LOOP, RCLK_SEL, TCLK_SEL */

    /*
     * For UnFramed Mode, set PCM Float
     */
    cu_reg_copy.cmd_2.reg = 0x00;
    cu_reg_copy.cmd_2.bits.pcm_float = _CuFlags._CuFrameFormat;
    common_wr_ptr->cmd_2 = cu_reg_copy.cmd_2.reg;
    

    /* RSIG_WR, PRBS_MODE, BER_SCALE, PRBS_DIS, ROUTE_EN, COMB_EN */
    cu_reg_copy.cmd_3.reg = 0x04;
    common_wr_ptr->cmd_3 = cu_reg_copy.cmd_3.reg;

    /* TEST3 */
    common_wr_ptr->cmd_4 = 0x04;
    cu_reg_copy.cmd_5.reg = 0x00;
    _CuWriteMasterCmd5();


    /***********/
    /*   PRA   */
    /***********/
    common_wr_ptr->tframe_loc_lo = rate_values[TFRAME_LOC_LO_INDEX][rate_index];
    common_wr_ptr->tframe_loc_hi = 0;
    common_wr_ptr->tmf_loc = rate_values[TMF_LOC_INDEX][rate_index];
    common_wr_ptr->mf_len = rate_values[MFRAME_LEN_INDEX][rate_index];
    common_wr_ptr->mf_cnt = rate_values[MFRAME_CNT_INDEX][rate_index]; 
    common_wr_ptr->frame_len_lo = rate_values[FRAME_LEN_LO_INDEX][rate_index]; 
    common_wr_ptr->frame_len_hi = 0; 
    common_wr_ptr->rframe_loc_lo = 1; 
    common_wr_ptr->rframe_loc_hi = 0;
    common_wr_ptr->rmf_loc = 0; 

    /************/
    /*   HDSL   */
    /************/ 
    common_wr_ptr->hframe_len = rate_values[HFRAME_LEN_INDEX][rate_index];
    common_wr_ptr->sync_word_a = 0x72; 
    common_wr_ptr->sync_word_b = 0x27;  /* only used by 2T1 */
    common_wr_ptr->rfifo_wl_lo = rate_values[RFIFO_WL_LO_INDEX][rate_index];
    common_wr_ptr->rfifo_wl_hi = 0; 
    common_wr_ptr->stf_thresh_a_lo = rate_values[STF_THRESH_A_LO_INDEX][rate_index];
    common_wr_ptr->stf_thresh_a_hi = 0; 
    common_wr_ptr->stf_thresh_b_lo = rate_values[STF_THRESH_B_LO_INDEX][rate_index];
    common_wr_ptr->stf_thresh_b_hi = 0; 
    common_wr_ptr->stf_thresh_c_lo = rate_values[STF_THRESH_C_LO_INDEX][rate_index];
#ifdef MCLK_1024
    common_wr_ptr->stf_thresh_c_hi = 1; 
#else
    common_wr_ptr->stf_thresh_c_hi = rate_values[STF_THRESH_C_HI_INDEX][rate_index];
#endif /*MCLK_1024*/
    common_wr_ptr->tstuff = 0x5;

    /************/
    /*   DPLL   */
    /************/ 
    common_wr_ptr->dpll_resid_lo = rate_values[DPLL_RESID_LO_INDEX][rate_index];
    common_wr_ptr->dpll_resid_hi = rate_values[DPLL_RESID_HI_INDEX][rate_index];
    
    cu_reg_copy.dpll_factor = rate_values[DPLL_FACTOR_INDEX][rate_index];
    common_wr_ptr->dpll_factor = cu_reg_copy.dpll_factor;
    
    cu_reg_copy.dpll_gain.reg = MIN_DPLL_GAIN_VALUE;
    common_wr_ptr->dpll_gain = cu_reg_copy.dpll_gain.reg;
    
    common_wr_ptr->dpll_dly_lo = rate_values[DPLL_DLY_LO_INDEX][rate_index];
    common_wr_ptr->dpll_dly_hi = 0x5E;
    common_wr_ptr->dpll_pini = rate_values[DPLL_PINI_INDEX][rate_index];
    common_wr_ptr->dpll_rst = 0;

    _CuDpllOperation(_CU_DPLL_CLOSED);
    cu_dpll_state_man = DPLL_IDLE_STATE;

    /*****************/
    /*   CONSTANTS   */
    /*****************/ 

    /* DBANK_1 has a bug w/ Bit#0, Bit#0 must be programmed to a 0 */
    common_wr_ptr->dbank_1 = 0xFE;
    common_wr_ptr->dbank_2 = 0xFF; /* used for generating AIS (All ONES) */
    common_wr_ptr->dbank_3 = 0x00;
    common_wr_ptr->tzbit_2 = 0x22; 
    common_wr_ptr->tzbit_3 = 0x33; 
    common_wr_ptr->tzbit_4 = 0x44; 
    common_wr_ptr->tzbit_5 = 0x55; 
    common_wr_ptr->tzbit_6 = 0x66; 
    common_wr_ptr->fill_patt = 0xAA;

    common_wr_ptr->ber_rst = 0;
    common_wr_ptr->prbs_rst = 0;
    common_wr_ptr->route_tbl = 0;
    common_wr_ptr->combine_tbl = 0;


    /********************/
    /*  Bt8953A/B REGS  */
    /********************/

        common_wr_ptr->hframe_len_hi = 0; 
        cu_reg_copy.cmd_6.reg = 0x00;
        common_wr_ptr->cmd_6 = cu_reg_copy.cmd_6.reg;

        cu_reg_copy.cmd_7.reg = 0x05;    /* Enable DPLL_ERR_EN */
        common_wr_ptr->cmd_7 = cu_reg_copy.cmd_7.reg;

    return;
}

 
/*
 * FUNCTION:   _CuInitHdslLoops
 *
 * PARAMETERS: none
 *
 * PURPOSE:    This function initializes the HDSL Transmitter/Receiver
 *             specific registers for all of the current loops.
 *             
 * RETURN:     nothing
 *
 * NOTES:      
 *
 * CHANGES:    July 12, 1994    NEW   -   Dean Rasmussen
 *             January 17, 1995     V4.0 - Moved Tx/Rx MAP Initialization
 */
void _CuInitHdslLoops (void)
{
    TX_WR BP_XDATA * tx_wr_ptr;
    RX_WR BP_XDATA * rx_wr_ptr;
    BP_U_8BIT loop, loop_cntr; 

    for ( loop_cntr = 0 ; loop_cntr < num_bit_pumps ; loop_cntr++ )
        {

        loop = bp_position[loop_cntr];
        
        tx_wr_ptr = get_tx_wr_ptr(loop);
        rx_wr_ptr = get_rx_wr_ptr(loop);

        if ( tx_wr_ptr == 0 || rx_wr_ptr == 0 )
            {
            continue;
            }

        /*
         * Transmitter Write Registers
         */
#ifdef REPEATER
        /* Clear the hrp indicator bit.  This bit is transmitted to both
         * the COT and RT. Therefore, it should be cleared for both loops.
         */
        cu_reg_copy.tind_lo[loop].reg = 0xDF;
#else
        cu_reg_copy.tind_lo[loop].reg = 0xFF;
#endif
        cu_reg_copy.tind_hi[loop].reg = 0x1F;   /* only 5 bits */
        
        tx_wr_ptr->tind_lo = cu_reg_copy.tind_lo[loop].reg;
        tx_wr_ptr->tind_hi = cu_reg_copy.tind_hi[loop].reg;

        cu_rx_hoh.rtr_ind_status[loop].reg = 0;


        /* TX_ERR_EN, FORCE_ONE, HOH_EN, SYNC_SEL, ICRC_ERR, TWO_LEVEL, SCR_EN */
        cu_reg_copy.tcmd_1[loop].reg = 0x11;  /* Scrambled HOH & Data */
        
        /*
         * T1 - Set SYNC_WORD (E1 - use SYNC_WORD_A)
         *
         * ZBits = All ones
         */
#ifdef CU_2T1
        /*
         * Sync Select already set to Sync Word A, for 2nd loop, set
         * Sync Word B
         */
        if ( rate_index == _2T1 && loop != 0x00 )
            {
            cu_reg_copy.tcmd_1[loop].bits.sync_sel = 1;  /* SYNC_WORD_B */
            }
#endif /* CU_2T1 */

        tx_wr_ptr->tcmd_1 = cu_reg_copy.tcmd_1[loop].reg;
        
        /* set the PID for 2E1 application */
        _CuSetPid(loop);

        /* STUFF_MODE=1, EXT_ZBIT=0, REPEAT_EN=0, TAUX_EN=0, SLV_STUF=0,
         * SCR_TAP=0, HH_LOOP=0
         */
        cu_reg_copy.tcmd_2[loop].reg = 0x40;
#ifdef REPEATER
        if (loop == 0)     /* RegR */
        {
         cu_reg_copy.tcmd_2[loop].bits.scr_tap = _HTUR;
        }
        /* otherwise loop = 1.  For a repeater, assume num_bit_pumps equals 
         * 2 because only 2 bitpumps should be detected.
         */
        else             /* RegC */
        {
        cu_reg_copy.tcmd_2[loop].bits.scr_tap = _HTUC;
        }
#else
        cu_reg_copy.tcmd_2[loop].bits.scr_tap = htu_index;
#endif
        tx_wr_ptr->tcmd_2 = cu_reg_copy.tcmd_2[loop].reg;

        /*
         * Receiver Write Registers
         */

        /* FRAMER_EN=BOTH, LOSS_SYNC=6, REACH_SYNC=2 */
        cu_reg_copy.rcmd_1[loop].reg = 0xE9;
        rx_wr_ptr->rcmd_1 = cu_reg_copy.rcmd_1[loop].reg;


        /* RX_ERR_EN=0, PH_LOOP=0, DSCR_EN=1, DSCR_TAP=?, THRESH_CORR=12 */
        cu_reg_copy.rcmd_2[loop].reg = 0x2E;
#ifdef REPEATER
        if (loop == 0)    /* RegR */
        {
         cu_reg_copy.rcmd_2[loop].bits.dscr_tap = _HTUR;
        }
        else             /* RegC */
        {
        cu_reg_copy.rcmd_2[loop].bits.dscr_tap = _HTUC;
        }
#else
        cu_reg_copy.rcmd_2[loop].bits.dscr_tap = htu_index;
#endif
        rx_wr_ptr->rcmd_2 = cu_reg_copy.rcmd_2[loop].reg;

        }   /* end for loop_cntr */

    return;
}

/*
 * FUNCTION:   _CuInitChannelUnit
 *
 * PARAMETERS: none
 *
 * PURPOSE:    This function initializes the Channel Unit Route/Combine
 *             Table values then configures the Channel Unit.
 *             
 * RETURN:     _PASS (0) - Successfully Completed Operation
 *             _FAIL (1) - An error occured
 *
 * NOTES:      
 *
 * CHANGES:    July 8, 1994    NEW   -   Dean Rasmussen
 *             January 17, 1995     V4.0 - Modified for Route/Table/Mapper stuff
 */
BP_U_8BIT _CuInitChannelUnit (void)
{
        
    BP_U_8BIT loop_cntr; 
    COMMON_WR BP_XDATA * common_wr_ptr;

    common_wr_ptr = &(cu_wr->common_wr_regs);

    if ( !_CuChipVersion.present )
        {
        return _FAIL;
        }

    for ( loop_cntr = 0 ; loop_cntr < _NO_OF_LOOPS ; loop_cntr++ )
        {
        loop_sync_state[loop_cntr] = CU_OUT_OF_SYNC;
        }

      
    cu_reg_copy.imr.reg = 0xFF;
    common_wr_ptr->imr = 0xFF;   /* Mask All during initialization */
    common_wr_ptr->icr = 0;

    _CuInitCommonRegisters();
    _CuInitHdslLoops();

    _CuDefaultRouteLoops();
    _CuDefaultCombineLoops();

    _CuInitMapper();

    _CuInitRouteTable();
    _CuInitCombineTable();

    _CuWriteMapRouteCombine();

#ifdef REPEATER
    /* Leave RX/TX_ERR OFF.
     * The DPLL is not used for the repeater and the
     * RX_ERR does not need to be enabled
     */
    cu_reg_copy.imr.reg = 0xFF;
#else
    /* Leave RX/TX_ERR ON.  
     * The DPLL error is the only error that is enabled.
     * RFIFO and TFIFO errors do not cause interrupts because they
     * are not enabled in RCMD_2 and TCMD_1, respectively.
     * For more information, see COMMENTS at the top of cu_int.c.
     */
    cu_reg_copy.imr.reg = 0x3F;
#endif /* REPEATER */

    common_wr_ptr->imr = cu_reg_copy.imr.reg;
    common_wr_ptr->icr = 0;
#ifdef CU_LED
   for ( loop_cntr = 0 ; loop_cntr < _NO_OF_LOOPS ; loop_cntr++ )
        {
        cu_led_block[loop_cntr].reg = 0;
        }
    cu_bp_led_block[0].reg = 0;
    cu_bp_led_block[1].reg = 0;
    cu_pcm_led_block.reg = 0;
#endif /* CU_LED */
    return _PASS;
}

/*
 * FUNCTION:   _CuInitAddresses
 *
 * PARAMETERS: none
 *
 * PURPOSE:    Initialize the Channel Unit EVM Board base addresses.
 *             Init _CuFlags register.
 *             
 * RETURN:     nothing
 *
 * NOTES:      
 *
 * CHANGES:    April 24, 1995    NEW   -   Ver 4.1
 */
void _CuInitAddresses (void)
{
#ifdef CU_EOC
    EOC_STRUCT_DECL_PTR;
    BP_U_8BIT bp,i; 
#endif /* CU_EOC */
    COMMON_WR *common_wr_ptr;
    /*
     * Define Channel Unit, Framer, & LIU Base Addresses
     */
    cu_wr = (CU_WR BP_XDATA *)CHANUNIT_ADD;
    cu_rd = (CU_RD BP_XDATA *)CHANUNIT_ADD;

#ifdef T1E1_FRAMER

#ifdef BT8510_FRAMER
    fr8510_ptr = (FR8510_PTR BP_XDATA *)FRAMER_ADD;
    fr8510_mode_ptr = (FR8510_MODE_PTR BP_XDATA *)FRAMER_ADD;
    fr8510_ram_buffer_ptr = (FR8510_RAM_BUFFER_PTR BP_XDATA *)FRAMER_RAM_BUF_ADD;
#endif /* BT8510_FRAMER */

#ifdef BT8360_FRAMER
    fr8360_ptr = (FR8360_PTR BP_XDATA *)FRAMER_ADD;
    fr8360_mode_ptr = (FR8360_MODE_PTR BP_XDATA *)FRAMER_ADD;
    fr8360_ram_buffer_ptr = (FR8360_RAM_BUFFER_PTR BP_XDATA *)FRAMER_RAM_BUF_ADD;
#endif /* BT8360_FRAMER */

#ifdef BT8370_FRAMER
    fr8370_ptr = (FR8370_PTR BP_XDATA *)FRAMER_ADD;
    fr8370_mode_ptr = (FR8370_MODE_PTR BP_XDATA *)FRAMER_ADD;
    fr8370_ram_buffer_ptr = (FR8370_RAM_BUFFER_PTR BP_XDATA *)FR8370_RAM_BUF_ADD;
#endif /* BT8370_FRAMER */

#ifdef BT8069_LIU
    liu_control = (LIU_CONTROL BP_XDATA *)LIU_CONTROL_ADD;
    liu_status = (LIU_STATUS BP_XDATA *)LIU_STATUS_ADD;
#endif /* BT8069_LIU */


    _FramerMaskInterrupt();

#endif /* T1E1_FRAMER */

    _CuFlags._CuMasterLoop = 0;
    _CuFlags._CuLoopsReversed = 0;
    _CuFlags._CuFrameFormat = _CU_FRAMED_DATA;
    _CuFlags._CuAutoRestart = 0;

    _CuChipVersion.present = _NOT_PRESENT;
    common_wr_ptr = &(cu_wr->common_wr_regs);
    common_wr_ptr->cmd_4 = 0x04;
#ifdef CU_EOC
    /* Initialize EOC handling state */

  for ( bp = 0; bp < _NO_OF_LOOPS; bp++ )
    {
      EOC_STRUCT_INIT_PTR(bp);      /*Init pointer for the for loop below*/
      api_dataBuffIndex[bp] = 0;      /* Set EOC byte index to 0 */
#ifdef ZIP_START        
      needs_zip_start_check[bp] = 1;     /*Set ZipStart EOC enable mode if ZipStart compiled */
#endif /*ZIP_START*/
      eocTasks[bp].reg = 0;            /*Clear any task bits*/    
      upDateFlags[bp].reg = 0;         /*Clear update wr/rdRegData Flags*/
      newDataFlags[bp].reg = 0;         /*Clear new receieved info Flags*/
      repeater_off[bp] = 1;         /*Sets EOC address to be HTU-R*/

      
      for ( i = 0; i < 16; i++ )
         {
         eoc_struct_ptr->rdRegSize[i] = 0; /*Set all EOC reg to 0 length, up to user to set the size.*/
         eoc_struct_ptr->wrRegSize[i] = 0;
         }
    eoc_struct_ptr->rdRegData[0xD][0] = 0; /* Clear the byte ZipStart will use once normal operation is met to query far-end. */
    eoc_struct_ptr->rdRegSize[0xE] = 1; /*NMR EOC register size is 1 for ETSI standard*/
    eoc_struct_ptr->wrRegSize[0xF] = 3; /* EOC sends 3 over EOC*/
    eoc_struct_ptr->rdRegSize[0xF] = 1; /* EOC receives 1 back from EOC*/
    }
#endif /* CU_EOC */
   return;

}
#endif /* CHAN_UNIT */
