#ifdef CU_EOC 

/* Fresha
 *-------------------------------------------------------
 *    file:    Cu_EOC.h
 *    
 *    Definition of EOC specific states and data structures
 *-------------------------------------------------------
 */

/*------------------------------------------------------------------------------*/
/*                        EOC related definitions (see ETR-152)                    */
/*------------------------------------------------------------------------------*/

  #define    EOC_ADDRESS_MASK          0x03    /* Mask for eoc2 and eoc1                */
  #define    EOC_ADDRESS_REP           0x01    /* EOC adress for repeater                */
  #define    EOC_ADDRESS_RT            0x00    /* EOC adress for RT (NTU)                */

  #define    SEND_EOC_COMMAND          0x14    /* \   mnemonics                        */
  #define    SEND_EVEN_DATA            0x10    /*  \  used for                            */
  #define    SEND_ODD_DATA             0x18    /*   > building the                        */
  #define    READ_EVEN_DATA            0x10    /*  /  header of a                        */
  #define    READ_ODD_DATA             0x18    /* /   EOC message                        */

  #define    EOC_MESSAGE_INDICATOR     0x04    /* mask for command bit (eoc3)           */
  #define    EOC_ODD_INDICATOR         0x08    /* mask for odd/even bit (eoc4)            */


  #define    EOC_CMD_UTC               0x06    /* Unable to Comply                        */
  #define    EOC_CMD_RTN               0x07    /* Return to Normal                        */
  #define    EOC_CMD_LOOP_NTU          0x08    /* Application-Frame-Loop at NTU        */
  #define    EOC_CMD_HOLD              0x10    /* Hold-State                            */
  #define    EOC_CMD_ALOOP_REG         0x19    /* Analog-Loop in REG                    */
  #define    EOC_CMD_NTU_CCRC_REQ      0x20    /* Req. corrupted CRC6 from NTU            */
  #define    EOC_CMD_REGC_CCRC_REQ     0x22    /* Req. corrupted CRC6 from REG-C        */
  #define    EOC_CMD_NTU_CCRC_END      0x28    /* End of corr. CRC6 from NTU            */
  #define    EOC_CMD_REGC_CCRC_END     0x29    /* End of corr. CRC6 from REG-C            */
  #define    EOC_CMD_NTU_CCRC_IND      0x3F    /* corrupted CRC6 comes from NTU            */
  #define    EOC_CMD_REGC_CCRC_IND     0x50    /* corrupted CRC6 comes from REG-C        */
  #define    EOC_CMD_NTU_CRC_OK        0x5F    /* correct CRC6 comes from NTU            */
  #define    EOC_CMD_REGC_CRC_OK       0x60    /* correct CRC6 comes from REG-C            */
  #define    EOC_CMD_END_OF_DATA       0x9F    /* End of Data                            */
  #define    EOC_CMD_NEXT_BYTE         0xAF    /* Next Byte                            */ 

  #define    EOC_CMD_READ_REG_0        0xE0    /* read EOC register 0  request        */
  #define    EOC_CMD_READ_REG_1        0xE1    /* read EOC register 1  request        */
  #define    EOC_CMD_READ_REG_2        0xE2    /* read EOC register 2  request        */
  #define    EOC_CMD_READ_REG_3        0xE3    /* read EOC register 3  request        */
  #define    EOC_CMD_READ_REG_4        0xE4    /* read EOC register 4  request        */
  #define    EOC_CMD_READ_REG_5        0xE5    /* read EOC register 5  request        */
  #define    EOC_CMD_READ_REG_6        0xE6    /* read EOC register 6  request        */
  #define    EOC_CMD_READ_REG_7        0xE7    /* read EOC register 7  request        */
  #define    EOC_CMD_READ_REG_8        0xE8    /* read EOC register 8  request        */
  #define    EOC_CMD_READ_REG_9        0xE9    /* read EOC register 9  request        */
  
  #define    EOC_CMD_READ_REG_A        0xEA    /* read EOC register A request        */
  #define    EOC_CMD_READ_REG_B        0xEB    /* read EOC register B request        */
  #define    EOC_CMD_READ_REG_C        0xEC    /* read EOC register C request        */
  #define    EOC_CMD_READ_REG_D        0xED    /* read EOC register D request        */
  #define    EOC_CMD_READ_REG_E        0xEE    /* read EOC register E request        */
  #define    EOC_CMD_READ_REG_F        0xEF    /* read EOC register F request        */

  #define    EOC_CMD_WRITE_REG_0       0xD0    /* write EOC register 0 request        */
  #define    EOC_CMD_WRITE_REG_1       0xD1    /* write EOC register 1 request        */
  #define    EOC_CMD_WRITE_REG_2       0xD2    /* write EOC register 2 request        */
  #define    EOC_CMD_WRITE_REG_3       0xD3    /* write EOC register 3 request        */
  #define    EOC_CMD_WRITE_REG_4       0xD4    /* write EOC register 4 request        */
  #define    EOC_CMD_WRITE_REG_5       0xD5    /* write EOC register 5 request        */
  #define    EOC_CMD_WRITE_REG_6       0xD6    /* write EOC register 6 request        */
  #define    EOC_CMD_WRITE_REG_7       0xD7    /* write EOC register 7 request        */
  #define    EOC_CMD_WRITE_REG_8       0xD8    /* write EOC register 8 request        */
  #define    EOC_CMD_WRITE_REG_9       0xD9    /* write EOC register 9 request        */
  
  #define    EOC_CMD_WRITE_REG_A       0xDA    /* write EOC register A request        */
  #define    EOC_CMD_WRITE_REG_B       0xDB    /* write EOC register B request        */
  #define    EOC_CMD_WRITE_REG_C       0xDC    /* write EOC register C request        */
  #define    EOC_CMD_WRITE_REG_D       0xDD    /* write EOC register D request        */
  #define    EOC_CMD_WRITE_REG_E       0xDE    /* write EOC register E request        */
  #define    EOC_CMD_WRITE_REG_F       0xDF    /* write EOC register F request        */

  /***** 
     For HTU-R:  The following definitions are application specific and don't need
     any modifications if the functionality of the EOC channel is not changed   
   *****/
#ifdef REPEATER 
  #define    EOC_OWN_ADDRESS           0x01
#else
  #define    EOC_OWN_ADDRESS           0x00
#endif /* REPEATER */

/* HOLD state flags to track latched EOC commands */
 
  #define    EOC_REQ_LOOP_RT           0x01    /* Hold state: DD-Loop closed application        */
                                               /* loopback                          0x08        */
  #define    EOC_REQ_CCRC_RT           0x02    /* Hold state: ICRC_ERR enabled RT,  0x20, 0x28  */
  #define    EOC_REQ_NMR_RT            0x04    /* Update EocRegE request                        */
  #define    EOC_REQ_ALOOP_RT          0x08    /* Hold state: Analog LoopB request, 0x19        */
  #define    EOC_REQ_CCRC_CO           0x10    /* Hold state: ICRC enable CO        0x22, 0x29  */
  #define    EOC_REQ_NOT_CCRC_RT       0x20    /* Hold state: NCRC enable RT        0x3F, 0x5F  */ 
  #define    EOC_REQ_NOT_CCRC_CO       0x40    /* Hold state: NCRC enable CO        0x50, 0x60  */ 

/* below uses some hold state constants for the eocLoopReg[loop] variable */
/* The eocLoopReg[loop] variable mimics the eocHoldStates[llop] plus it has additional OFF states. */
/* The OFF states are for the CuHandleFlags to look for and execute if need be  */

/*#define    EOC_REQ_LOOP_RT           0x01     Hold state: DD-Loop closed application loopback   */
/*#define    EOC_REQ_CCRC_RT           0x02     Hold state: ICRC_ERR enabled RT                   */
  #define    EOC_REQ_ALOOP_RT_OFF      0x04     /* Tells higher level to turn off Analog           */
                                                /* Loopback request                               */
/*#define    EOC_REQ_ALOOP_RT          0x08     Hold state: Analog LoopB request                  */
/*#define    EOC_REQ_CCRC_CO           0x10     Hold state: ICRC enable CO                        */
/*#define    EOC_REQ_NOT_CCRC_RT       0x20     Hold state: NCRC enable RT                        */ 
/*#define    EOC_REQ_NOT_CCRC_CO       0x40     Hold state: NCRC enable CO                        */
  #define    EOC_REQ_LOOP_RT_OFF       0x80     /* tells higher level turn off DD-Loop            */
                                                /* that closed application loopback               */
  #define    ENABLE_LOOPB              0x8D     /* Masks all holdstates except for loopbacks      */
 
  #define    WAIT_RESPONSE_TIME        20   /* break after 20 frames    */
                                            /* without acknowledge      */
/* 
 * Flags for access of EOC status-bits 
 * This is only needed on the EOC master or HTUC side
 */
  #define    EOC_STATUS_AVAILABLE      0x01    /* EOC channel is transparent       */
  #define    EOC_STATUS_BUSY           0x02    /* EOC Handler is reserved          */
  #define    EOC_STATUS_RUN            0x04    /* EOC Handler performs EOC action  */
  #define    EOC_STATUS_HOLD           0x08    /* latched EOC command sent out     */
  #define    EOC_STATUS_ERROR          0x10    /* EOC action failed                */

/*------------------------------------------------------------------------------
                   Defines constants for states of all statemachines.
  ------------------------------------------------------------------------------*/

/*                               EOC-Handler    

  _______|____Mnemonik__________|___Code___|____State-Description__________        */

  #define    EOC_IDLE                  0x00    /* Framer is asynchronous            */
  #define    EOC_UTC_STATE             0x01    /* UTC command received            */
  #define    EOC_CMD_READY             0x02    /* ready to perform action            */

  #define    EOC_CMD_REQUEST           0x03    /* Start: EOC-command                */
  #define    EOC_READ_REQUEST          0x04    /* Start: EOC-READ operation        */
  #define    EOC_DATA_READ_STATE       0x05    /* EOC-READ operation acknowledged    */
  #define    EOC_DATA_RECEIVE_STATE    0x06    /* receiption of data starts        */

  #define    EOC_WRITE_REQUEST         0x07    /* Start: EOC-WRITE operation        */
  #define    EOC_DATA_WRITE_STATE      0x08    /* EOC-WRITE operation acknowledged    */

  #define    EOC_CMD_RESPONS_1         0x09    /* EOC-command: 1st acknowledge        */
  #define    EOC_CMD_RESPONS_2         0x0A    /* EOC-command: 2nd acknowledge        */
  #define    EOC_RCMD_ACK_1            0x0B    /* READ-command: 1st acknowledge    */
  #define    EOC_RCMD_ACK_2            0x0C    /* READ-command: 2nd acknowledge    */
  #define    EOC_NEXT_ACK_1            0x0D    /* NEXT-command: 1st acknowledge    */
  #define    EOC_NEXT_ACK_2            0x0E    /* NEXT-command: 2nd acknowledge    */
  #define    EOC_BYTE_READ_1           0x0F    /* 1st DATA-response (read)            */
  #define    EOC_BYTE_READ_2           0x10    /* 2nd DATA-response (read)            */

  #define    EOC_WCMD_ACK_1            0x11    /* WRITE-command: 1st acknowl.        */
  #define    EOC_WCMD_ACK_2            0x12    /* WRITE-command: 2nd acknowl.        */
  #define    EOC_BYTE_WRITE_1          0x13    /* 1st DATA-response (write)        */
  #define    EOC_BYTE_WRITE_2          0x14    /* 2nd DATA-response (write)        */
/* 
 * HTUR side definitions
 *  --------------------------------------------------------------------------- */
  #define    EOC_IDLE                  0x00    /* Framer is asynchronous            */
  #define    EOC_UTC_STATE             0x01    /* UTC-state                        */
  #define    EOC_ECHO_RESPONSE         0x02    /* ready to perform action            */

  #define    EOC_CMD_RESPONS_1         0x09    /* command received 1st time        */
  #define    EOC_CMD_RESPONS_2         0x0A    /* command received 2nd time        */

  #define    EOC_DATA_READ_STATE       0x05    /* EOC-READ operation starts        */
  #define    EOC_DATA_WRITE_STATE      0x08    /* EOC-WRITE operation starts        */

  #define    EOC_NEXT_READ_1           0x07    /* NEXT_BYTE command rec. 1st time    */
  #define    EOC_NEXT_READ_2           0x06    /* NEXT_BYTE command rec. 2nd time    */
  #define    EOC_NEXT_WRITE_1          0x03    /* DATA message rec. 1st time        */
  #define    EOC_NEXT_WRITE_2          0x04    /* DATA message rec. 2nd time        */
  #define    EOC_WRITE_END_1           0x0B    /* END_OF_DATA rec. 1st time        */
  #define    EOC_WRITE_END_2           0x0C    /* END_OF_DATA rec. 2nd time        */

  #define    EOC_UTC_RTN_1             0x0D    /* 1st RTN command after UTC        */
  #define    EOC_UTC_RTN_2             0x0E    /* 2nd RTN command after UTC        */
  #define    EOC_UTC_HOLD_1            0x0F    /* 1st HOLD command after UTC        */
  #define    EOC_UTC_HOLD_2            0x10    /* 2nd HOLD command after UTC        */
  #define    EOC_WRITE_RTN_1           0x11    /* 1st RTN after WRITE command        */
  #define    EOC_WRITE_RTN_2           0x12    /* 2nd RTN after WRITE command        */
  #define    EOC_WRITE_HOLD_1          0x13    /* 1st HOLD after WRITE command        */
  #define    EOC_WRITE_HOLD_2          0x14    /* 2nd HOLD after WRITE command        */
  #define    EOC_READ_RTN_1            0x15    /* 1st RTN after READ command        */
  #define    EOC_READ_RTN_2            0x16    /* 2nd RTN after READ command        */
  #define    EOC_READ_HOLD_1           0x17    /* 1st HOLD after READ command        */
  #define    EOC_READ_HOLD_2           0x18    /* 2nd HOLD after READ command        */
                
  #define    READ_REGF_FLAG            0x8000  /* For the read EOC register F request        */

/* -------------------------------------------------------------------------
                        Data types for EOC-handlers 
   -------------------------------------------------------------------------*/

  typedef struct    
  {
    BP_U_8BIT     status;              /* current status of EOC master              */
    BP_U_8BIT     command;             /* requested command to perform                    */
    BP_U_8BIT     dataSizeCtr;         /* number of bytes to xmit / receive            */
    BP_U_8BIT     dataBuffIndex;       /* current index within eocData.buffer            */
    BP_U_8BIT     eocSlave;            /* EOC-Slave to access (0=RT, 1=Repeater)        */
    BP_U_8BIT     oddEvenCtr;          /* buffer for current ODD/EVEN-flag                */
  }Bt8953_EOC_CTRL;


/* ---------------------------------------------------------------------
 *         External declarations of global variables that are used by the
 *         application part of the ZipSocket EVM.
 * ---------------------------------------------------------------------
 */

  extern    BP_U_8BIT     BP_IDATA      eocHandlerState[_NO_OF_LOOPS];
  extern    BP_U_16BIT    BP_XDATA      eocSendMessage[_NO_OF_LOOPS]; 
  extern    BP_U_16BIT    BP_XDATA      eocReceiveMessage[_NO_OF_LOOPS];
  extern    BP_U_8BIT                   loop;


  typedef    union
  {
   BP_U_16BIT  reg;
   struct    
   {         
        BP_U_16BIT     eocTaskRun:1;      
        BP_U_16BIT     eocRdTask:1;         /* Read Task bit */ 
        BP_U_16BIT     eocWrTask:1;         /* Write Task bits */ 
        BP_U_16BIT     eocCommand:1;        /* Command Task bits */ 
        BP_U_16BIT     eocLoopRt:1;         /* Loopback at application */ 
        BP_U_16BIT     AgLb_regC:1;         /* Analog Loopback from REG to back to C*/ 
        BP_U_16BIT     RqCorCrc_R_regR:1;   /* R/RegR send crc to check C crc unit */ 
        BP_U_16BIT     RqCorCrc_regC:1;     /* RegC sends crc to check R crc unit */ 
        BP_U_16BIT     RqEndCrc_R_regR:1;   /* R/RegR stops sending crc to C */ 
        BP_U_16BIT     RqEndCrc_regC:1;     /* RegC stops sending crc to R */ 
        BP_U_16BIT     NtfCorCrc_R_regR:1;  /* Notify R/RegR of crc from C */
        BP_U_16BIT     NtfCorCrc_regC:1;    /* Notify RegC of crc from R */
        BP_U_16BIT     NtfEndCrc_R_regR:1;  /* Notify R/RegR that C stopped sending crc */
        BP_U_16BIT     NtfEndCrc_regC:1;    /* Notify RegC that R stopped sending crc */
        BP_U_16BIT     eocReserved:4;       /* Reserved */
    }bits;  /* modified in version 4.2 */
  }EOCTASKS;

typedef    union
  {
   BP_U_16BIT  reg;
   struct    
   {
        BP_U_16BIT     UpdateFlag0:1;
        BP_U_16BIT     UpdateFlag1:1;
        BP_U_16BIT     UpdateFlag2:1;
        BP_U_16BIT     UpdateFlag3:1;
        BP_U_16BIT     UpdateFlag4:1;
        BP_U_16BIT     UpdateFlag5:1;
        BP_U_16BIT     UpdateFlag6:1;
        BP_U_16BIT     UpdateFlag7:1;
        BP_U_16BIT     UpdateFlag8:1;
        BP_U_16BIT     UpdateFlag9:1;
        BP_U_16BIT     UpdateFlagA:1;
        BP_U_16BIT     UpdateFlagB:1;
        BP_U_16BIT     UpdateFlagC:1;
        BP_U_16BIT     UpdateFlagD:1;
        BP_U_16BIT     UpdateFlagE:1;
        BP_U_16BIT     UpdateFlagF:1;
    }bits;
  }UPDATE_FLAG; /* added in Version 4.2 */


typedef    union
  {
   BP_U_16BIT  reg;
   struct    
   {
        BP_U_16BIT     NewDataFlag0:1;
        BP_U_16BIT     NewDataFlag1:1;
        BP_U_16BIT     NewDataFlag2:1;
        BP_U_16BIT     NewDataFlag3:1;
        BP_U_16BIT     NewDataFlag4:1;
        BP_U_16BIT     NewDataFlag5:1;
        BP_U_16BIT     NewDataFlag6:1;
        BP_U_16BIT     NewDataFlag7:1;
        BP_U_16BIT     NewDataFlag8:1;
        BP_U_16BIT     NewDataFlag9:1;
        BP_U_16BIT     NewDataFlagA:1;
        BP_U_16BIT     NewDataFlagB:1;
        BP_U_16BIT     NewDataFlagC:1;
        BP_U_16BIT     NewDataFlagD:1;
        BP_U_16BIT     NewDataFlagE:1;
        BP_U_16BIT     NewDataFlagF:1;
    }bits;
  }NEW_DATA_FLAG; /* added in version 4.2 */

typedef struct    
  {
        BP_U_8BIT         shadowRegData[16][16];    
        BP_U_8BIT         wrRegData[16][16];
        BP_U_8BIT         rdRegData[16][16];
        BP_U_8BIT         wrRegSize[16]; /* The register name/# 0-16 */
        BP_U_8BIT         rdRegSize[16]; /* The register name/# 0-16 */
  }EOC_STRUCT; 
    
 
/* Both HTUC and HTUR need these variables */

  extern EOCTASKS           BP_XDATA    eocTasks[_NO_OF_LOOPS]; 

  extern BP_U_8BIT          BP_XDATA    reg_name[_NO_OF_LOOPS]; /*cu_eoc,dsl_api,high level to control RAM*/
  extern BP_U_8BIT          BP_XDATA    api_dataBuffIndex[_NO_OF_LOOPS];/*dsl_api,high level to control RAM*/ 
         
  extern EOC_STRUCT         BP_XDATA    eocStruct[_NO_OF_LOOPS];
  extern UPDATE_FLAG        BP_XDATA    upDateFlags[_NO_OF_LOOPS];/* CU_UTILS.C uses to load shadow to RD/WR Reg */

  extern BP_U_8BIT          BP_XDATA    needs_zip_start_check[_NO_OF_LOOPS];/*should change to bit, indicates ZipStart is enabled*/ 
  extern BP_U_8BIT          BP_XDATA    og_D_Value[_NO_OF_LOOPS]; /* Original Read D value before ZipStart overwrites it*/
  extern BP_U_8BIT          BP_XDATA    write_reg_F[_NO_OF_LOOPS];/* used when performing API over EOC*/
  extern BP_U_8BIT          BP_XDATA    eocCommandReg[_NO_OF_LOOPS];/* Actual HEX EOC command */
  extern BP_U_8BIT          BP_XDATA    eocWrCommandReg[_NO_OF_LOOPS];/* Actual HEX EOC write command */
  extern BP_U_8BIT          BP_XDATA    eocRdCommandReg[_NO_OF_LOOPS];/* Actual HEX EOC read command */

  extern NEW_DATA_FLAG      BP_XDATA    newDataFlags[_NO_OF_LOOPS]; /*Notifies when new EOC data has been recieved from far-end*/
  extern BP_U_8BIT          BP_XDATA    eocLoopReg[_NO_OF_LOOPS]; /*modified copy of holdStates*/
  extern BP_U_8BIT          BP_XDATA    repeater_off[_NO_OF_LOOPS]; 

/* These variables are only needed on HTUC side */
  extern Bt8953_EOC_CTRL    BP_XDATA    eocCtrl[_NO_OF_LOOPS];
  extern BP_U_8BIT          BP_XDATA    responseDelay[_NO_OF_LOOPS];
  extern BP_U_8BIT          BP_XDATA    awaitResponse[_NO_OF_LOOPS];/* expected return value*/

/* These variables are only needed on HTUR side */
  extern BP_U_8BIT          BP_XDATA    rt_open[_NO_OF_LOOPS]; /*when 1 the HTU-R is AVAILABLE */
  extern BP_U_8BIT          BP_XDATA    eocRecvCommand[_NO_OF_LOOPS];/*actual recieved data */
  extern BP_U_8BIT          BP_XDATA    eocHoldStates[_NO_OF_LOOPS];
  extern BP_U_8BIT          BP_XDATA    eocReceiveBuffer[_NO_OF_LOOPS][16];
  extern BP_U_8BIT          BP_XDATA    dataRecCtr[_NO_OF_LOOPS];
  extern BP_U_8BIT          BP_XDATA    dataBuffSize[_NO_OF_LOOPS];
  extern BP_U_8BIT          BP_XDATA    dataBuffIndex[_NO_OF_LOOPS];


/*----------------------------------*/     
/*            Common Macros            */
/*----------------------------------*/
#ifdef    KEIL_C51
  #define    HBYTE( x )            *((BP_U_8BIT *)(&##x))
  #define    LBYTE( x )            *((BP_U_8BIT *)(&##x)+1)

  #define    GET_HBYTE( x )        *((BP_U_8BIT *)(&##x))
  #define    GET_LBYTE( x )        *((BP_U_8BIT *)(&##x)+1)
  #define    SET_HBYTE( x, y )     HBYTE( x ) = (y)
  #define    SET_LBYTE( x, y )     LBYTE( x ) = (y)
#else
  #define    GET_HBYTE( x )        (BP_U_8BIT)((x) / 256)
  #define    GET_LBYTE( x )        (BP_U_8BIT)((x) & 0xFF)
  #define    SET_HBYTE( x, y )     (BP_U_16BIT)( x ) = ((x) & 0x00FF) | ((y)<<8)
  #define    SET_LBYTE( x, y )     (BP_U_16BIT)( x ) = ((x) & 0xFF00) | ((y) & 0xFF)
#endif

/*------------------------
     common definitions    
  ------------------------*/
  #define    SET( x )            x = 1
  #define    CLEAR( x )          x = 0

  #define    FOREVER             1  

/*------------------------
     common pointers    
  ------------------------*/

#define EOC_STRUCT_DECL_PTR           EOC_STRUCT  BP_XDATA *eoc_struct_ptr
#define EOC_STRUCT_INIT_PTR(loop)     eoc_struct_ptr = &(eocStruct[loop])

/*------------------------------------------------ 
 *    Application specific function definitions
 *------------------------------------------------*/

/* EOC functions needed for HTUC side */
  void    EocMaster( BP_U_8BIT  loop );            /* eoc_mstr.c    */
  void    EocTaskHandler_CO( BP_U_8BIT  loop );    /* eoc_mstr.c    */
/* EOC functions needed for HTUR side */
  void    EocSlave( BP_U_8BIT  loop );             /* eoc_slve.c    */
  void    HandleValidRtn( BP_U_8BIT  loop );       /* eoc_slve.c    */
  void    HandleValidHold( BP_U_8BIT  loop );      /* eoc_slve.c    */
  void    EocTaskHandler_RT( BP_U_8BIT  loop );    /* eoc_slve.c    */
/* Both HTUC and HTUR sides need these functions */
  BP_U_8BIT     EocGetData( BP_U_8BIT lByte, BP_U_8BIT hByte );        
  BP_U_16BIT    EocSendWord( BP_U_8BIT command, BP_U_8BIT header );

#endif /* CU_EOC */
