
#ifdef CHAN_UNIT

/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      cu_api.h
 *
 * FILE CREATED:  June 23, 1994
 *
 * LAST MODIFIED: [4-27-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   Header File for the Channel Unit API.
 *
 * FUNCTION LIST: none
 */

/*****************************************/
/*         CHANNEL UNIT OPCODES          */
/*****************************************/

/*
 * Control
 */
#define _CU_TERMINAL_TYPE               0x00
#define _CU_CONFIGURE                   0x01
#define _CU_TRANSMIT_PAYLOAD            0x02
#define _CU_FORCE_SCR_ONES              0x03
#define _CU_RESET_RX_FIFO               0x04
#define _CU_TX_EOC_LO                   0x05
#define _CU_TX_EOC_HI                   0x06
#define _CU_LOOPBACK                    0x07
#define _CU_WRITE_MISC_OUTPUT           0x08
#define _CU_FRAME_FORMAT                0x09
#define _CU_CLEAR_ERROR_COUNTERS        0x0A
#define _CU_RESET_TX_FIFO               0x0B
#define _CU_USE_SAME_TAP                0x0C
#define _CU_REVERSE_LOOPS               0x0D
#define _CU_TFIFO_WL                    0x0E
#define _CU_RFIFO_WL_LO                 0x0F
#define _CU_RFIFO_WL_HI                 0x10
#define _CU_COMBINE_VALUE               0x11
#define _CU_COMBINE_WRITE               0x12
#define _CU_COMBINE_ADDR                0x13
#define _CU_ROUTE_VALUE                 0x14
#define _CU_ROUTE_WRITE                 0x15
#define _CU_ROUTE_ADDR                  0x16
#define _CU_DBANK_1                     0x17
#define _CU_DBANK_2                     0x18
#define _CU_DBANK_3                     0x19
#define _CU_FILL_PATT                   0x1A
#define _CU_TMAP1_VALUE                 0x1B
#define _CU_TMAP2_VALUE                 0x1C
#define _CU_TMAP3_VALUE                 0x1D
#define _CU_TMAP4_VALUE                 0x1E
#define _CU_TMAP5_VALUE                 0x1F
#define _CU_WRITE_TMAP                  0x20
#define _CU_RMAP1_VALUE                 0x21
#define _CU_RMAP2_VALUE                 0x22
#define _CU_RMAP3_VALUE                 0x23
#define _CU_WRITE_RMAP                  0x24
#define _CU_BER_START                   0x25
#define _CU_BER_CONFIGURE               0x26
#define _CU_SET_MASTER_LOOP             0x27
#define _CU_DPLL_MODE                   0x28
#define _CU_AUTO_RESTART                0x29    /* Version 6.0+ */
#define _CU_SET_MFRAME                  0x2A
#define _CU_TMAP6_VALUE                 0x2B
#define _CU_TMAP7_VALUE                 0x2C
#define _CU_TMAP8_VALUE                 0x2D
#define _CU_TMAP9_VALUE                 0x2E
#define _CU_RMAP4_VALUE                 0x2F
#define _CU_RMAP5_VALUE                 0x30
#define _CU_RMAP6_VALUE                 0x31
#define _CU_RESET_PCM                   0x32
#define _CU_REPEATER_CONFIGURE          0x33

#define _CU_WRITE_IND_LO                0x35
#define _CU_WRITE_IND_HI                0x36



#define _CU_LED_BLOCK_SET               0x70
#define _CU_LED_BLOCK_ON                0x71
#define _CU_LED_BLOCK_OFF               0x72
#define _CU_WRITE_REG_ADDR_LWR          0x73
#define _CU_WRITE_REG_ADDR_UPR          0x74
#define _CU_WRITE_REG_DATA              0x75
#define _CU_WRITE_REG_DATA_INC          0x76
#define _CU_WRITE_REG_OFFSET_LWR        0x77
#define _CU_WRITE_REG_OFFSET_UPR        0x78
#define _CU_UPDATE_LEDS                 0x79

/*
 * Status
 */
#define _CU_PRESENT                     0x80
#define _CU_SYNC                        0x81
#define _CU_RX_EOC_LO                   0x82
#define _CU_RX_EOC_HI                   0x83
#define _CU_VERSION                     0x84
#define _CU_SW_VERSION                  0x85
#define _CU_ERROR_COUNTERS_LO           0x86
#define _CU_ERROR_COUNTERS_HI           0x87
#define _CU_LOOPS_REVERSED              0x88
#define _CU_BER_STATUS                  0x89
#define _CU_MEASURE_BER                 0x8A
#define _CU_READ_COMBINE                0x8B
#define _CU_READ_ROUTE                  0x8C
#define _CU_READ_TMAP                   0x8D
#define _CU_READ_RMAP                   0x8E

#define _CU_READ_DPLL                   0x90
#define _CU_READ_IND_LO                 0x91  
#define _CU_READ_IND_HI                 0x92  

#define _CU_READ_REG                    0xA0



/* Channel Unit Versions */
#define _BT8953     0x01
#define _BT8953A    0x02
#define _BT8953B    0x03
#define _BT8953A_REVC    0x02


/* CU Frame Format Options */
#define _CU_FRAMED_DATA     0
#define _CU_UNFRAMED_DATA   1

/* CU Configuration Rates */
#define _2T1            0
#define _2E1            1
#define _3E1            2
#define _CU_CUSTOM      3
#define _1T1            4
#define _1E1            5

/* CU Loopback Options */
#define _CU_LOOPBACK_OFF    0
#define _CU_PRA_ON_PRA      1
#define _CU_HDSL_ON_PRA     2
#define _CU_PRA_ON_HDSL     3
#define _CU_HDSL_ON_HDSL    4

/* Sync State Options */
#define CU_OUT_OF_SYNC      0x0
#define CU_ACQUIRING_SYNC   0x1
#define CU_IN_SYNC          0x2
#define CU_LOSING_SYNC      0x3

/* DPLL NCO Modes */
#define _CU_DPLL_CLOSED     0
#define _CU_DPLL_OPEN       1

/* Read Reg Options */
#define _CU_READ_REG_HOLD   0
#define _CU_READ_REG_INC    1
#define _CU_READ_REG_DEC    2

/* Read Error Counter Options */
#define _CU_NUM_ERROR_CTRS      12

#define _CU_ALL_COUNTERS        0xFF
#define _CU_OUT_OF_SYNC_CTR     0
#define _CU_CRC_ERR_CTR         1
#define _CU_RFIFO_FULL_CTR      2
#define _CU_RFIFO_EMPTY_CTR     3
#define _CU_RFIFO_SLIP_CTR      4
#define _CU_TFIFO_FULL_CTR      5
#define _CU_TFIFO_EMPTY_CTR     6
#define _CU_TFIFO_SLIP_CTR      7
#define _CU_TFIFO_STUFF_CTR     8
#define _CU_DPLL_ERROR_CTR      9
#define _CU_FEBE_ERROR_CTR      10
#define _CU_LOSD_ERROR_CTR      11

/*
 * MISC Output Reg definitions
 */
#define _MISC_OUTPUT_REG    8
#define _MISC_CLRLED        0x1
#define _MISC_DIR           0x2
#define _MISC_BIT2          0x4
#define _MISC_BIT3          0x8

/*
 * Same Tap Options
 */
#define _CU_TAP_5   1
#define _CU_TAP_18  2

#define _CU_ALL_LOOPS   0


/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/
BP_U_8BIT _CuControl(BP_U_8BIT,BP_U_8BIT,BP_U_8BIT);
BP_U_8BIT _CuStatus(BP_U_8BIT,BP_U_8BIT,BP_U_8BIT,BP_S_8BIT *);

#endif /* CHAN_UNIT */
