#ifdef CHAN_UNIT

/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      cu.h
 *
 * FILE CREATED:  May 10, 1994
 *
 * LAST MODIFIED: [5-28-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   Header File for the Channel Unit & LIU.
 *
 * FUNCTION LIST: none
 */

/*
 * Global defines
 */
#define ON  1
#define OFF 0

#define MAX_DPLL_GAIN_VALUE 0x34
#define MED_DPLL_GAIN_VALUE 0x22
#define MIN_DPLL_GAIN_VALUE 0x10

/*For LED structure in CU_LED.C */
#define _NUM_BP_LED_BYTES     0x2 /*Bitpump uses two 4-bit LED blocks per byte */

#define _CU_PCM_COMMON        0x3
#define _CU_LED_CHAN1         0x4
#define _CU_LED_CHAN2         0x5
#define _CU_LED_CHAN3         0x6
#define _BP_LED_BLOCK1_2      0x7
#define _BP_LED_BLOCK3_SP     0x8
#define _MISC_TERM            0x9
#define _MISC_TEST_P          0xA



/*************************************************************************/
/*                                                                       */
/*                             WRITE REGISTERS                           */
/*                                                                       */
/*************************************************************************/


              /********************/
              /*    TRANSMITTER   */  
              /********************/
typedef BP_PACKED struct                          
{
    BP_U_8BIT teoc_lo;                  /*  00  20  40  */
    BP_U_8BIT teoc_hi;                  /*  01  21  41  */
    BP_U_8BIT tind_lo;                  /*  02  22  42  */
    BP_U_8BIT tind_hi;                  /*  03  23  43  */
    BP_U_8BIT tzbit_1;                  /*  04  24  44  */
    BP_U_8BIT tfifo_wl;                 /*  05  25  45  */
    BP_U_8BIT tcmd_1;                   /*  06  26  46  */
    BP_U_8BIT tcmd_2;                   /*  07  27  47  */
    BP_U_8BIT tmap_1;                   /*  08  28  48  */
    BP_U_8BIT tmap_2;                   /*  09  29  49  */
    BP_U_8BIT tmap_3;                   /*  0A  2A  4A  */
    BP_U_8BIT tmap_4;                   /*  0B  2B  4B  */
    BP_U_8BIT tmap_5;                   /*  0C  2C  4C  */
    BP_U_8BIT tfifo_rst;                /*  0D  2D  4D  */
    BP_U_8BIT scr_rst;                  /*  0E  2E  4E  */

/* Rev C additions */
    BP_U_8BIT tmap_6;                   /*  0F  2F  4F  */
    BP_U_8BIT tmap_7;                   /*  10  30  50  */
    BP_U_8BIT tmap_8;                   /*  11  31  51  */
    BP_U_8BIT tmap_9;                   /*  12  32  52  */

    BP_U_8BIT reserved[13];             /*  13  33  53  */
} BP_PACKED2 TX_WR;

              /********************/ 
              /*     RECEIVER     */
              /********************/
typedef BP_PACKED struct
{
    BP_U_8BIT rcmd_1;                   /*  60  80  A0  */
    BP_U_8BIT rcmd_2;                   /*  61  81  A1  */
    BP_U_8BIT rfifo_rst;                /*  62  82  A2  */
    BP_U_8BIT sync_rst;                 /*  63  83  A3  */
    BP_U_8BIT rmap_1;                   /*  64  84  A4  */
    BP_U_8BIT rmap_2;                   /*  65  85  A5  */
    BP_U_8BIT rmap_3;                   /*  66  86  A6  */
    BP_U_8BIT err_rst;                  /*  67  87  A7  */
    BP_U_8BIT rsig_loc;                 /*  68  88  A8  */

/* Rev C additions */
    BP_U_8BIT rmap_4;                   /*  69  89  A9  */
    BP_U_8BIT rmap_5;                   /*  6A  8A  AA  */
    BP_U_8BIT rmap_6;                   /*  6B  8B  AB  */

} BP_PACKED2 RX_WR;
        
             /*********************/
             /*       COMMON      */
             /*********************/
typedef BP_PACKED struct
{
    BP_U_8BIT tframe_loc_lo;            /*    C0    */
    BP_U_8BIT tframe_loc_hi;            /*    C1    */
    BP_U_8BIT tmf_loc;                  /*    C2    */
    BP_U_8BIT rframe_loc_lo;            /*    C3    */
    BP_U_8BIT rframe_loc_hi;            /*    C4    */
    BP_U_8BIT rmf_loc;                  /*    C5    */
    BP_U_8BIT mf_len;                   /*    C6    */
    BP_U_8BIT mf_cnt;                   /*    C7    */
    BP_U_8BIT frame_len_lo;             /*    C8    */
    BP_U_8BIT frame_len_hi;             /*    C9    */
    BP_U_8BIT hframe_len;               /*    CA    */
    BP_U_8BIT sync_word_a;              /*    CB    */
    BP_U_8BIT sync_word_b;              /*    CC    */
    BP_U_8BIT rfifo_wl_lo;              /*    CD    */
    BP_U_8BIT rfifo_wl_hi;              /*    CE    */
    BP_U_8BIT stf_thresh_a_lo;          /*    CF    */
    BP_U_8BIT stf_thresh_a_hi;          /*    D0    */
    BP_U_8BIT stf_thresh_b_lo;          /*    D1    */
    BP_U_8BIT stf_thresh_b_hi;          /*    D2    */
    BP_U_8BIT stf_thresh_c_lo;          /*    D3    */
    BP_U_8BIT stf_thresh_c_hi;          /*    D4    */
    BP_U_8BIT dpll_resid_lo;            /*    D5    */
    BP_U_8BIT dpll_resid_hi;            /*    D6    */
    BP_U_8BIT dpll_factor;              /*    D7    */
    BP_U_8BIT dpll_gain;                /*    D8    */
    BP_U_8BIT dpll_dly_lo;              /*    D9    */
    BP_U_8BIT dpll_dly_hi;              /*    DA    */
    BP_U_8BIT dpll_pini;                /*    DB    */
    BP_U_8BIT dbank_1;                  /*    DC    */
    BP_U_8BIT dbank_2;                  /*    DD    */
    BP_U_8BIT dbank_3;                  /*    DE    */
    BP_U_8BIT tzbit_2;                  /*    DF    */
    BP_U_8BIT tzbit_3;                  /*    E0    */
    BP_U_8BIT tzbit_4;                  /*    E1    */
    BP_U_8BIT tzbit_5;                  /*    E2    */
    BP_U_8BIT tzbit_6;                  /*    E3    */
    BP_U_8BIT tstuff;                   /*    E4    */
    BP_U_8BIT cmd_1;                    /*    E5    */
    BP_U_8BIT cmd_2;                    /*    E6    */
    BP_U_8BIT cmd_3;                    /*    E7    */
    BP_U_8BIT cmd_4;                    /*    E8    */
    BP_U_8BIT cmd_5;                    /*    E9    */
    BP_U_8BIT fill_patt;                /*    EA    */
    BP_U_8BIT imr;                      /*    EB    */
    BP_U_8BIT icr;                      /*    EC    */
    BP_U_8BIT route_tbl;                /*    ED    */
    BP_U_8BIT combine_tbl;              /*    EE    */
    BP_U_8BIT ber_rst;                  /*    EF    */
    BP_U_8BIT prbs_rst;                 /*    F0    */
    BP_U_8BIT rx_rst;                   /*    F1    */
    BP_U_8BIT rsig_tbl;                 /*    F2    */
    BP_U_8BIT cmd_6;                    /*    F3    */
    BP_U_8BIT cmd_7;                    /*    F4    */
    BP_U_8BIT hframe_len_hi;            /*    F5    */
    BP_U_8BIT dpll_rst;                 /*    F6    */
    BP_U_8BIT address_f7;               /*    F7    */
    BP_U_8BIT hframe2_len_lo;           /*    F8    */
    BP_U_8BIT hframe2_len_hi;           /*    F9    */
    BP_U_8BIT hframe3_len_lo;           /*    FA    */
    BP_U_8BIT hframe3_len_hi;           /*    FB    */
    BP_U_8BIT address_fc;               /*    FC    */
    BP_U_8BIT address_fd;               /*    FD    */
    BP_U_8BIT address_fe;               /*    FE    */
    BP_U_8BIT dummy_write;              /*    FF    */
} BP_PACKED2 COMMON_WR;

              /**************************/
              /*   PRA TRANSMIT WRITE   */  
              /**************************/
typedef BP_PACKED struct
{
    BP_U_8BIT tx_pra_ctrl0;             /*    70    */
    BP_U_8BIT tx_pra_ctrl1;             /*    71    */
    BP_U_8BIT tx_bits_buff1;            /*    72    */
    BP_U_8BIT tx_pra_tmsync_offset;     /*    73    */
    BP_U_8BIT tx_bits_buff0;            /*    74    */
} BP_PACKED2 PRA_TX_WR;

              /*************************/
              /*   PRA RECEIVE WRITE   */  
              /*************************/
typedef BP_PACKED struct
{
    BP_U_8BIT rx_pra_ctrl0;             /*    B0    */
    BP_U_8BIT rx_pra_ctrl1;             /*    B1    */
    BP_U_8BIT rx_bits_buff1;            /*    B2    */
    BP_U_8BIT rx_pra_tmsync_offset;     /*    B3    */
    BP_U_8BIT rx_bits_buff0;            /*    B4    */
} BP_PACKED2 PRA_RX_WR;



/*************************************************************************/
/*                                                                       */
/*                              READ REGISTERS                           */
/*                                                                       */
/*************************************************************************/


              /********************/ 
              /*     RECEIVER     */
              /********************/
typedef BP_PACKED struct
{
    BP_U_8BIT reoc_lo;                  /*  00  08  10  */
    BP_U_8BIT reoc_hi;                  /*  01  09  11  */
    BP_U_8BIT rind_lo;                  /*  02  0A  12  */
    BP_U_8BIT rind_hi;                  /*  03  0B  13  */
    BP_U_8BIT rzbit_1;                  /*  04  0C  14  */
    BP_U_8BIT rstatus_1;                /*  05  0D  15  */
    BP_U_8BIT rstatus_2;                /*  06  0E  16  */
} BP_PACKED2 RX_RD;
                  
              /********************/
              /*    TRANSMITTER   */  
              /********************/
typedef BP_PACKED struct
{
    BP_U_8BIT tstatus_1;                /*  07  0F  17  */
} BP_PACKED2 TX_RD;


              /*******************************/
              /*   RECEIVER ERROR COUNTERS   */  
              /*******************************/
typedef BP_PACKED struct
{
    BP_U_8BIT crc_cnt;                  /*  21  29  31  */
    BP_U_8BIT febe_cnt;                 /*  22  2A  32  */
} BP_PACKED2 RX_ERR_CNTR;


             /*********************/
             /*       COMMON      */
             /*********************/
typedef BP_PACKED struct
{
    BP_U_8BIT rzbit_2;                  /*    18    */
    BP_U_8BIT rzbit_3;                  /*    19    */
    BP_U_8BIT rzbit_4;                  /*    1A    */
    BP_U_8BIT rzbit_5;                  /*    1B    */
    BP_U_8BIT rzbit_6;                  /*    1C    */
    BP_U_8BIT ber_meter;                /*    1D    */
    BP_U_8BIT ber_status;               /*    1E    */
    BP_U_8BIT irr;                      /*    1F    */
    BP_U_8BIT dpll_resid_hi;            /*    20    */
    RX_ERR_CNTR rx_err_cntr1;           /* 21 -- 22 */
    BP_U_8BIT reserved_1[5];            /* 23 -- 27 */
    BP_U_8BIT dpll_resid_lo;            /*    28    */
    RX_ERR_CNTR rx_err_cntr2;           /* 29 -- 2A */
    BP_U_8BIT reserved_2[5];            /* 2B -- 2F */
    BP_U_8BIT imr;                      /*    30    */
    RX_ERR_CNTR rx_err_cntr3;           /* 31 -- 32 */
    BP_U_8BIT reserved_3[5];            /* 33 -- 37 */
    BP_S_8BIT dpll_phs_err;             /*    38    */
    BP_U_8BIT msync_phs_lo;             /*    39    */
    BP_U_8BIT msync_phs_hi;             /*    3A    */
    BP_U_8BIT shadow_wr;                /*    3B    */
    BP_U_8BIT err_status;               /*    3C    */
    BP_U_8BIT reserved_4[3];            /* 3D -- 3F */
} BP_PACKED2 COMMON_RD;

              /*************************/
              /*   PRA TRANSMIT READ   */  
              /*************************/
typedef BP_PACKED struct
{
    BP_U_8BIT tx_pra_ctrl0;             /*    40    */
    BP_U_8BIT tx_pra_ctrl1;             /*    41    */
    BP_U_8BIT tx_pra_mon1;              /*    42    */
    BP_U_8BIT tx_pra_e_cnt;             /*    43    */
    BP_U_8BIT tx_pra_code;              /*    44    */
    BP_U_8BIT tx_pra_mon0;              /*    45    */
    BP_U_8BIT tx_pra_mon2;              /*    46    */
} BP_PACKED2 PRA_TX_RD;

              /************************/
              /*   PRA RECEIVE READ   */  
              /************************/
typedef BP_PACKED struct
{
    BP_U_8BIT rx_pra_ctrl0;             /*    80    */
    BP_U_8BIT rx_pra_ctrl1;             /*    81    */
    BP_U_8BIT rx_bits_buff1;             /*    82    */
    BP_U_8BIT rx_pra_e_cnt;             /*    83    */
    BP_U_8BIT rx_pra_code;              /*    84    */
    BP_U_8BIT rx_pra_mon0;              /*    85    */
    BP_U_8BIT rx_pra_mon2;              /*    86    */
} BP_PACKED2 PRA_RX_RD;



/*************************************************************************/
/*                                                                       */
/*                      CU GLOBAL STRUCTURE DEFINITIONS                  */
/*                                                                       */
/*************************************************************************/


typedef BP_PACKED struct
{
    TX_WR tx_wr_loop1;                    /* 0x00 - 0x1F */
    TX_WR tx_wr_loop2;                    /* 0x20 - 0x3F */
    TX_WR tx_wr_loop3;                    /* 0x40 - 0x5F */
    RX_WR rx_wr_loop1;                    /* 0x60 - 0x6B */
    BP_U_8BIT reserved1[4];           /* 0x6C - 0x6F */
    PRA_TX_WR pra_tx_wr;                  /* 0x70 - 0x74 */
    BP_U_8BIT reserved2[11];          /* 0x75 - 0x7F */
    RX_WR rx_wr_loop2;                    /* 0x80 - 0x8B */
    BP_U_8BIT reserved3[20];          /* 0x8C - 0x9F */
    RX_WR rx_wr_loop3;                    /* 0xA0 - 0xAB */
    BP_U_8BIT reserved4[4];           /* 0xAC - 0xAF */
    PRA_RX_WR pra_rx_wr;                  /* 0xB0 - 0xB4 */
    BP_U_8BIT reserved5[11];          /* 0xB5 - 0xBF */
    COMMON_WR common_wr_regs;             /* 0xC0 - 0xFF */
} BP_PACKED2 CU_WR;

typedef BP_PACKED struct
{
    RX_RD rx_rd_loop1;
    TX_RD tx_rd_loop1;
    RX_RD rx_rd_loop2;
    TX_RD tx_rd_loop2;
    RX_RD rx_rd_loop3;
    TX_RD tx_rd_loop3;
    COMMON_RD common_rd_regs;
    PRA_TX_RD pra_tx_rd;               /* 0x40 - 0x46 */
    BP_U_8BIT reserved1[56];       /* 0x47 - 0x7F */
    PRA_RX_RD pra_rx_rd;               /* 0x80 - 0x86 */
} BP_PACKED2 CU_RD;

extern CU_WR BP_XDATA * BP_XDATA cu_wr;
extern CU_RD BP_XDATA * BP_XDATA cu_rd;


/*************************************************************************/
/*                                                                       */
/*        BIT-FIELD STRUCTURES for CONTROL/STATUS REGISTERS              */
/*                                                                       */
/*************************************************************************/
#ifdef BIT_REVERSE

typedef BP_PACKED union   
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD rx_err:1;
        BP_BIT_FIELD tx_err:1;
        BP_BIT_FIELD rx3:1;
        BP_BIT_FIELD rx2:1;
        BP_BIT_FIELD rx1:1;
        BP_BIT_FIELD tx3:1;
        BP_BIT_FIELD tx2:1;
        BP_BIT_FIELD tx1:1;

    } bits;
} BP_PACKED2 IRR;
                                               
typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :2;
        BP_BIT_FIELD rfifo_slip:1;
        BP_BIT_FIELD rfifo_empty:1;
        BP_BIT_FIELD rfifo_full:1;
        BP_BIT_FIELD rx_stuff:1;
        BP_BIT_FIELD tr_invert:1;
        BP_BIT_FIELD sync_ab:1;
    } bits;
} BP_PACKED2 RSTATUS_1;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD febe_ovr:1;
        BP_BIT_FIELD crc_ovr:1;
        BP_BIT_FIELD crc_err:1;
        BP_BIT_FIELD sync_state:2;
        BP_BIT_FIELD state_cnt:3;
    } bits;
} BP_PACKED2 RSTATUS_2;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :3;
        BP_BIT_FIELD stuff_err:1;
        BP_BIT_FIELD tfifo_slip:1;
        BP_BIT_FIELD tfifo_empty:1;
        BP_BIT_FIELD tfifo_full:1;
        BP_BIT_FIELD tx_stuff:1;
    } bits;
} BP_PACKED2 TSTATUS_1;      

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :1;
        BP_BIT_FIELD dpll_err:1;
        BP_BIT_FIELD rx3_err:1;
        BP_BIT_FIELD rx2_err:1;
        BP_BIT_FIELD rx1_err:1;
        BP_BIT_FIELD tx3_err:1;
        BP_BIT_FIELD tx2_err:1;
        BP_BIT_FIELD tx1_err:1;
    } bits;
} BP_PACKED2 ERR_STATUS;

typedef BP_PACKED union        
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :5;
        BP_BIT_FIELD sync_done:1;
        BP_BIT_FIELD ber_done:1;
        BP_BIT_FIELD ber_sync:1;
    } bits;
} BP_PACKED2 BER_STATUS;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :1;
        BP_BIT_FIELD proportional_gain:3;
        BP_BIT_FIELD integration_coef:4;
    } bits;
} BP_PACKED2 DPLL_GAIN;


/*
 * The 1st 3 bits are used for Pair ID.  Use the last 5 bits for
 * determining when 6 consecutive frames occur.
 */

#define ZBIT_PID_THRESHOLD   6

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD counter:3;
        BP_BIT_FIELD start:1;
        BP_BIT_FIELD valid:1;
        BP_BIT_FIELD pair_num3:1;
        BP_BIT_FIELD pair_num2:1;
        BP_BIT_FIELD pair_num1:1;
        } bits;
} BP_PACKED2 CU_ZBIT_PID;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD rcbe:1;
        BP_BIT_FIELD rrbe:1;
        BP_BIT_FIELD hrp:1;
        BP_BIT_FIELD bpv:1;
        BP_BIT_FIELD ps2:1;
        BP_BIT_FIELD ps1:1;
        BP_BIT_FIELD febe:1;
        BP_BIT_FIELD losd:1;
        } bits;
} BP_PACKED2 CU_IND_LO;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD unused:3;
        BP_BIT_FIELD unspecified:2;
        BP_BIT_FIELD rtr:1;
        BP_BIT_FIELD rta:1;
        BP_BIT_FIELD rega:1;
        } bits;
} BP_PACKED2 CU_IND_HI;            


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :1;
        BP_BIT_FIELD insert_en:1;
        BP_BIT_FIELD route_ch3:2;
        BP_BIT_FIELD route_ch2:2;
        BP_BIT_FIELD route_ch1:2;
    } bits;
} BP_PACKED2 ROUTE_TBL;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :2;
        BP_BIT_FIELD dbank_sel:2;
        BP_BIT_FIELD drop_en:1;
        BP_BIT_FIELD ber_en:1;
        BP_BIT_FIELD combine:2;
    } bits;
} BP_PACKED2 COMBINE_TBL;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :1;                         
        BP_BIT_FIELD tx_err_en:1;
        BP_BIT_FIELD force_one:1;
        BP_BIT_FIELD hoh_en:1;
        BP_BIT_FIELD sync_sel:1;
        BP_BIT_FIELD icrc_err:1;
        BP_BIT_FIELD two_level:1;
        BP_BIT_FIELD scr_en:1;
    } bits;
} BP_PACKED2 TCMD_1;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :1;
        BP_BIT_FIELD stuff_cntr_mode:1;          
        BP_BIT_FIELD ext_zbit:1;
        BP_BIT_FIELD repeat_en:1;
        BP_BIT_FIELD taux_en:1;
        BP_BIT_FIELD slv_stf:1;
        BP_BIT_FIELD scr_tap:1;
        BP_BIT_FIELD hh_loop:1;
    } bits;
} BP_PACKED2 TCMD_2;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD framer_en:2;              
        BP_BIT_FIELD loss_sync:3;
        BP_BIT_FIELD reach_sync:3;

    } bits;
} BP_PACKED2 RCMD_1;            

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD rx_err_en:1;
        BP_BIT_FIELD ph_loop:1;
        BP_BIT_FIELD dscr_en:1;                
        BP_BIT_FIELD dscr_tap:1;
        BP_BIT_FIELD thresh_corr:4;

    } bits;
} BP_PACKED2 RCMD_2;      

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD e1_mode:1;               
        BP_BIT_FIELD pll_dis:1;
        BP_BIT_FIELD pll_div:2;
        BP_BIT_FIELD pll_mul:4;
    } bits;
} BP_PACKED2 COMMON_CMD_1;         

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD gclk_sel:1;
        BP_BIT_FIELD pcm_float:1;           
        BP_BIT_FIELD hp_loop:1;
        BP_BIT_FIELD pp_loop:1;
        BP_BIT_FIELD rclk_sel:2;
        BP_BIT_FIELD tclk_sel:2;
    } bits;
} BP_PACKED2 COMMON_CMD_2;      

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD rsig_wr:1;             
        BP_BIT_FIELD prbs_mode:2;
        BP_BIT_FIELD ber_scale:2;
        BP_BIT_FIELD prbs_dis:1;
        BP_BIT_FIELD route_en:1;
        BP_BIT_FIELD comb_en:1;
    } bits;
} BP_PACKED2 COMMON_CMD_3;         

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD dpll_nco:1;             
        BP_BIT_FIELD master_sel:2;
        BP_BIT_FIELD zbit_sel:2;
        BP_BIT_FIELD ext_stuff:1;
        BP_BIT_FIELD stuff_sel:2;
    } bits;
} BP_PACKED2 COMMON_CMD_5;         

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD raz_1:1;
        BP_BIT_FIELD raz_2:1;              
        BP_BIT_FIELD raz_3:1;
        BP_BIT_FIELD raux_en:1;
        BP_BIT_FIELD rsig_en:1;
        BP_BIT_FIELD msync_meas:1;
        BP_BIT_FIELD ber_sel:2;
    } bits;
} BP_PACKED2 COMMON_CMD_6;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD :2;
        BP_BIT_FIELD nco_scale:1;
        BP_BIT_FIELD rclk_inv:1;       
        BP_BIT_FIELD phd_mode:2;
        BP_BIT_FIELD fast_acq:1;
        BP_BIT_FIELD dpll_err_en:1;
    } bits;
} BP_PACKED2 COMMON_CMD_7;         




/********************************************************************/

/*
 * The CU_RTR_IND_STATUS strucutre is used to make sure 6 consective
 * RTR (Ready to Receive) indicator bits are 0 before it is valid
 */

#define RTR_IND_THRESHOLD   6

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD counter:7;
        BP_BIT_FIELD valid:1;
        } bits;
} BP_PACKED2 CU_RTR_IND_STATUS;


/*
 * CU Chip Version
 */
typedef BP_PACKED struct
{
    BP_BIT_FIELD :2;
    BP_BIT_FIELD present:1;
    BP_BIT_FIELD major:2;
    BP_BIT_FIELD minor:3;

} BP_PACKED2 CU_CHIP_VERSION;

typedef BP_PACKED struct
{
    BP_BIT_FIELD :2;
    BP_BIT_FIELD _CuAutoRestart:1;
    BP_BIT_FIELD _CuUpdateLeds:1;
    BP_BIT_FIELD _CuFrameFormat:1;
    BP_BIT_FIELD _CuLoopsReversed:1;
    BP_BIT_FIELD _CuMasterLoop:2;
} BP_PACKED2 CU_FLAGS;


/*
 * Channel Unit LED block  
 */
typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD reserved:4;
        BP_BIT_FIELD rfifo_err:1;
        BP_BIT_FIELD tfifo_err:1;
        BP_BIT_FIELD out_of_sync:1;
        BP_BIT_FIELD in_sync:1;
        } bits;

} BP_PACKED2 CU_LED_BLOCK;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD reserved:4;
        BP_BIT_FIELD t1e1_err:1;
        BP_BIT_FIELD t1e1_lof:1;
        BP_BIT_FIELD t1e1_sync:1;
        BP_BIT_FIELD dpll_err:1;
        } bits;
} BP_PACKED2 CU_PCM_LED_BLOCK;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD reserved:4;
        BP_BIT_FIELD bp2_rd:1;
        BP_BIT_FIELD bp2_gr:1;
        BP_BIT_FIELD bp1_rd:1;
        BP_BIT_FIELD bp1_gr:1;
        } bits;
} BP_PACKED2 CU_BP_LED_BLOCK;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD reserved:6;
        BP_BIT_FIELD framer_term:2;
        } bits;
} BP_PACKED2 MISC_TERM;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD reserved:8;
        } bits;
} BP_PACKED2 _MISC_TEST_P;


#else /* not BIT_REVERSE */

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD tx1:1;
        BP_BIT_FIELD tx2:1;
        BP_BIT_FIELD tx3:1;
        BP_BIT_FIELD rx1:1;
        BP_BIT_FIELD rx2:1;
        BP_BIT_FIELD rx3:1;
        BP_BIT_FIELD tx_err:1;
        BP_BIT_FIELD rx_err:1;
    } bits;
} BP_PACKED2 IRR;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD sync_ab:1;
        BP_BIT_FIELD tr_invert:1;
        BP_BIT_FIELD rx_stuff:1;
        BP_BIT_FIELD rfifo_full:1;
        BP_BIT_FIELD rfifo_empty:1;
        BP_BIT_FIELD rfifo_slip:1;
        BP_BIT_FIELD :2;
    } bits;
} BP_PACKED2 RSTATUS_1;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD state_cnt:3;
        BP_BIT_FIELD sync_state:2;
        BP_BIT_FIELD crc_err:1;
        BP_BIT_FIELD crc_ovr:1;
        BP_BIT_FIELD febe_ovr:1;
    } bits;
} BP_PACKED2 RSTATUS_2;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD tx_stuff:1;
        BP_BIT_FIELD tfifo_full:1;
        BP_BIT_FIELD tfifo_empty:1;
        BP_BIT_FIELD tfifo_slip:1;
        BP_BIT_FIELD stuff_err:1;
        BP_BIT_FIELD :3;
    } bits;
} BP_PACKED2 TSTATUS_1;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD tx1_err:1;
        BP_BIT_FIELD tx2_err:1;
        BP_BIT_FIELD tx3_err:1;
        BP_BIT_FIELD rx1_err:1;
        BP_BIT_FIELD rx2_err:1;
        BP_BIT_FIELD rx3_err:1;
        BP_BIT_FIELD dpll_err:1;
        BP_BIT_FIELD :1;
    } bits;
} BP_PACKED2 ERR_STATUS;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD ber_sync:1;
        BP_BIT_FIELD ber_done:1;
        BP_BIT_FIELD sync_done:1;
        BP_BIT_FIELD :5;
    } bits;
} BP_PACKED2 BER_STATUS;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD integration_coef:4;
        BP_BIT_FIELD proportional_gain:3;
        BP_BIT_FIELD :1;
    } bits;
} BP_PACKED2 DPLL_GAIN;

/*
 * The 1st 3 bits are used for Pair ID.  Use the last 5 bits for
 * determining when 6 consecutive frames occur.
 */

#define ZBIT_PID_THRESHOLD   6

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD pair_num1:1;
        BP_BIT_FIELD pair_num2:1;
        BP_BIT_FIELD pair_num3:1;
        BP_BIT_FIELD valid:1;
        BP_BIT_FIELD start:1;
        BP_BIT_FIELD counter:3;
        } bits;
} BP_PACKED2 CU_ZBIT_PID;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD losd:1;
        BP_BIT_FIELD febe:1;
        BP_BIT_FIELD ps1:1;
        BP_BIT_FIELD ps2:1;
        BP_BIT_FIELD bpv:1;
        BP_BIT_FIELD hrp:1;
        BP_BIT_FIELD rrbe:1;
        BP_BIT_FIELD rcbe:1;
        } bits;
} BP_PACKED2 CU_IND_LO;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD rega:1;
        BP_BIT_FIELD rta:1;
        BP_BIT_FIELD rtr:1;
        BP_BIT_FIELD unspecified:2;
        BP_BIT_FIELD unused:3;
        } bits;
} BP_PACKED2 CU_IND_HI;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD route_ch1:2;
        BP_BIT_FIELD route_ch2:2;
        BP_BIT_FIELD route_ch3:2;
        BP_BIT_FIELD insert_en:1;
        BP_BIT_FIELD :1;
    } bits;
} BP_PACKED2 ROUTE_TBL;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD combine:2;
        BP_BIT_FIELD ber_en:1;
        BP_BIT_FIELD drop_en:1;
        BP_BIT_FIELD dbank_sel:2;
        BP_BIT_FIELD :2;
    } bits;
} BP_PACKED2 COMBINE_TBL;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD scr_en:1;
        BP_BIT_FIELD two_level:1;
        BP_BIT_FIELD icrc_err:1;
        BP_BIT_FIELD sync_sel:1;
        BP_BIT_FIELD hoh_en:1;
        BP_BIT_FIELD force_one:1;
        BP_BIT_FIELD tx_err_en:1;
        BP_BIT_FIELD :1;
    } bits;
} BP_PACKED2 TCMD_1;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD hh_loop:1;
        BP_BIT_FIELD scr_tap:1;
        BP_BIT_FIELD slv_stf:1;
        BP_BIT_FIELD taux_en:1;
        BP_BIT_FIELD repeat_en:1;
        BP_BIT_FIELD ext_zbit:1;
        BP_BIT_FIELD stuff_cntr_mode:1;
        BP_BIT_FIELD :1;
    } bits;
} BP_PACKED2 TCMD_2;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD reach_sync:3;
        BP_BIT_FIELD loss_sync:3;
        BP_BIT_FIELD framer_en:2;
    } bits;
} BP_PACKED2 RCMD_1;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD thresh_corr:4;
        BP_BIT_FIELD dscr_tap:1;
        BP_BIT_FIELD dscr_en:1;
        BP_BIT_FIELD ph_loop:1;
        BP_BIT_FIELD rx_err_en:1;
    } bits;
} BP_PACKED2 RCMD_2;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD pll_mul:4;
        BP_BIT_FIELD pll_div:2;
        BP_BIT_FIELD pll_dis:1;
        BP_BIT_FIELD e1_mode:1;
    } bits;
} BP_PACKED2 COMMON_CMD_1;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD tclk_sel:2;
        BP_BIT_FIELD rclk_sel:2;
        BP_BIT_FIELD pp_loop:1;
        BP_BIT_FIELD hp_loop:1;
        BP_BIT_FIELD pcm_float:1;
        BP_BIT_FIELD gclk_sel:1;
    } bits;
} BP_PACKED2 COMMON_CMD_2;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD comb_en:1;
        BP_BIT_FIELD route_en:1;
        BP_BIT_FIELD prbs_dis:1;
        BP_BIT_FIELD ber_scale:2;
        BP_BIT_FIELD prbs_mode:2;
        BP_BIT_FIELD rsig_wr:1;
    } bits;
} BP_PACKED2 COMMON_CMD_3;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD stuff_sel:2;
        BP_BIT_FIELD ext_stuff:1;
        BP_BIT_FIELD zbit_sel:2;
        BP_BIT_FIELD master_sel:2;
        BP_BIT_FIELD dpll_nco:1;
    } bits;
} BP_PACKED2 COMMON_CMD_5;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD ber_sel:2;
        BP_BIT_FIELD msync_meas:1;
        BP_BIT_FIELD rsig_en:1;
        BP_BIT_FIELD raux_en:1;
        BP_BIT_FIELD raz_3:1;
        BP_BIT_FIELD raz_2:1;
        BP_BIT_FIELD raz_1:1;
    } bits;
} BP_PACKED2 COMMON_CMD_6;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
    {
        BP_BIT_FIELD dpll_err_en:1;
        BP_BIT_FIELD fast_acq:1;
        BP_BIT_FIELD phd_mode:2;
        BP_BIT_FIELD rclk_inv:1;
        BP_BIT_FIELD nco_scale:1;
        BP_BIT_FIELD :2;
    } bits;
} BP_PACKED2 COMMON_CMD_7;




/********************************************************************/

/*
 * The CU_RTR_IND_STATUS strucutre is used to make sure 6 consective
 * RTR (Ready to Receive) indicator bits are 0 before it is valid
 */

#define RTR_IND_THRESHOLD   6

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD valid:1;
        BP_BIT_FIELD counter:7;
        } bits;
} BP_PACKED2 CU_RTR_IND_STATUS;


/*
 * CU Chip Version
 */
typedef BP_PACKED struct
{
    BP_BIT_FIELD minor:3;
    BP_BIT_FIELD major:2;
    BP_BIT_FIELD present:1;
    BP_BIT_FIELD :2;
} BP_PACKED2 CU_CHIP_VERSION;

typedef BP_PACKED struct
{
    BP_BIT_FIELD _CuMasterLoop:2;
    BP_BIT_FIELD _CuLoopsReversed:1;
    BP_BIT_FIELD _CuFrameFormat:1;
    BP_BIT_FIELD _CuUpdateLeds:1;
    BP_BIT_FIELD _CuAutoRestart:1;
    BP_BIT_FIELD :2;
} BP_PACKED2 CU_FLAGS;

/*
 * Channel Unit LED block
 */
typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD in_sync:1;
        BP_BIT_FIELD out_of_sync:1;
        BP_BIT_FIELD tfifo_err:1;
        BP_BIT_FIELD rfifo_err:1;
        BP_BIT_FIELD reserved:4;
        } bits;
} BP_PACKED2 CU_LED_BLOCK;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD dpll_err:1;
        BP_BIT_FIELD t1e1_sync:1;
        BP_BIT_FIELD t1e1_lof:1;
        BP_BIT_FIELD t1e1_err:1;
        BP_BIT_FIELD reserved:4;
        } bits;
} BP_PACKED2 CU_PCM_LED_BLOCK;

typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD bp1_gr:1;
        BP_BIT_FIELD bp1_rd:1;
        BP_BIT_FIELD bp2_gr:1;
        BP_BIT_FIELD bp2_rd:1;
        BP_BIT_FIELD reserved:4;
        } bits;
} BP_PACKED2 CU_BP_LED_BLOCK;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD framer_term:2;
        BP_BIT_FIELD reserved:6;
        } bits;
} BP_PACKED2 MISC_TERM;


typedef BP_PACKED union
{
    BP_U_8BIT reg;
    struct
        {
        BP_BIT_FIELD reserved:8;
        } bits;
} BP_PACKED2 MISC_TEST_P;



#endif /* end else BIT_REVERSE */


/********************************************************************/


/*
 * This structure keeps track of certain registers.  This is necessary
 * since the part in not Write/Readable
 */
typedef BP_PACKED struct
{
    COMMON_CMD_1 cmd_1;
    COMMON_CMD_2 cmd_2;
    COMMON_CMD_3 cmd_3;
    COMMON_CMD_5 cmd_5;
    COMMON_CMD_6 cmd_6;
    COMMON_CMD_7 cmd_7;
    TCMD_1 tcmd_1[_NO_OF_LOOPS];
    TCMD_2 tcmd_2[_NO_OF_LOOPS];
    RCMD_1 rcmd_1[_NO_OF_LOOPS];
    RCMD_2 rcmd_2[_NO_OF_LOOPS];
    IRR imr;
    DPLL_GAIN dpll_gain;
    BP_U_8BIT dpll_factor;
    CU_IND_LO tind_lo[_NO_OF_LOOPS];
    CU_IND_HI tind_hi[_NO_OF_LOOPS];
    CU_ZBIT_PID tzbit_pid[_NO_OF_LOOPS];
    BP_U_8BIT zbits_common[5];
} BP_PACKED2 CU_REG_COPY;

typedef BP_PACKED struct
{
    BP_U_8BIT reoc_lo[_NO_OF_LOOPS];
    BP_U_8BIT reoc_hi[_NO_OF_LOOPS];
    CU_IND_LO rind_lo[_NO_OF_LOOPS];
    CU_IND_HI rind_hi[_NO_OF_LOOPS];
    CU_RTR_IND_STATUS rtr_ind_status[_NO_OF_LOOPS];
    CU_ZBIT_PID rzbit_pid[_NO_OF_LOOPS];
    BP_U_8BIT zbits_common[5];
} BP_PACKED2 CU_RX_HOH;

/* Globals */
extern CU_REG_COPY BP_XDATA cu_reg_copy;
extern CU_RX_HOH BP_XDATA cu_rx_hoh;
extern CU_CHIP_VERSION BP_XDATA _CuChipVersion;
extern CU_FLAGS BP_XDATA _CuFlags;



#ifdef CU_LED
extern CU_LED_BLOCK BP_XDATA cu_led_block[_NO_OF_LOOPS];
extern CU_PCM_LED_BLOCK BP_XDATA cu_pcm_led_block;
extern CU_BP_LED_BLOCK BP_XDATA cu_bp_led_block[_NUM_BP_LED_BYTES];
extern MISC_TERM BP_XDATA misc_term;
extern MISC_TEST_P BP_XDATA misc_test_p;
#endif /* CU_LED */

extern BP_U_8BIT BP_XDATA PID_usage;
extern BP_U_8BIT BP_XDATA expect_pid[_NO_OF_LOOPS];

extern BP_U_16BIT BP_XDATA error_ctrs[_CU_NUM_ERROR_CTRS][_NO_OF_LOOPS];

#define IGNORE_RFIFO_THRESHOLD          3
#define IGNORE_TFIFO_THRESHOLD          3
extern BP_U_8BIT BP_XDATA ignore_rfifo_err_ctr[_NO_OF_LOOPS];
extern BP_U_8BIT BP_XDATA ignore_tfifo_err_ctr[_NO_OF_LOOPS];

/*
 * Function Protos
 */
#ifdef CU_LED
void set_LED_block(BP_U_8BIT no, BP_U_8BIT request, BP_U_8BIT parameter);
#endif /* CU_LED */


extern BP_U_8BIT BP_XDATA cu_dpll_state_man;

#define DPLL_IDLE_STATE         0
#define DPLL_MIN_GAIN_STATE     1
#define DPLL_MED_GAIN_STATE     2
#define DPLL_MAX_GAIN_STATE     3  /* swapped pound define for min and max */

#define DPLL_FRAME_WAIT         40

#define TERM_75          1  /*Termination for E1*/
#define TERM_100         2  /*Termination for T1*/


/*
 * Macros
 */
#define _CU_DUMMY_WRITE(reg) cu_wr->common_wr_regs.dummy_write = reg;



#ifdef C51
#define _DisableCuInterrupt()    EX1 = 0
#define _EnableCuInterrupt()     EX1 = 1
#else

    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section cu.h.1    Begins         <<<*/
    /*----------------------------------------------------------*/
    /* Modification Description:                                */
    /* Disable the Channel Unit Interrupt Handler.              */
    /*                                                          */
    /* Reference:                                               */
    /*                                                          */
    /*----------------------------------------------------------*/
/* microprocessor specific */
#define _DisableCuInterrupt()
#define _EnableCuInterrupt()
    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section cu.h.1    Ends           <<<*/
    /*----------------------------------------------------------*/

#endif

#endif /* CHAN_UNIT */

