#ifdef CHAN_UNIT

/*
 * PROGRAM NAME:  Bt8952/Bt8953 EVM System
 *
 * VERSION:       4.3
 *
 * FILENAME:      chanunit.h
 *
 * FILE CREATED:  November 10, 1994
 *
 * LAST MODIFIED: [4-19-99]
 *
 * DEVELOPED BY:  Dean Rasmussen
 *                (C) Copyright 1995
 *                Brooktree Inc.
 *                San Diego, CA
 *
 * DESCRIPTION:   Header File for the Channel Unit EVM System.
 *                Each module that uses any of the Channel Unit
 *                should include this file.
 *
 * FUNCTION LIST: none
 */

#ifdef C51
#include <reg51.h>
#endif

#include "..\typedefs.h"            /* Datafield type definitions */
#include "..\bt_api.h"              /* Destination definitions */
#include "..\dsl_api.h"             /* For Single Loop */ 


#include "..\bitpump\bitpump.h"        /* _CU_COMMON, _CU_CHAN1, LOW, HIGH, etc definitions */
#include "..\bitpump\btmain.h"        /* _NO_OF_LOOPS definitions */
#include "..\bitpump\api.h"         /* _PASS, _FAIL, NOT_PRESENT, etc definitions */
#include "..\bitpump\extern.h"

#include "..\bitpump\mail.h"        /* WriteHostMailBox()  */
#include "..\bitpump\serint.h"      /* CHECKSUM definition */
#include "..\bitpump\testmode.h"    /* to resolve ERLE_MODE_BITS */
#include "..\dsl_main.h"            /* must be after bit-pump header files */
                                    /* Definition of ACTIVE_TX_RX_STATE       */

#include "cu_api.h"                 /* 'cu_api.h' has to before 'cu.h' */
#include "cu.h"
#include "frmr_api.h"
#include "framer.h"
#include "cu_table.h"
#include "cu_asm.h"
#include "cu_map.h"
#include "cu_loop.h"
#include "cu_utils.h"
#include "cu_init.h"
#ifdef CU_EOC
#include "cu_eoc.h"             /* EOC header file */
#endif /* CU_EOC */
#ifdef PERF_MONITOR
#include "cu_perf.h"
#endif /* PERF_MONITOR */

#endif /* CHAN_UNIT */
