/***********************************************************/
/*    BT_API.H                                             */
/*    (C) Copyright 1998 by Rockwell Semiconductor Systems */
/*                                                         */
/*                                                         */
/* Description:                                            */
/*    definitions for BtControl() / BtStatus() API         */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*                                                         */
/* List of Functions found in this module:                 */
/*                                                         */
/* Revision History:                                       */
/*     date/name of reviser                                */
/*                                                         */
/* Aug 98 - New: Dean Rasmussen                            */
/*                                                         */
/***********************************************************/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/


#define _PASS 0
#define _FAIL 1


/* Define destination Bitpump */
#define _BIT_PUMP0    (BP_U_8BIT)0
#define _BIT_PUMP1    (BP_U_8BIT)1
#define _BIT_PUMP2    (BP_U_8BIT)2
#define _BIT_PUMP3    (BP_U_8BIT)3
#define _BIT_PUMP4    (BP_U_8BIT)4
#define _BIT_PUMP5    (BP_U_8BIT)5

#ifdef CHAN_UNIT

/* Define Channel Unit & Framer destination */
#define _CU_COMMON  (BP_U_8BIT)3
#define _CU_CHAN1   (BP_U_8BIT)4
#define _CU_CHAN2   (BP_U_8BIT)5
#define _CU_CHAN3   (BP_U_8BIT)6
#define _FRAMER     (BP_U_8BIT)7

#endif /* CHAN_UNIT */

/*
 * System Destination Fields
 */
#define _DSL_APPLICATION   (BP_U_8BIT)8
#define _DSL_CHANNEL0      (BP_U_8BIT)9
#define _DSL_CHANNEL1      (BP_U_8BIT)10
#define _DSL_CHANNEL2      (BP_U_8BIT)11



/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

BP_U_8BIT _BtStatus(BP_U_8BIT no, BP_U_8BIT opcode, BP_U_8BIT parameter, BP_S_8BIT *indication);
BP_U_8BIT _BtControl(BP_U_8BIT no, BP_U_8BIT opcode, BP_U_8BIT parameter);
