/***********************************************************/
/*    BT_API.C                                             */
/*    (C) Copyright 1998 by Rockwell Semiconductor Systems */
/*                                                         */
/*                                                         */
/* Description:                                            */
/*    This is the BtControl()/BtStatus() API command       */
/*    wrapper functions.                                   */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*                                                         */
/* List of Functions found in this module:                 */
/*                                                         */
/*    _BtControl()                                         */
/*    _BtStatus()                                          */
/*                                                         */
/*                                                         */
/* Revision History:                                       */
/*     date/name of reviser                                */
/*                                                         */
/* Aug 98 - New: Dean Rasmussen                            */
/*                                                         */
/***********************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/
#include "dsl_incl.h"

/**************************************************************/
/*    _BtControl()                                            */
/*    Execute control command.                                */
/*                                                            */
/*    Returns: _PASS/_FAIL status indication:                 */
/*          _PASS - Command successfuly interpreted, and will */
/*                 be executed.                               */
/*          _FAIL - Illegal command, command not executed.    */
/*                 Cause may be illegal control command       */
/*                 opcode, destination, or parameter.         */
/*                                                            */
/*    Input Variables:                                        */
/*        BP_U_8BIT no - which bit_pump                       */
/*        BP_U_8BIT opcode                                    */
/*        BP_U_8BIT parameter                                 */
/*                                                            */
/*    Output Variables:                                       */
/*        BP_U_8BIT status                                    */
/*                                                            */
/*    Example:                                                */
/*    status = _BtControl(_BIT_PUMP0, _TERMINAL_TYPE, _HTUR)  */
/*                                                            */
/* Programmer:                                                */
/*     Dean Rasmussen             27-Aug-1998                 */
/*                                                            */
/* Revision History:                                          */
/*                                                            */
/**************************************************************/
BP_U_8BIT _BtControl (BP_U_8BIT no, BP_U_8BIT opcode, BP_U_8BIT parameter)
{
    if ( no < _NO_OF_LOOPS )
        {
        /* _BitpumpControl() is in \bitpump\api.c */
        return _BitpumpControl(no, opcode, parameter);
        }
#ifdef CHAN_UNIT
    else if ( no >= _CU_COMMON && no <= _CU_CHAN3 )
        {
        /* _CuControl() is in \chanunit\cu_api.c */
        return _CuControl(no, opcode, parameter);
        }
    else if ( no >= _DSL_APPLICATION && no <= _DSL_CHANNEL2 )
        {
        /* _DslControl() is in dsl_api.c */
        return _DslControl(no, opcode, parameter);
        }
#endif /* CHAN_UNIT */
#ifdef T1E1_FRAMER
    else if ( no == _FRAMER )
        {
        /* _FramerControl() is in \chanunit\framer_api.c */
        return _FramerControl(no, opcode, parameter);
        }
#endif   /* T1E1_FRAMER */

    return _FAIL;   /* invalid destination */
}


/**************************************************************/
/*    _BtStatus()                                             */
/*    Execute status command.                                 */
/*                                                            */
/*    Returns: _PASS/_FAIL status indication:                 */
/*          _PASS - Command successfuly interpreted, and will */
/*                 be executed.                               */
/*          _FAIL - Illegal command, command not executed.    */
/*                 Cause may be illegal control command       */
/*                 opcode, destination, or parameter.         */
/*                                                            */
/*    Input Variables:                                        */
/*        BP_U_8BIT no - which bit_pump                       */
/*        BP_U_8BIT opcode                                    */
/*        BP_U_8BIT parameter                                 */
/*                                                            */
/*    Output Variables:                                       */
/*        BP_U_8BIT status                                    */
/*        BP_S_8BIT *indication                               */
/*                                                            */
/*    Example:                                                */
/*    status = _BtStatus(_BIT_PUMP0, _CONFIGURATION,          */
/*                       _BIT_RATE, &indication);             */
/*                                                            */
/* Programmer:                                                */
/*     Dean Rasmussen             27-Aug-1998                 */
/*                                                            */
/* Revision History:                                          */
/*                                                            */
/**************************************************************/
BP_U_8BIT _BtStatus (BP_U_8BIT no, BP_U_8BIT opcode, BP_U_8BIT parameter, BP_S_8BIT *indication)
{
    if ( no < _NO_OF_LOOPS )
        {
        /* _BitpumpStatus() is in \bitpump\api.c */
        return _BitpumpStatus(no, opcode, parameter, indication);
        }

#ifdef CHAN_UNIT
    else if ( no >= _CU_COMMON && no <= _CU_CHAN3 )
        {
        /* _CuStatus() is in \chanunit\cu_api.c */
        return _CuStatus(no, opcode, parameter, indication);
        }
    else if ( no >= _DSL_APPLICATION && no <= _DSL_CHANNEL2 )
        {
        /* _DslStatus() is in dsl_api.c */
        return _DslStatus(no, opcode, parameter, indication);
        }
#endif /* CHAN_UNIT */
#ifdef T1E1_FRAMER
    else if ( no == _FRAMER )
        {
        /* _FramerStatus() is in \chanunit\framer_api.c */
        return _FramerStatus(no, opcode, parameter, indication);
        }
#endif


    return _FAIL;   /* invalid destination */
}
