/**************************************************************/
/*    UTIL.H                                                  */
/*    (C) Copyright 1993 by Rockwell Corporation              */
/*                                                            */
/*    This program is copyrighted by Rockwell Corporation     */
/*                                                            */
/* Description:                                               */
/*    This file includes several utility macros:              */
/*    NORM(meter) - Calculate meters normalization constant   */
/*    according to meter timer value.                         */
/*    ADD_DELAY - Define one symbol delay for slow processor  */
/*    or slow Bitpump clock applications.                     */
/*                                                            */
/* Notes:                                                     */
/*                                                            */
/* User Modifiable Code:                                      */
/*    None                                                    */
/*                                                            */
/* List of H files included in this module:                   */
/*                                                            */
/* Programmer:                                                */
/*     Iris Shuker                21-Oct-1993                 */
/*                                                            */
/* Revision History:                                          */
/*                                                            */
/**************************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

#define INIT_STATUS_REG             0x03     /* Set LOS & LOST */

#define TABLE_LENGTH                64
#define _FELM_NUM_DATA_RATES        8

#define T_LOSS_DEFAULT_VALUE        10


/*---------------------------------------------------------*/
/*  Global Extern Variables                                */
/*---------------------------------------------------------*/

extern BP_TABLE BP_CONSTANT _far_end_signal[_FELM_NUM_DATA_RATES][TABLE_LENGTH];


/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

/* Assumes timer is enabled & unmasked */
#define RESTART(ptr, timer)  \
    int_ptr -> bits.timer_source.timer = OFF;\
    BP_WRITE_BIT(ptr, timer_source, timer, OFF);\
    BP_WRITE_BIT(ptr, timer_restart, timer, ON);


#define NORM(x) x = _NormlizeMeter(no); 

/* 
 * READ_METER_REG
 *
 * Must pass in 'meter_low/high' (i.e. slm_low), 'value' (return value)
 * and 'meter' (must be NORMalized first, or 0)
 *
 * Disables interrupts
 */
#define READ_METER_REG(meter_low, meter_high, value, meter) \
{   BP_S_8BIT low;\
    _DisableBitpumpInterrupt();\
    low = BP_READ_REG(bp_ptr, meter_low);\
    value = (BYTE2WORD(BP_READ_REG(bp_ptr, meter_high), low)) << meter;\
    _EnableBitpumpInterrupt();\
}


/*
 * compensate for SymRate/4096 vs SymRate/4000 ratio (4096/4000 = 1.024)
 * sym_rate - (1/64)sym_rate - (1/128)sym_rate = (1/1.024) * sym_rate
 */
#define COMP_SYM_RATE()   (_bp_vars[no].symbol_rate-(_bp_vars[no].symbol_rate>>6)-(_bp_vars[no].symbol_rate>>7))


#ifndef INT_BUG
#define INIT_TIMER(timer, virtual_timer, low_reg, high_reg, symbols)\
    SET_WORD(bp_ptr, low_reg, high_reg, symbols); /* Set timer interval */ \
    RESTART(bp_mode_ptr, timer); 
#else
#define INIT_TIMER(timer, virtual_timer, low_reg, high_reg, symbols)\
    SET_WORD(bp_ptr, low_reg, high_reg, symbols); /* Set timer interval */ \
    RESTART(bp_mode_ptr, timer); \
    _RestartVirtualTimer(no, virtual_timer, symbols); 
#endif


#define TIMER_BREAK(timer) \
    if (!(int_ptr -> bits.timer_source.timer)) /* Wait for timer3 */ \
        break; \
    int_ptr -> bits.timer_source.timer = OFF; /* Clear timer3 interrupt flag */ 


#define WAIT_FOR_TIMER(timer) \
    while (!(int_ptr -> bits.timer_source.timer)); /* Wait for timer3 */ \
    int_ptr -> bits.timer_source.timer = OFF; /* Clear timer3 interrupt flag */ 

#if 0
#define INIT_TX_GAIN \
   /* If the device is a Bt8970-12 and it has not been calibrated by the factory */ \
   if ((GET_BITPUMP_TYPE()==BT8970) && (BP_READ_BIT(bp_mode_ptr, global_modes, hw_revision)==0x02) \
        && (!BP_READ_BIT(bp_mode_ptr, tx_calibrate, tx_gain))) { \
      /* Set the tx_gain to a value of 0x03. This value is based on test data. */ \
      BP_WRITE_BIT(bp_mode_ptr, tx_gain, tx_gain, 0x03); \
      /* Modification of band_gap value.  First set the band_gap value. The value is 0x02 for all Bt8970 devices */ \
      BP_WRITE_BIT(bp_mode_ptr, tx_gain, band_gap_high, 0x00); \
      BP_WRITE_BIT(bp_mode_ptr, tx_gain, band_gap_low,  0x02); \
      /* Second, change the default value of band_gap_test_mode to 1.  This bit controls  */ \
      /* which register sets the band_gap (if 1, then tx_gain, else tx_calibrate) */ \
      BP_WRITE_BIT(bp_mode_ptr, misc_test, band_gap_test_mode, ON); \
      } else \
      /* Device has been programmed by factory, use tx_gain value stored in tx_calibrate */ \
      BP_WRITE_BIT(bp_mode_ptr, tx_gain, tx_gain, BP_READ_BIT(bp_mode_ptr, tx_calibrate, tx_gain) ); 
#endif /* if 0 */

#define WRITE_REG_35(a,b,c) \
    BP_WRITE_REG(bp_ptr, test_reg35, a);\
    BP_WRITE_REG(bp_ptr, test_reg35, b);\
    BP_WRITE_REG(bp_ptr, test_reg35, c);\
    DELAY2SYMBOL;

#define RD_BYTE(no, address, value) value = _RdByte(no, address);

#define WR_BYTE(no, address, value) _WrByte(no, address, value);

#define RD_WORD(no, address, value_low, value_high) \
    _ReadAccessByteRAM(no, EQ_ACCESS_RAM, address);\
    (value_low)  = _bp_vars[no].access_data_byte[0];\
    (value_high) = _bp_vars[no].access_data_byte[1];

#define WR_WORD(no, address, low_value, high_value) _WrWord(no, address, low_value, high_value)


/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

void _BtReset(BP_U_8BIT no);
void _BtInitialize(BP_U_8BIT no);
void _BitpumpSetSymbolRate(BP_U_8BIT no, BP_U_16BIT symbol_rate);
void _DcCancel(BP_U_8BIT no);
void _BtLoadMicroCode(BP_U_8BIT no);
BP_S_8BIT _LookUpTable(BP_TABLE *table_ptr, BP_S_16BIT value);
void _SetMeterTimer(BP_U_8BIT no, BP_U_8BIT value);
void _SetFelmMask(BP_U_8BIT no);
BP_U_8BIT _NormlizeMeter(BP_U_8BIT no);
BP_S_8BIT _RdByte(BP_U_8BIT no, BP_U_8BIT address);
void _WrByte(BP_U_8BIT no, BP_U_8BIT address, BP_S_8BIT value);
void _WrWord(BP_U_8BIT no,BP_U_8BIT address,BP_S_8BIT low_value,BP_S_8BIT high_value);
BP_S_8BIT _ReadNmr(BP_U_8BIT no);
BP_S_16BIT _ScaleByGain(BP_U_8BIT no, BP_S_16BIT value);
void _ReadAccessByteRAM(BP_U_8BIT no,BP_U_8BIT ram,BP_U_8BIT address);
void _WriteAccessByteRAM(BP_U_8BIT no,BP_U_8BIT ram,BP_U_8BIT address);
void _WrScratchPad(BP_U_8BIT no, BP_U_8BIT index, BP_S_16BIT value);
void _InitTxGain(BP_U_8BIT no);
BP_S_16BIT _RdScratchPad(BP_U_8BIT no, BP_U_8BIT index);



