/***********************************************************/
/*    USER.H                                               */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*     None.                                               */
/*                                                         */
/* List of H files included in this module:                */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                08-Sept-1993             */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/


#ifdef BP_MASK_INTERRUPTS
#define _DisableBitpumpInterrupt() \
    _bp_vars[no].temp_mask_low_reg = BP_READ_REG(bp_ptr, mask_low_reg);\
    _bp_vars[no].temp_mask_high_reg = BP_READ_REG(bp_ptr, mask_high_reg);\
    BP_WRITE_REG(bp_ptr, mask_low_reg, 0xFF);\
    BP_WRITE_REG(bp_ptr, mask_high_reg, 0xFF);\
    _bp_vars[no].bp_flags.bits.interrupt_enabled = 0;

#define _EnableBitpumpInterrupt()   \
    _bp_vars[no].bp_flags.bits.interrupt_enabled = 1;\
    BP_WRITE_REG(bp_ptr, mask_low_reg, _bp_vars[no].temp_mask_low_reg);\
    BP_WRITE_REG(bp_ptr, mask_high_reg, _bp_vars[no].temp_mask_high_reg );
#else

#ifdef C51
#define _DisableBitpumpInterrupt()  EX0 = 0;
#define _EnableBitpumpInterrupt()   EX0 = 1;
#else
    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section user.h.1    Begins       <<<*/
    /*----------------------------------------------------------*/
    /* Modification Description:                                */
    /* Disable/Enable bit-pump interrupt.                       */
    /* Only necessary if BP_MASK_INTERRUPTS is not specified.   */
    /*                                                          */
    /* Reference:                                               */
    /* "Bt8970 Software User's Manual", Section ?.?.1           */
    /*----------------------------------------------------------*/

    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section user.h.1    Ends         <<<*/
    /*----------------------------------------------------------*/

#endif /* else C51 */

#endif /* BP_MASK_INTERRUPTS */

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#define ZIP_START_MODE     _bp_vars[no].bp_flags.bits.zip_startup_mode

#ifdef ADD_DELAY
#define DELAY2SYMBOL _Delay2Symbols(no);
#else
#define DELAY2SYMBOL
#endif


#ifdef TDEBUG
#ifdef PRINTF_NOT_SUPPORTED
int my_printf(char *format, ...);
#define printf  my_printf
#endif /* PRINTF_NOT_SUPPORTED */
#endif


/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

void _BtHomerPointersInit(BP_U_8BIT no);
void _Delay2Symbols(BP_U_8BIT no);
void _EnableUserInterrupts(void);
void _DisableUserInterrupts(void);
void _WaitMicroSecond(BP_U_16BIT delay);
