/************************************************************/
/*    TESTMODE.H                                            */
/*    (C) Copyright 1993 by Rockwell Corporation            */
/*                                                          */
/*    This program is copyrighted by Rockwell Corporation   */
/*                                                          */
/* Description:                                             */
/*                                                          */
/* Notes:                                                   */
/*                                                          */
/* User Modifiable Code:                                    */
/*    None                                                  */
/*                                                          */
/* List of H files included in this module:                 */
/*                                                          */
/* Programmer:                                              */
/*     Iris Shuker                21-Oct-1993               */
/*                                                          */
/* Revision History:                                        */
/*                                                          */
/************************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

/* Test Mode Stages */
#define TEST_MODE_IDLE           0
#define TM_WAIT_METER_INTERVAL1  1
#define TM_WAIT_METER_INTERVAL2  2

/* Analog Loop back stages */
#define TM_ALB_INITIALIZE        10
#define TM_ALB_ACTIVATE          11
#define TM_ALB_ADAPT_EC          12
#define TM_ALB_ADAPT_DAGC        13
#define TM_ALB_OPEN_EYE1         14
#define TM_ALB_OPEN_EYE2         15
#define TM_ALB_OPEN_EYE3         16
#define TM_ALB_OPEN_EYE4         17
#define TM_ALB_OPEN_EYE5         18
#define TM_ALB_TX_4LEVEL         19
                      
/* ERLE stages */
#define TM_ERLE_INIT             30
#define TM_ERLE_DC_CANCEL        31
#define TM_ERLE_ADAPT_EC1        32
#define TM_ERLE_ADAPT_EC2        33
#define TM_ERLE_ADAPT_EC3        34
#define TM_ERLE_BYPASS_NLEC      35
#define TM_ERLE_ADAPT_NLEC1      36
#define TM_ERLE_ADAPT_NLEC2      37
#define TM_ERLE_ADAPT_NLEC3      38
#define TM_ERLE_MEASURE          39
#define TM_AERLE_MEASURE         40

/* Measure AAGC stage */
#define TM_AAGC_INIT             50
#define TM_AAGC_DC_CANCEL        51      
#define TM_AAGC_MEASURE          52   


/* ERLE Results indexes into Scratch Pad RAM */
#define ERLE_SLM_RESULT          0
#define ERLE_FELM_RESULT         1
#define ERLE_SLM2_RESULT         2
#define ERLE_DC_OFFSET_RESULT    3

#define AAGC_SLM_0_RESULT        0
#define AAGC_SLM_3_RESULT        1
#define AAGC_SLM_6_RESULT        2
#define AAGC_SLM_9_RESULT        3
#define AAGC_SLM_12_RESULT       4
#define AAGC_SLM_15_RESULT       5



           



/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

typedef struct
{
    BP_BIT_FIELD transmit_state:1;
    BP_BIT_FIELD symbol_rate:2;
    BP_BIT_FIELD again:3;
    BP_BIT_FIELD transmit_level:1;
    BP_BIT_FIELD nl_ec:1;
}ERLE_MODE_BITS;

typedef union{
    BP_U_8BIT erle;
    ERLE_MODE_BITS bits;
}ERLE_MODE;

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

BP_U_8BIT _TestMode(BP_U_8BIT no, BP_U_8BIT mode);
BP_U_8BIT _SelfTest(BP_U_8BIT no);
void _HandleTestMode(BP_U_8BIT no);

