/************************************************************/
/*    SUUTIL.H                                              */
/*    (C) Copyright 1993 by Rockwell Corporation            */
/*                                                          */
/*    This program is copyrighted by Rockwell Corporation   */
/*                                                          */
/* Description:                                             */
/*    Open Eye macros and constants.                        */
/*                                                          */
/* Notes:                                                   */
/*                                                          */
/* User Modifiable Code:                                    */
/*    None                                                  */
/*                                                          */
/* List of H files included in this module:                 */
/*                                                          */
/* Programmer:                                              */
/*     Iris Shuker                21-Oct-1993               */
/*                                                          */
/* Revision History:                                        */
/*                                                          */
/************************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

#define NO_OF_OPENED_PHASES            5

#define HIGH_FELM_ALARM_TH             4
#define LOW_FELM_ALARM_TH              2

#define MAX_PLL_VALUE                 (BP_S_16BIT)32760

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/


#define INIT_DAGC                   _InitDagc(no);
#define INIT_DFE                    _InitDfe(no);
#define INIT_FFE                    _InitFfe(no);
#define INIT_DETECTOR               _InitDetector(no);
#define ADAPT_DAGC_EQ_ERROR_MODE    _AdaptDagcEqErrorMode(no);
#define ADAPT_ALL_FFE               _AdaptAllFfe(no);
#define ADAPT_DFE                   _AdaptDfe(no);
#define FREEZE_DFE_FFE              _FreezeDfeFfe(no);
#ifdef HTUC
#define SCALE_DAGC_FFE()            _ScaleDagcFfe(no);
#endif
#ifdef HTUR
#define SCALE_FFE_125()             _ScaleFfe125(no);
#endif

#define AAGC(gain) _Aagc(no, gain);


#define WR_PHASE_QUALITY(index, value) _WrScratchPad(no, index, value);
#define RD_PHASE_QUALITY(index, value) value = (BP_U_16BIT)_RdScratchPad(no, index);

#define WR_NOISE_QUALITY(index, value) _WrScratchPad(no, (BP_U_8BIT)(index+(BP_U_8BIT)16), value);
#define RD_NOISE_QUALITY(index, value) value = (BP_U_16BIT)_RdScratchPad(no, (BP_U_8BIT)(index+(BP_U_8BIT)16));

#define WR_ERLE_RESULTS(index, value) _WrScratchPad(no, index, value);
#define RD_ERLE_RESULTS(index, value) value = _RdScratchPad(no, index);

#define RD_FFE_COEFF(no, index) _RdScratchPad(no, index);
#define WR_FFE_COEFF(no, index, low_value, high_value) _WrScratchPad(no, index, BYTE2WORD(high_value, low_value));

#ifdef TDEBUG
#define PRINTF_DAGC(no)      _PrintfDAGC(no)
#define PRINTF_FFE_COEFS(no) _PrintfFFECoefs(no)
#define PRINTF_DFE_COEFS(no) _PrintfDFECoefs(no)
#endif

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

void _AdaptEc(BP_U_8BIT no, BP_U_8BIT gain, BP_U_16BIT no_symbols);
void _OpenEyeLastFfe(BP_U_8BIT no);
BP_U_8BIT _IsEyeOpen(BP_U_8BIT no);
BP_U_8BIT _IsFirstEyeOpen(BP_U_8BIT no);
BP_U_8BIT _IsPhaseLocked(BP_U_8BIT no);
BP_U_8BIT _IsSignalLow(BP_U_8BIT no);
void _CalculateOptimalPhase1(BP_U_8BIT no);
void _CalculateOptimalPhase2(BP_U_8BIT no);
void _CalculateOptimalPhase3(BP_U_8BIT no);
void _CalculateOptimalPhase4(BP_U_8BIT no);
BP_U_8BIT _CalculateOptimalPhase(BP_U_8BIT no);
void _FfeReverse(BP_U_8BIT no);
void _ShiftFfe(BP_U_8BIT no);
BP_S_16BIT _CalculatePhaseQuality(BP_U_8BIT no);
BP_U_8BIT _ReOpenOptimalPhase(BP_U_8BIT no);
void _InitDagc(BP_U_8BIT no);
void _InitDfe(BP_U_8BIT no);
void _InitFfe(BP_U_8BIT no);
void _InitDetector(BP_U_8BIT no);
void _AdaptDagcSelfMode(BP_U_8BIT no);
void _AdaptDagcEqErrorMode(BP_U_8BIT no);
void _AdaptAllFfe(BP_U_8BIT no);
void _AdaptDfe(BP_U_8BIT no);
void _FreezeDfeFfe(BP_U_8BIT no);
void _Aagc(BP_U_8BIT no, BP_U_8BIT gain);
void _SetLosThreshold(BP_U_8BIT no);
void _Aagc6Level(BP_U_8BIT no);
void _SetActivationInterval(BP_U_8BIT no);
void _SetAdcControlAgain(BP_U_8BIT no, BP_U_8BIT gain);
BP_U_8BIT _GetAdcControlAgain(BP_U_8BIT no);
void _SetFfeScale(BP_U_8BIT no);
#ifdef HTUC
void _ScaleDagcFfe(BP_U_8BIT no);
#endif
#ifdef HTUR
void _ScaleFfe125(BP_U_8BIT no);
#endif

BP_U_8BIT _CheckAagc(BP_U_8BIT no);   

#ifdef TDEBUG
void _PrintfLECCoefs(BP_U_8BIT no);
void _PrintfDAGC(BP_U_8BIT no);
void _PrintfFFECoefs(BP_U_8BIT no);
void _PrintfDFECoefs(BP_U_8BIT no);
void _PrintfEPCoefs(BP_U_8BIT no);
#endif
