/*************************************************************/
/*    SUC.H                                                  */
/*    (C) Copyright 1993 by Rockwell Corporation             */
/*                                                           */
/*    This program is copyrighted by Rockwell Corporation    */
/*                                                           */
/* Description:                                              */
/*    Startup macros and constants.                          */
/*                                                           */
/* Notes:                                                    */
/*                                                           */
/* User Modifiable Code:                                     */
/*    None                                                   */
/*                                                           */
/* List of H files included in this module:                  */
/*                                                           */
/* Programmer:                                               */
/*     Iris Shuker                26-Sept-1993               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

#define ON  1
#define OFF 0

/*  HTU_C & HTU_R operational stages */
#define IDLE                           0
#define ACTIVATE_SYSTEM                1
#define DC_CANCELLATION                2
#define INIT_STARTUP                   3
#define ADAPT_EC_STAGE1                4
#define ADAPT_EC_STAGE2                5
#define ADAPT_EC_STAGE3                6
#define WAIT_FOR_SIGNAL                7
#define AAGC1                          8
#define AAGC2                          9
#define AAGC3                         10
#define ADAPT_EC_AFTER_AAGC1          11
#define ADAPT_EC_AFTER_AAGC2          12
#define ADAPT_EC_AFTER_AAGC3          13
#define ADAPT_EC_AFTER_AAGC4          14
#define REMOTE_PHASE_LOCK             15
#define SPARE1                        16
#define SPARE2                        17
#define WAIT_FOR_REMOTE_PHASE_LOCK    18
#define START_OPEN_EYE                19
#define PHASE_ADAPT_EC1               20
#define PHASE_ADAPT_EC2               21
#define PHASE_ADAPT_EC3               22
#define PHASE_ADAPT_EC4               23
#define OPEN_EYE1                     24
#define OPEN_EYE2                     25
#define OPEN_EYE3                     26
#define OPEN_EYE4                     27
#define OPEN_EYE5                     28
#define OPEN_EYE6                     29
#define OPEN_EYE7                     30
#define SPARE3                        31

/* 
 * Added in Bt8960/70/73 V4.0 
 * CALC_OPT_PHASEn only used by HTU-C
 * ACQUIRE_FREQn only used by HTU-R
 * therefore can share stage #
 */
#define CALC_OPT_PHASE2               32
#define CALC_OPT_PHASE3               33
#define CALC_OPT_PHASE4               34
#define CALC_OPT_PHASE                35

#define ACQUIRE_FREQ1                 32
#define ACQUIRE_FREQ2                 33
#define ACQUIRE_FREQ3                 34
#define ACQUIRE_FREQ4                 35

#define ACQUIRE_FREQ5                 36
#define PHASE_LOCKED                  37
#define OPTIMAL_PHASE                 38
#define TRANSMIT_2LEVEL               39
#define ADAPT_EC1                     40
#define ADAPT_EC2                     41
#define ADAPT_EC3                     42
#define OPEN_EYE_AT_OPTIMAL_PHASE1    43
#define OPEN_EYE_AT_OPTIMAL_PHASE2    44
#define OPEN_EYE_AT_OPTIMAL_PHASE3    45
#define OPEN_EYE_AT_OPTIMAL_PHASE4    46
#define OPEN_EYE_AT_OPTIMAL_PHASE5    47
#define ADAPT_DAGC_AFTER_AAGC         48
#define ADAPT_EQ1                     49
#define ADAPT_EQ2                     50
#define ADAPT_EQ3                     51
#define WAIT_FOR_T1MIN                52
#define TRANSMIT_4LEVEL               53
#define WAIT_FOR_4LEVEL               54
#define ADAPT_MODULES1                55
#define ADAPT_MODULES2                56
#define SET_NORMAL_CONDITIONS         57
#define NORMAL_OPERATION              58
#define DEACTIVATE_MODE               60
#define OPEN_EYE_AT_OPTIMAL_PHASE6    61
#define OPEN_EYE_AT_OPTIMAL_PHASE7    62
#define OPEN_EYE_AT_OPTIMAL_PHASE8    63
#define OPEN_EYE_AT_OPTIMAL_PHASE9    64
#define OPEN_EYE_AT_OPTIMAL_PHASE10   65
#define OPEN_EYE_AT_OPTIMAL_PHASE11   66
#define OPEN_EYE_AT_OPTIMAL_PHASE12   67
#define OPEN_EYE_AT_OPTIMAL_PHASE13   68
#define OPEN_EYE_AT_OPTIMAL_PHASE14   69
#define WAIT_FOR_4LEVEL_2             70

/* Added in Bt8970 V3.0 */
#define WAIT_FOR_4LEVEL3              71
#define ADJUST_FELM_HIGH_TH           72
#define GOTO_WAIT_FOR_SIGNAL          73
#define START_OPEN_EYE2               74
#define SET_LOS_THRESHOLD             75
#define SU_WAIT_METER_INTERVAL1       76
#define SU_WAIT_METER_INTERVAL2       77

#ifdef ZIP_START
#define WS_OPTIMAL_PHASE              78
#endif


/* Initialization Values */
#define AGC_TARGET_INIT_VALUE         0
#define DAGC_TARGET_INIT_VALUE        1000      /* 1000 for 2-level. 4-level: 424 */

/* Threshold constants */
#define FOUR_LEVEL_SIGNAL_TH           4    /* 2^(-8) * FOUR_LEVEL_METER/2  */
#define TIP_RING_TH                   (BP_U_16BIT)1000  /* Assuming Meter Interval = 2048 */
#define SIGNAL_LEVEL_TH               (BP_U_16BIT)5300  /* normalized */

/* Gain mode constants */
#define HIGHEST_GAIN 3
#define HIGHER_GAIN  2
#define HIGH_GAIN    1
#define NORMAL_GAIN  0

/* Analog Gain Constants */
#define AGAIN15DB 0x5
#define AGAIN12DB 0x4
#define AGAIN9DB  0x3
#define AGAIN6DB  0x2
#define AGAIN3DB  0x1
#define AGAIN0DB  0x0

#ifdef AAGC15BUG
#define MAX_AGAIN   (BP_U_8BIT)AGAIN12DB
#else
#define MAX_AGAIN   (BP_U_8BIT)AGAIN15DB
#endif

/* Transmitter Mode Source */
#define ISOLATED_PULSE               0x0
#define DETECTOR_LOOPBACK            0x1
#define UNSCRAMBLED_FOUR_LEVEL_DATA  0x2
#define SCRAMBLED_FOUR_LEVEL_ONES    0x3
#define ALTERNATING_SYMBOL           0x4
#define SCRAMBLED_FOUR_LEVEL_DATA    0x5
#define UNSCRAMBLED_TWO_LEVEL_DATA   0x6
#define SCRAMBLED_TWO_LEVEL_ONES     0x7

#define SELECT_DETECTOR_OUTPUT         0x0
#define SELECT_TRANSMITTER_INPUT     0x1
#define SELECT_DESCRAMBLER_OUTPUT    0x2

/* Startup time intervals */
#define DEFAULT_METER_VALUE         1024
#define DEFAULT_METER                  0        /* 1k  symbols */
#define PHASE_LOCK_METER               0        /* 1k  symbols */
#define FOUR_LEVEL_METER               1        /* 2k  symbols */
#define ALT_METER                      3        /* 8k  symbols */
#define NORMAL_METER                   5        /* 32k symbols */
#define PHASE_QUALITY_METER            2        /* 4k  symbols */

#define SNR_TIMER_INTERVAL           256

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#ifdef TDEBUG
#define PREFIX \
printf("%d: ", (int)(no+1))
#endif

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

void _HtucControlProcess(BP_U_8BIT no);
