/***********************************************************/
/*    SERINT.C                                             */
/*    Serial communication interrupt handler.              */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*    Handle serial port interrupts.                       */
/*                                                         */
/* Notes:                                                  */
/*    All file is conditionally compiled on SER_COM        */
/*    definition.                                          */
/*                                                         */
/* User Modifiable Code:                                   */
/*    None                                                 */
/*                                                         */
/* List of functions included in this module:              */
/*  Serial()                                               */
/*                                                         */
/* Programmer:                                             */
/*     Dean Rasmussen             March - 1998             */
/*     Iris Shuker                21-Oct-1993              */
/*                                                         */
/* Revision History:                                       */
/*     date/name of reviser                                */
/*                                                         */
/***********************************************************/

#ifdef SER_COM

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

#include "bthomer.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Variables                                       */
/*---------------------------------------------------------*/

extern BP_U_8BIT BP_MSPACE  _message_buffer[4]; /* Message buffer 4 bytes length, 1 message deep */

/*---------------------------------------------------------*/
/*  Static Variables                                       */
/*---------------------------------------------------------*/

static BP_U_8BIT BP_MSPACE counter = RESET; /* Byte counter at message buffer */

/*---------------------------------------------------------*/
/*  Interrupt Handler                                      */
/*---------------------------------------------------------*/

/* Int vector at 0023H */
Serial() interrupt 4
{
    BP_U_8BIT temp;

    if (TI) /* Transmit interrupt flag ON */
        {
        TI = OFF;
        bp_mail_flags.tx_flag = ON;
        return;
        } /* Transmit flag ON */

    /*-----------------------------------------------------------------*/
    /* On transmit interrupt: set transmission flag.                   */
    /* On receive interrupt: get received byte. If message buffer is   */
    /* not full - put byte in message buffer.                          */
    /* If this is the first byte in a message - store byte only if     */
    /* header bits are correct.                                        */
    /* If this is the last byte in a message - verify correct checksum */
    /* and if OK - set message flag.                                  */
    /*-----------------------------------------------------------------*/

    if (RI) /* Receive interrupt flag ON*/
        {

        temp = SBUF;
        /* If message flag OFF, message buffer is not full. Write received byte to next location in message buffer, check message header and message checksum. */
        if (!bp_mail_flags.message_flag) /* Message buffer is not full */
            {
            /* If the received byte is the first byte of a message, check the header bits. Write byte to message buffer, increment message buffer counter. */
            if (counter == 0) /* First byte of a message */
                {
                    if (HEADER_BITS(temp)) /* Check message header bits, for first byte of message identification */
                        _message_buffer[counter++] = temp; /* Write received byte to message buffer */
                } /* END-IF First byte of a message */
            else
                _message_buffer[counter++] = temp; /* Write received byte to message buffer */
            /* If the message buffer is full check the checksum of the message if OK, set message flag ON. */
            if (counter == 4) /* Message buffer is full */
                {
                    counter = RESET; /* Reset message buffer counter */
                    if (CHECKSUM(_message_buffer[0], _message_buffer[1], _message_buffer[2]) == _message_buffer[3]) /* Message checksum is OK */
                        bp_mail_flags.message_flag = ON; /* Set message flag, points full message at message buffer ON */
                } /* END-IF nessage buffer is full */
            } /* END-IF message buffer is not full */
        RI = OFF; /* Set receive interrupt flag OFF */
        } /* END-IF receive interrupt flag ON */

} /* END serial () */

#endif
