/************************************************************/
/*    PTRDEF.H                                              */
/*    (C) Copyright 1993 by Rockwell Corporation            */
/*                                                          */
/*    This program is copyrighted by Rockwell Corporation   */
/*                                                          */
/* Description:                                             */
/*    Pointers defenitions                                  */
/*                                                          */
/* Notes:                                                   */
/*                                                          */
/* User Modifiable Code:                                    */
/*    None                                                  */
/*                                                          */
/* List of H files included in this module:                 */
/*                                                          */
/* Programer:                                               */
/*     Iris Shuker                21-Oct-1993               */
/*                                                          */
/* Revision History:                                        */
/*                                                          */
/************************************************************/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#ifdef C51
#ifdef PDATA_MODE
#define DECLARE_PTR_ARRAY transceiver BP_VOLATILE BP_PDATA * BP_MSPACE _bit_pump[_NO_OF_LOOPS]
#endif
#ifdef XDATA_MODE
#define DECLARE_PTR_ARRAY transceiver BP_VOLATILE BP_XDATA * BP_MSPACE _bit_pump[_NO_OF_LOOPS]
#endif
#else
#define DECLARE_PTR_ARRAY transceiver BP_VOLATILE * BP_MSPACE _bit_pump[_NO_OF_LOOPS]
#endif

#ifdef C51
#ifdef PDATA_MODE
#define DECLARE_PTR transceiver BP_VOLATILE BP_PDATA *bp_ptr
#endif
#ifdef XDATA_MODE
#define DECLARE_PTR transceiver BP_VOLATILE BP_XDATA *bp_ptr
#endif
#else
#define DECLARE_PTR transceiver BP_VOLATILE *bp_ptr
#endif

#ifdef C51
#ifdef PDATA_MODE
#define DECLARE_MODE_PTR transceiver_modes BP_VOLATILE BP_PDATA *bp_mode_ptr
#endif
#ifdef XDATA_MODE
#define DECLARE_MODE_PTR transceiver_modes BP_VOLATILE BP_XDATA *bp_mode_ptr
#endif
#else
#define DECLARE_MODE_PTR transceiver_modes BP_VOLATILE *bp_mode_ptr
#endif

#ifdef C51
#define DECLARE_INT_PTR interrupt_reg BP_VOLATILE BP_MSPACE *int_ptr
#else
#define DECLARE_INT_PTR interrupt_reg BP_VOLATILE *int_ptr
#endif

#ifdef C51
#define DECLARE_INT_REG interrupt_reg BP_VOLATILE BP_MSPACE _int_reg[_NO_OF_LOOPS]
#else
#define DECLARE_INT_REG interrupt_reg BP_VOLATILE _int_reg[_NO_OF_LOOPS]
#endif

#ifdef PDATA_MODE
#define INIT_BP_PTR \
    _p2_value = (BP_U_8BIT)_bit_pump[no]; \
    P2 = _p2_value; \
    bp_ptr = 0x0
#else
#define INIT_BP_PTR  bp_ptr = _bit_pump[no]
#endif

#ifdef PDATA_MODE
#define INIT_BP_MODE_PTR \
    _p2_value = (BP_U_8BIT)_bit_pump[no]; \
    P2 = _p2_value; \
    bp_mode_ptr = 0x0
#else
#define INIT_BP_MODE_PTR  bp_mode_ptr = (transceiver_modes *) _bit_pump[no]
#endif

#define INIT_INT_PTR int_ptr = &_int_reg[no]


/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/
