/*************************************************************/
/*    MONITOR.C                                              */
/*    Monitoring through RS232 channel.                      */
/*    (C) Copyright 1993 by Rockwell Corporation             */
/*                                                           */
/*    This program is copyrighted by Rockwell Corporation    */
/*                                                           */
/* Description:                                              */
/*                                                           */
/* Notes:                                                    */
/*                                                           */
/* User Modifiable Code:                                     */
/*    None                                                   */
/*                                                           */
/* List of functions included in this module:                */
/*   putchar()                                               */
/*   _getkey()                                               */
/*   keypress()                                              */
/*                                                           */
/* Programmer:                                               */
/*     Dean Rasmussen             March - 1998               */
/*     Iris Shuker                26-Sept-1993               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#include "..\typedefs.h"

#ifdef C51
#ifdef TDEBUG

#include <reg51.h>

char putchar (char c)
{

    if (c == '\n')
        {
        SBUF = 0x0d;                         /* output CR  */
        while (!TI);
        TI = 0;
        }
    SBUF = c;
    while (!TI);
    TI = 0;
    return (c);

}

#if 0
char _getkey ()
{
    char c;

    while (!RI);
    c = SBUF;
    RI = 0;
    return (c);

}
#endif /* Not Used */

#ifdef DEBUG_MENU
char keypress (char *c)
{

    if (RI)
        {
        *c=SBUF;
        RI=0;
        return(1);
        }
    else
        return(0);

}
#endif

#endif /* TDEBUG */
#endif /* C51 */
