/***********************************************************/
/*    MAIL.H                                               */
/*    (C) Copyright 1993 by Brooktree Corporation          */
/*                                                         */
/*    This program is copyrighted by Brooktree Corporation */
/*                                                         */
/* Description:                                            */
/*    RS232 macros                                         */
/*                                                         */
/* Notes:                                                  */
/*    SER_COM define dependent: ALL FILE                   */
/*                                                         */
/* User Modifiable Code:                                   */
/*    None                                                 */
/*                                                         */
/* List of H files included in this module:                */
/*                                                         */
/* Programer:                                              */
/*     Iris Shuker                30-August-1993           */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

#ifdef SER_COM

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

#define INFO_REQUEST(x) (((x) & 0x80) == 0x80)
#define DEST(x) ((x) & 0x0F)

/*---------------------------------------------------------*/
/*  TYPEDEF Defines                                        */
/*---------------------------------------------------------*/

typedef struct
{
    BP_BIT_FIELD ffh:1;             /* full flag */
    BP_BIT_FIELD efh:1;             /* empty flag */
    BP_BIT_FIELD tx_flag:1;
    BP_BIT_FIELD message_flag:1;
    BP_BIT_FIELD reserved:4;
} BP_MAIL_FLAGS;

extern BP_MAIL_FLAGS BP_MSPACE bp_mail_flags;

/*---------------------------------------------------------*/
/*  Exported Functions                                     */
/*---------------------------------------------------------*/

void _InitHostMailBox(void);
void _HandleReceiveMessages(void);
void _HandleTransmitMessages(void);
void _WriteHostMailBox(BP_U_8BIT source, BP_U_8BIT opcode, \
BP_S_8BIT parameter, BP_U_8BIT checksum);

BP_U_8BIT _BtStatus(BP_U_8BIT destination, BP_U_8BIT opcode, BP_U_8BIT parameter, BP_S_8BIT *indication);
BP_U_8BIT _BtControl(BP_U_8BIT destination, BP_U_8BIT opcode, BP_U_8BIT parameter);

#endif  /* SER_COM */
