/***********************************************************/
/*    INTBUG.C                                             */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*    Virtual Timers routines.                             */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*    None                                                 */
/*                                                         */
/* List of C files included in this module:                */
/*                                                         */
/* List of H files included in this module:                */
/* bthomer.h                                               */
/*                                                         */
/*                                                         */
/* Programmer:                                             */
/*     Dean Rasmussen             March - 1998             */
/*     Iris Shuker             07-Jan-1994                 */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

#ifdef INT_BUG

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

#include "bthomer.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

/* T1 rate: F69A (111,1 011,0 100,1 1010), 382.724Hz 1024 symbols freq is 382.8Hz */
/* E1 rate: F9B0 (111,1 100,1 101,1 0000), 570.2974Hz 1024 symbols freq is 570.3125Hz */
#define T1_LOW  0x1A
#define T1_HIGH 0xB4
#define E1_LOW  0x10
#define E1_HIGH 0xCD

#define BT8960_144K_LOW  0x1A
#define BT8960_144K_HIGH 0x33

#define BT8960_208K_LOW  0x1A
#define BT8960_208K_HIGH 0x70

/*---------------------------------------------------------*/
/*  Static Functions                                       */
/*---------------------------------------------------------*/

static void _LoadCounterValues(void);

/*---------------------------------------------------------*/
/*  Global Variables                                       */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Static Variables                                       */
/*---------------------------------------------------------*/

static BP_U_8BIT BP_CONSTANT scales[7] = {0,0,0,0,10,10,10};

static BP_U_16BIT BP_IDATA bp0timers[7];
#ifndef SINGLE_LOOP
static BP_U_16BIT BP_IDATA bp1timers[7];
#ifndef TWO_LOOPS
static BP_U_16BIT BP_IDATA bp2timers[7];
#ifndef THREE_LOOPS
static BP_U_16BIT BP_IDATA bp3timers[7];
#ifndef FOUR_LOOPS
static BP_U_16BIT BP_IDATA bp4timers[7];
static BP_U_16BIT BP_IDATA bp5timers[7];
#endif /* FOUR_LOOPS  */
#endif /* THREE_LOOPS */
#endif /* TWO_LOOPS   */
#endif /* SINGLE_LOOP */

#ifdef C51
#ifdef TDEBUG
sbit ds7 = P1^7;
#endif
#endif

void _ResetTimers(homer_no)
BP_U_8BIT homer_no;
{
    BP_U_8BIT i;

    switch (homer_no)
    {
    case _BIT_PUMP0:
        for (i=0; i<7; i++)
            bp0timers[i] = RESET;
        break;

#ifndef SINGLE_LOOP
    case _BIT_PUMP1:
        for (i=0; i<7; i++)
            bp1timers[i] = RESET;
        break;

#ifndef TWO_LOOPS
    case _BIT_PUMP2:
        for (i=0; i<7; i++)
            bp2timers[i] = RESET;
        break;

#ifndef THREE_LOOPS
    case _BIT_PUMP3:
        for (i=0; i<7; i++)
            bp3timers[i] = RESET;
        break;

#ifndef FOUR_LOOPS
    case _BIT_PUMP4:
        for (i=0; i<7; i++)
            bp4timers[i] = RESET;
        break;
    case _BIT_PUMP5:
        for (i=0; i<7; i++)
            bp5timers[i] = RESET;
        break;
#endif /* FOUR_LOOPS  */
#endif /* THREE_LOOPS */
#endif /* TWO_LOOPS   */
#endif /* SINGLE_LOOP */
    } /* END-SWITCH */

} /* END _ResetTimers() */


void _InitVirtualTimers(void)
{
    BP_U_8BIT i;

    for (i=_BIT_PUMP0; i<_NO_OF_LOOPS; i++)
        _ResetTimers(i);

#ifdef C51
    TMOD = 0x20; /* Timer0 mode0, Timer1 mode2 (baud rate generator */
#endif

    _LoadCounterValues();

#ifdef C51
    ET0 = 1; /* Enable timer0 overflow interrupt */
    EA = 1;  /* Enable all interrupts */
    TR0 = 1; /* Run timer0 */
#endif

} /* END _InitVirtualTimers */


static void _LoadCounterValues (void)
{
#ifdef C51

    if ( _symbol_rate <= 38 )       /* 144k */
        {
        TL0 = BT8960_144K_LOW;
        TH0 = BT8960_144K_HIGH;
        }
    else if ( _symbol_rate <= 55 )  /* 208k */
        {
        TL0 = BT8960_208K_LOW;
        TH0 = BT8960_208K_HIGH;
        }
    else if ( _symbol_rate <= 100 ) /* 392k (T1) */
        {
        TL0 = T1_LOW;
        TH0 = T1_HIGH;
        }
    else                            /* 584k (E1) */
        {
        TL0 = E1_LOW;
        TH0 = E1_HIGH;
        }
#endif

}


void _RestartVirtualTimer(homer_no, timer_no, value)
BP_U_8BIT homer_no, timer_no;
BP_U_16BIT value;
{

#ifdef C51
        ET0 = 0; /* Disable timer0 overflow interrupt */
#endif

        switch (homer_no)
        {
        case _BIT_PUMP0:
            bp0timers[timer_no] = (value >> scales[timer_no]) + 1;
            break;
#ifndef SINGLE_LOOP
        case _BIT_PUMP1:
            bp1timers[timer_no] = (value >> scales[timer_no]) + 1;
            break;
#ifndef TWO_LOOPS
        case _BIT_PUMP2:
            bp2timers[timer_no] = (value >> scales[timer_no]) + 1;
            break;
#ifndef THREE_LOOPS
        case _BIT_PUMP3:
            bp3timers[timer_no] = (value >> scales[timer_no]) + 1;
            break;
#ifndef FOUR_LOOPS
        case _BIT_PUMP4:
            bp4timers[timer_no] = (value >> scales[timer_no]) + 1;
            break;
        case _BIT_PUMP5:
            bp5timers[timer_no] = (value >> scales[timer_no]) + 1;
            break;
#endif /* FOUR_LOOPS  */
#endif /* THREE_LOOPS */
#endif /* TWO_LOOPS   */
#endif /* SINGLE_LOOP */
        } /* END-SWITCH */

#ifdef C51
        ET0 = 1; /* Enable timer0 overflow interrupt */
#endif

} /* END _RestartVirtualTimer() */


void _ResetVirtualTimer(homer_no, timer_no)
BP_U_8BIT homer_no;
BP_U_8BIT timer_no;
{

    switch (homer_no)
        {
        case _BIT_PUMP0:
            bp0timers[timer_no] = RESET;
            break;
#ifndef SINGLE_LOOP
        case _BIT_PUMP1:
            bp1timers[timer_no] = RESET;
            break;
#ifndef TWO_LOOPS
        case _BIT_PUMP2:
            bp2timers[timer_no] = RESET;
            break;
#ifndef THREE_LOOPS
        case _BIT_PUMP3:
            bp3timers[timer_no] = RESET;
            break;
#ifndef FOUR_LOOPS
        case _BIT_PUMP4:
            bp4timers[timer_no] = RESET;
            break;
        case _BIT_PUMP5:
            bp5timers[timer_no] = RESET;
            break;
#endif /* FOUR_LOOPS  */
#endif /* THREE_LOOPS */
#endif /* TWO_LOOPS   */
#endif /* SINGLE_LOOP */
    } /* END-SWITCH */

} /* END _ResetVirtualTimer() */


#ifdef C51
VirtualTimerISR() interrupt 1 /* Timer0 interrupt */
#else
    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section intbug.1   Begins        <<<*/
    /*----------------------------------------------------------*/
    /* Modification Description:                                */
    /*                                                          */
    /* Reference:                                               */
    /* "Bitpump Software User's Manual", Section ?.?.1          */
    /*----------------------------------------------------------*/



    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section intbug.1   Ends          <<<*/
    /*----------------------------------------------------------*/
#endif
{

#ifdef C51
#ifdef TDEBUG
    ds7 = 1;
#endif
#endif

    _LoadCounterValues();

    /* Bitpump#0 */

    /* SUT1 timer */
    switch (bp0timers[_SUT1])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.sut1 = ON;
            bp0timers[_SUT1] = RESET;
            break;
        default:
            bp0timers[_SUT1]--;
        } /* END-SWITCH */

    /* SUT2 timer */
    switch (bp0timers[_SUT2])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.sut2 = ON;
            bp0timers[_SUT2] = RESET;
            break;
        default:
            bp0timers[_SUT2]--;
        } /* END-SWITCH */

    /* SUT3 timer */
    switch (bp0timers[_SUT3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.sut3 = ON;
            bp0timers[_SUT3] = RESET;
            break;
        default:
            bp0timers[_SUT3]--;
        } /* END-SWITCH */

    /* SUT4 timer */
    switch (bp0timers[_SUT4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.sut4 = ON;
            bp0timers[_SUT4] = RESET;
            break;
        default:
            bp0timers[_SUT4]--;
        } /* END-SWITCH */

    /* Meter timer */
    switch (bp0timers[_METER])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.meter = ON;
            bp0timers[_METER] = RESET;
            break;
        default:
            bp0timers[_METER]--;
        } /* END-SWITCH */

    /* T3 timer */
    switch (bp0timers[_T3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.t3 = ON;
            bp0timers[_T3] = RESET;
            break;
        default:
            bp0timers[_T3]--;
        } /* END-SWITCH */

    /* T4 timer */
    switch (bp0timers[_T4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[0].bits.timer_source.t4 = ON;
            bp0timers[_T4] = RESET;
            break;
        default:
            bp0timers[_T4]--;
        } /* END-SWITCH */

#ifndef SINGLE_LOOP
    /* Bitpump#1 */

    /* SUT1 timer */
    switch (bp1timers[_SUT1])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.sut1 = ON;
            bp1timers[_SUT1] = RESET;
            break;
        default:
            bp1timers[_SUT1]--;
        } /* END-SWITCH */

    /* SUT2 timer */
    switch (bp1timers[_SUT2])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.sut2 = ON;
            bp1timers[_SUT2] = RESET;
            break;
        default:
            bp1timers[_SUT2]--;
        } /* END-SWITCH */

    /* SUT3 timer */
    switch (bp1timers[_SUT3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.sut3 = ON;
            bp1timers[_SUT3] = RESET;
            break;
        default:
            bp1timers[_SUT3]--;
        } /* END-SWITCH */

    /* SUT4 timer */
    switch (bp1timers[_SUT4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.sut4 = ON;
            bp1timers[_SUT4] = RESET;
            break;
        default:
            bp1timers[_SUT4]--;
        } /* END-SWITCH */

    /* Meter timer */
    switch (bp1timers[_METER])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.meter = ON;
            bp1timers[_METER] = RESET;
            break;
        default:
            bp1timers[_METER]--;
        } /* END-SWITCH */

    /* T3 timer */
    switch (bp1timers[_T3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.t3 = ON;
            bp1timers[_T3] = RESET;
            break;
        default:
            bp1timers[_T3]--;
        } /* END-SWITCH */

    /* T4 timer */
    switch (bp1timers[_T4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[1].bits.timer_source.t4 = ON;
            bp1timers[_T4] = RESET;
            break;
        default:
            bp1timers[_T4]--;
        } /* END-SWITCH */


#ifndef TWO_LOOPS
    /* Bitpump#2 */

    /* SUT1 timer */
    switch (bp2timers[_SUT1])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.sut1 = ON;
            bp2timers[_SUT1] = RESET;
            break;
        default:
            bp2timers[_SUT1]--;
        } /* END-SWITCH */

    /* SUT2 timer */
    switch (bp2timers[_SUT2])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.sut2 = ON;
            bp2timers[_SUT2] = RESET;
            break;
        default:
            bp2timers[_SUT2]--;
        } /* END-SWITCH */

    /* SUT3 timer */
    switch (bp2timers[_SUT3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.sut3 = ON;
            bp2timers[_SUT3] = RESET;
            break;
        default:
            bp2timers[_SUT3]--;
        } /* END-SWITCH */

    /* SUT4 timer */
    switch (bp2timers[_SUT4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.sut4 = ON;
            bp2timers[_SUT4] = RESET;
            break;
        default:
            bp2timers[_SUT4]--;
        } /* END-SWITCH */

    /* Meter timer */
    switch (bp2timers[_METER])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.meter = ON;
            bp2timers[_METER] = RESET;
            break;
        default:
            bp2timers[_METER]--;
        } /* END-SWITCH */

    /* T3 timer */
    switch (bp2timers[_T3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.t3 = ON;
            bp2timers[_T3] = RESET;
            break;
        default:
            bp2timers[_T3]--;
        } /* END-SWITCH */

    /* T4 timer */
    switch (bp2timers[_T4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[2].bits.timer_source.t4 = ON;
            bp2timers[_T4] = RESET;
            break;
        default:
            bp2timers[_T4]--;
        } /* END-SWITCH */


#ifndef THREE_LOOPS
    /* Bitpump#3 */

    /* SUT1 timer */
    switch (bp3timers[_SUT1])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.sut1 = ON;
            bp3timers[_SUT1] = RESET;
            break;
        default:
            bp3timers[_SUT1]--;
        } /* END-SWITCH */

    /* SUT2 timer */
    switch (bp3timers[_SUT2])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.sut2 = ON;
            bp3timers[_SUT2] = RESET;
            break;
        default:
            bp3timers[_SUT2]--;
        } /* END-SWITCH */

    /* SUT3 timer */
    switch (bp3timers[_SUT3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.sut3 = ON;
            bp3timers[_SUT3] = RESET;
            break;
        default:
            bp3timers[_SUT3]--;
        } /* END-SWITCH */

    /* SUT4 timer */
    switch (bp3timers[_SUT4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.sut4 = ON;
            bp3timers[_SUT4] = RESET;
            break;
        default:
            bp3timers[_SUT4]--;
        } /* END-SWITCH */

    /* Meter timer */
    switch (bp3timers[_METER])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.meter = ON;
            bp3timers[_METER] = RESET;
            break;
        default:
            bp3timers[_METER]--;
        } /* END-SWITCH */

    /* T3 timer */
    switch (bp3timers[_T3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.t3 = ON;
            bp3timers[_T3] = RESET;
            break;
        default:
            bp3timers[_T3]--;
        } /* END-SWITCH */

    /* T4 timer */
    switch (bp3timers[_T4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[3].bits.timer_source.t4 = ON;
            bp3timers[_T4] = RESET;
            break;
        default:
            bp3timers[_T4]--;
        } /* END-SWITCH */


#ifndef FOUR_LOOPS
    /* Bitpump#4 */

    /* SUT1 timer */
    switch (bp4timers[_SUT1])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.sut1 = ON;
            bp4timers[_SUT1] = RESET;
            break;
        default:
            bp4timers[_SUT1]--;
        } /* END-SWITCH */

    /* SUT2 timer */
    switch (bp4timers[_SUT2])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.sut2 = ON;
            bp4timers[_SUT2] = RESET;
            break;
        default:
            bp4timers[_SUT2]--;
        } /* END-SWITCH */

    /* SUT3 timer */
    switch (bp4timers[_SUT3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.sut3 = ON;
            bp4timers[_SUT3] = RESET;
            break;
        default:
            bp4timers[_SUT3]--;
        } /* END-SWITCH */

    /* SUT4 timer */
    switch (bp4timers[_SUT4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.sut4 = ON;
            bp4timers[_SUT4] = RESET;
            break;
        default:
            bp4timers[_SUT4]--;
        } /* END-SWITCH */

    /* Meter timer */
    switch (bp4timers[_METER])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.meter = ON;
            bp4timers[_METER] = RESET;
            break;
        default:
            bp4timers[_METER]--;
        } /* END-SWITCH */

    /* T3 timer */
    switch (bp4timers[_T3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.t3 = ON;
            bp4timers[_T3] = RESET;
            break;
        default:
            bp4timers[_T3]--;
        } /* END-SWITCH */

    /* T4 timer */
    switch (bp4timers[_T4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[4].bits.timer_source.t4 = ON;
            bp4timers[_T4] = RESET;
            break;
        default:
            bp4timers[_T4]--;
        } /* END-SWITCH */

    /* Bitpump#5 */

    /* SUT1 timer */
    switch (bp5timers[_SUT1])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.sut1 = ON;
            bp5timers[_SUT1] = RESET;
            break;
        default:
            bp5timers[_SUT1]--;
        } /* END-SWITCH */

    /* SUT2 timer */
    switch (bp5timers[_SUT2])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.sut2 = ON;
            bp5timers[_SUT2] = RESET;
            break;
        default:
            bp5timers[_SUT2]--;
        } /* END-SWITCH */

    /* SUT3 timer */
    switch (bp5timers[_SUT3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.sut3 = ON;
            bp5timers[_SUT3] = RESET;
            break;
        default:
            bp5timers[_SUT3]--;
        } /* END-SWITCH */

    /* SUT4 timer */
    switch (bp5timers[_SUT4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.sut4 = ON;
            bp5timers[_SUT4] = RESET;
            break;
        default:
            bp5timers[_SUT4]--;
        } /* END-SWITCH */

    /* Meter timer */
    switch (bp5timers[_METER])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.meter = ON;
            bp5timers[_METER] = RESET;
            break;
        default:
            bp5timers[_METER]--;
        } /* END-SWITCH */

    /* T3 timer */
    switch (bp5timers[_T3])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.t3 = ON;
            bp5timers[_T3] = RESET;
            break;
        default:
            bp5timers[_T3]--;
        } /* END-SWITCH */

    /* T4 timer */
    switch (bp5timers[_T4])
        {
        case 0x0:
            break;
        case 0x1:
            _int_reg[5].bits.timer_source.t4 = ON;
            bp5timers[_T4] = RESET;
            break;
        default:
            bp5timers[_T4]--;
        } /* END-SWITCH */
#endif /* FOUR_LOOPS  */
#endif /* THREE_LOOPS */
#endif /* TWO_LOOPS   */
#endif /* SINGLE_LOOP */

#ifdef C51
#ifdef TDEBUG
    ds7 = 0;
#endif
#endif

} /* END VirtualTimerISR() */

#endif
