/***********************************************************/
/*    INIT51.C                                             */
/*    8051 processor initialization.                       */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*    This file contains routines for the intialization    */
/*    of 8051 specific parameters, including:              */
/*    Interrupts, Timers, and Serial Port.                 */
/*                                                         */
/* Notes:                                                  */
/*    Complete file is conditionally compiled only if      */
/*    C51 is defined.                                      */
/*    Only an 8031 based system should use this file.      */
/*    Routines related to serial port are conditionally    */
/*    compiled with SER_COM definition.                    */
/*                                                         */
/* User Modifiable Code:                                   */
/*    None                                                 */
/*                                                         */
/* List of functions included in this module:              */
/*   InitInterrupt()                                       */
/*   InitTimers()                                          */
/*   InitSerialPort()                                      */
/*   _Init8051()                                           */
/*                                                         */
/* Programmer:                                             */
/*     Dean Rasmussen             March - 1998             */
/*     Iris Shuker                31-August-1993           */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

#ifdef C51

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

#include "bthomer.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Static Functions                                       */
/*---------------------------------------------------------*/

void InitInterrupt(void);

#if defined(SER_COM) || defined(TDEBUG)
void InitTimers(void);
void InitSerialPort(void);
#endif


/*---------------------------------------------------------*/
/*  Static Variables                                       */
/*---------------------------------------------------------*/

/***********************************************************/
/*    InitInterrupt()                                      */
/*    Initialization of Interrupt Enable Register and      */
/*    Interrupt Priority Register.                         */
/*                                                         */
/*    Returns: void.                                       */
/*                                                         */
/*    Input Variables: none.                               */
/*                                                         */
/*    Output Variables: none.                              */
/*                                                         */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                31-August-1993           */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

void InitInterrupt (void)
{

#ifdef SER_COM
    ES = 1;         /* Enable serial port interrupt */
#else
#if defined (TDEBUG)
    ES = 0;
#endif
#endif
    PS = 1;         /* Set serial port interrupt to high level priority */

    EX0 = 1;        /* Enable EXT0 interrupt  */
    IT0 = 0;        /* EXT0 leveled interrupt */
    EA = 1;         /* Enable all interrupts  */

}

#if defined(SER_COM) || defined(TDEBUG)

/***********************************************************/
/*    InitTimers()                                         */
/*    8051 internal timers initialization                  */
/*                                                         */
/*    Initialize TMOD register and TCON register.          */
/*    Operate timer1 as baud rate generator.               */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input Variables: None                                */
/*                                                         */
/*    Output Variables: None                               */
/*                                                         */
/*    Notes: Here is a list ot other common baud rates     */
/*           and the programming values. These are for     */
/*           a Intel 8051 family running at 11.0592MHz.    */
/*                                                         */
/*       Baud Rate   TH1 Value   PCON Value                */
/*       ---------   ---------   ----------                */
/*          2400       0xF4      don't change              */
/*          4800       0xFA      don't change              */
/*          9600       0xFD      don't change              */
/*         19200       0xFD         0x80                   */
/*                                                         */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                31-August-1993           */
/*                                                         */
/*                                                         */
/* Revision History:                                       */
/*     Iris Shuker                27-March-1996            */
/*      - Hard coded Baud Rate to 9600 instead of          */
/*        reading dip switch.                              */
/*                                                         */
/***********************************************************/

void InitTimers (void)
{

    TMOD = 0x20; /* Operate timer1 as baud rate generator */
    TL1  = 0x0;
    TH1  = 0xFD; /* Initialize timer1 value */

#ifdef ZIPSOCKET
    PCON = 0x80;
#endif

    TR1  = 1;    /* Activate timer1 */                     
}

/***********************************************************/
/*    InitSerialPort()                                     */
/*    Initialize serial port modes                         */
/*                                                         */
/*    InitSerialPort                                       */
/*    Initialization of SCON Register. Serial              */
/*    communication mode1: start bit, 8 data bits,         */
/*    stop bit.                                            */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input Variables: None                                */
/*                                                         */
/*    Output Variables: None                               */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                31-August-1993           */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

void InitSerialPort (void)
{
    SM0 = 0;                /* Set serial communication mode 1 */
    SM1 = 1;
    SM2 = 1;                /* Validate stop bit */
    REN = 1;                /* enable serial reception */
}

#endif

/***********************************************************/
/*    _Init8051()                                          */
/*    8051 configuration initialization.                   */
/*    Calls initialization routines for Interrupts,        */
/*    internal timers, and serial port parameters.         */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input Variables: None                                */
/*                                                         */
/*    Output Variables: None                               */
/*                                                         */
/* Programmer:                                             */
/*     Iris Shuker                31-August-1993           */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

void _Init8051 (void)
{

    PCON = 0x0;

#if defined(SER_COM) || defined(TDEBUG)
    InitTimers();
    InitSerialPort();
#endif

#ifdef SER_COM
    _InitHostMailBox();
#endif

    InitInterrupt();

} /* END Init8051 */

#endif
