#ifdef FIFO_BRD

/* Bitpump debbuging rutines */

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

#include "bthomer.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

#define FIFO_ADDRESS 0xC000
#define FF_MASKS     0x000F
#define FIFO_FULL    0x0000
#define FIFO_LENGTH    8191

/*---------------------------------------------------------*/
/*  Static Functions                                       */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Variables                                       */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Static Variables                                       */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Constants                                              */
/*---------------------------------------------------------*/

void _SelectSmonSource(no, module)
BP_U_8BIT no;
BP_U_8BIT module;
{
    DECLARE_PTR;

    INIT_BP_PTR;

    BP_WRITE_REG(bp_ptr, serial_monitor_source, module);

} /* END _SelectSmonSource() */

void _ResetFifo(void)
{
    BP_U_8BIT temp;
    fifo_card xdata *data fifo_ptr;


    fifo_ptr = FIFO_ADDRESS;
    temp = fifo_ptr -> arm_fifo;

} /* END _ResetFifo() */

void _TransmitFifo(no)
BP_U_8BIT no;
{

    DECLARE_PTR;

    fifo_card xdata *data fifo_ptr;
    BP_U_16BIT temp;
    BP_S_16BIT value;
    BP_S_8BIT msb, lsb;

    INIT_BP_PTR;

    fifo_ptr = FIFO_ADDRESS;
    while (((fifo_ptr -> fifo_flags) & FF_MASKS) != FIFO_FULL);
    temp = fifo_ptr -> clock_block;

#ifndef TDEBUG
    printf("%c", '$');
#endif TDEBUG

    for (temp=0; temp<FIFO_LENGTH; temp++)
        {
        msb = fifo_ptr -> fifo_msb;
        lsb = fifo_ptr -> fifo_lsb;
        value = BYTE2WORD(msb, lsb);
        printf("%d\n", value);
        } /* END-FOR */

#ifndef TDEBUG
    printf("%c", '@');
#endif TDEBUG

}


#endif
