/************************************************************/
/*    EXTERN.H                                              */
/*    (C) Copyright 1997 by Rockwell Corporation            */
/*                                                          */
/*    This program is copyrighted by Rockwell Corporation   */
/*                                                          */
/* Description:                                             */
/*    Pointers defenitions                                  */
/*                                                          */
/* Notes:                                                   */
/*                                                          */
/* User Modifiable Code:                                    */
/*    None                                                  */
/*                                                          */
/* List of H files included in this module:                 */
/*                                                          */
/* Programer:                                               */
/*     Dean Rasmussen             14-Feb-1997               */
/*                                                          */
/* Revision History:                                        */
/*                                                          */
/************************************************************/

/*---------------------------------------------------------*/
/*  Global Defines Constants                               */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Defines Macros                                  */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Extern Global Variables                                */
/*---------------------------------------------------------*/

#ifdef NO_INDIRECT_RAM_VARS
#define EQ_RAM_BYTE_WIDTH   2
#endif

#ifdef BER_METER
typedef struct
{
      BP_U_16BIT bit_errors;
      BP_U_16BIT meter_intervals;
}BER_METER_STRUCT;
#endif

/* Don't need to be within BIT_REVERSE since only holds local vars */

/* SU_FLAGS_TYPE variable is found in EQ RAM */
typedef BP_PACKED union{
    BP_U_8BIT reg;
    struct{
        BP_BIT_FIELD ffe_init_scale:3; /* currently only requires 2 bits */
        BP_BIT_FIELD ffe_data_scale:2; /* currently only requires 1 bit */
        BP_BIT_FIELD reserved:2;
        BP_BIT_FIELD adjusted_felm:1;
    }bits;
}BP_PACKED2 SU_FLAGS_TYPE;


/* These variables are in RAM since effect real time performance, 
 * i.e. are accessed in interrupt handler.
 */
typedef BP_PACKED union
{
  BP_U_8BIT reg;
  struct
      {
      BP_BIT_FIELD operational:1;
      BP_BIT_FIELD ber_meter_state:1;
      BP_BIT_FIELD temp_env_adapt:2;
      BP_BIT_FIELD interrupt_enabled:1;
      BP_BIT_FIELD zip_startup_mode:1; /* must be at bit #5 */
      BP_BIT_FIELD meter_interval_elapsed:1;
      BP_BIT_FIELD te_meter_interval_elapsed:1;
      } bits;
}BP_PACKED2 BP_FLAGS;

typedef struct
{
    BP_FLAGS bp_flags;
    BP_U_16BIT symbol_rate;
    BP_U_8BIT felm_lookup_index;
    BP_S_8BIT access_data_byte[NUM_ACCESS_DATA_BYTES];
    BP_U_8BIT te_meter_interval_cntr;
    BP_U_8BIT te_num_meter_intervals;

#ifdef BER_METER
    BER_METER_STRUCT ber_meter;
#endif

#ifdef NO_INDIRECT_RAM_VARS
    BP_S_8BIT eq_ram_vars[NUM_EQ_RAM_VARS][EQ_RAM_BYTE_WIDTH];
    BP_S_8BIT scratch_pad_vars[NUM_SCRATCH_PAD_VARS];
#endif

#ifdef BP_MASK_INTERRUPTS
    BP_U_8BIT temp_mask_low_reg;
    BP_U_8BIT temp_mask_high_reg;
#endif

} BP_GLOBAL_VAR;

extern BP_GLOBAL_VAR BP_MSPACE _bp_vars[_NO_OF_LOOPS];

extern DECLARE_PTR_ARRAY;
extern DECLARE_INT_REG;

#ifdef PDATA_MODE
extern BP_U_8BIT BP_MSPACE _p2_value;
#endif

/*---------------------------------------------------------*/
/*  Extern Functions                                       */
/*---------------------------------------------------------*/
extern BP_S_16BIT abs(BP_S_16BIT val);
