/***********************************************************/
/*    BtMain()                                             */
/*    Bitpump main routine.                                */
/*    (C) Copyright 1993 by Rockwell Corporation           */
/*                                                         */
/*    This program is copyrighted by Rockwell Corporation  */
/*                                                         */
/* Description:                                            */
/*    Performs major bit-pump control operations by calling*/
/*    the HTU-C/HTU-R control routines, according to user  */
/*    set terminal type.                                   */
/*    Performs Software initialization.                    */
/*                                                         */
/* Notes:                                                  */
/*                                                         */
/* User Modifiable Code:                                   */
/*    Asynchronous vs Synchronous                          */
/*                                                         */
/* List of functions included in this module:              */
/*   _BtMain()                                             */
/*   _BtSwPowerUp()                                        */
/*   _MaskBtHomerInt()                                     */
/*                                                         */
/* Programmer:                                             */
/*     Dean Rasmussen             March - 1998             */
/*     Iris Shuker                14-Sept-1993             */
/*                                                         */
/* Revision History:                                       */
/*                                                         */
/***********************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

#include "bthomer.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/

#define SYNCHRONOUS_MODE    0x00
#define ASYNCHRONOUS_MODE   0x01

/*---------------------------------------------------------*/
/*  Static Functions                                       */
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
/*  Global Variables                                       */
/*---------------------------------------------------------*/

BP_GLOBAL_VAR BP_MSPACE _bp_vars[_NO_OF_LOOPS];


/*---------------------------------------------------------*/
/*  Static Variables                                       */
/*---------------------------------------------------------*/

/***********************************************************/
/*    _BtMain()                                            */
/*    Bitpump main routine.                                */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input Variables: None                                */
/*                                                         */
/*    Output Variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _BtMain();                                    */
/*                                                         */
/* programer:                                              */
/*     Iris Shuker                24-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

void _BtMain (BP_U_8BIT no)
{
    status_reg_type status_reg;           /* Status variable */
    user_setup_low_type user_setup_low;
    user_setup_high_type user_setup_high;

    DECLARE_PTR;

    /*---------------------------------------------------------*/
    /*  Go over all operational bit-pumps:                     */
    /*---------------------------------------------------------*/

    if ( _bp_vars[no].bp_flags.bits.operational ) /* Bit_pump #no operational */
        {

        /*-------------------------------------------------*/
        /* Initiate bitpump pointers                       */
        /*-------------------------------------------------*/
        INIT_BP_PTR;

        /*---------------------------------------------*/
        /* Process micro processor interrupts          */
        /*---------------------------------------------*/
        _HandleFlags(no); /* Handle bit_pump received interrpts flags */

        RD_BYTE(no, STATUS, status_reg.status);
        if ( !status_reg.bits.normal_operation )
            {
            /*---------------------------------------------*/
            /* Execute HTU-C or HTU-R Control Process      */
            /*---------------------------------------------*/

            RD_WORD(no, USER_SETUP, user_setup_low.setup, user_setup_high.setup);

            if ( user_setup_low.bits.terminal_flag ) /* HTU-R */
                _HturControlProcess(no); /* HTU-R control process */
            else /* HTU-C */
                _HtucControlProcess(no); /* HTU-C control_process */

            /*---------------------------------------------*/
            /* Execute any Test Modes                      */
            /*---------------------------------------------*/
            _HandleTestMode(no);
            } /* end ! normal op */
        else
            {
            /*---------------------------------------------*/
            /* Execute Temperature/Environmental Changes   */
            /*---------------------------------------------*/
#ifdef TEMP_ENV
            _HandleTempEnv(no);
#endif

#ifdef ZIP_START
            _ZipStart_HandleUpdate(no);
#endif

            }

        } /* END-IF bit_pump #no is operational */


} /* END _BtMain() */

/***********************************************************/
/*    _BtSwPowerUp()                                       */
/*    Software power up initialization.                    */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _BtSwPowerUp();                               */
/*                                                         */
/* programer:                                              */
/*     Iris Shuker                24-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

void _BtSwPowerUp (BP_U_8BIT no)
{
    _bp_vars[no].bp_flags.reg = RESET;

    _BtHomerPointersInit(no);

} /* END _BtSwPowerUp() */

/***********************************************************/
/*    _MaskBtHomerInt()                                    */
/*    Masking all Bitpumps (three loops) interrupts.       */
/*                                                         */
/*    Returns: void                                        */
/*                                                         */
/*    Input variables: BP_U_8BIT no                        */
/*                                                         */
/*    Output variables: None                               */
/*                                                         */
/*    example:                                             */
/*           _MaskBtHomerInt();                            */
/*                                                         */
/* programer:                                              */
/*     Iris Shuker                24-Oct-1993              */
/*                                                         */
/* revision history:                                       */
/*                                                         */
/***********************************************************/

void _MaskBtHomerInt (BP_U_8BIT no)
{
    DECLARE_PTR;
    DECLARE_MODE_PTR;

    INIT_BP_PTR;
    INIT_BP_MODE_PTR;

    _bp_vars[no].symbol_rate = 1;

    BP_WRITE_REG(bp_ptr, mask_low_reg, 0xFF);
    BP_WRITE_REG(bp_ptr, mask_high_reg, 0xFF);

#ifdef BP_MASK_INTERRUPTS
    /* set the 'bp_vars...interrupt_enabled' flag */
    _bp_vars[no].temp_mask_low_reg = 0xFF;
    _bp_vars[no].temp_mask_high_reg = 0xFF;
    _EnableBitpumpInterrupt();
#endif

    BP_WRITE_REG(bp_ptr, misc_test, RESET);

    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section btmain.1   Begins        <<<*/
    /*----------------------------------------------------------*/
    /* Modification Description:                                */
    /* Specify uProcessor Timing:  Sync or Async                */
    /*                                                          */
    /* Reference:                                               */
    /* "Bt8970 Software User's Guide", Section ?.?.1            */
    /*----------------------------------------------------------*/

    BP_WRITE_BIT(bp_mode_ptr, misc_test, async_mode, ASYNCHRONOUS_MODE);

    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section btmain.1   Ends          <<<*/
    /*----------------------------------------------------------*/

    DELAY2SYMBOL;

    BP_WRITE_BIT(bp_mode_ptr, serial_monitor_source, hclk_freq, _HCLK_DEFAULT);
    BP_WRITE_REG(bp_ptr, cu_interface_modes, _SERIAL); /* Allows BCLK to be valid */

} /* END _MaskBtHomerInt */

