/***************************************************************/
/*    BTINT.C                                                  */
/*    Bitpump interrupt handler.                               */
/*    (C) Copyright 1993 by Rockwell Corporation               */
/*                                                             */
/*    This program is copyrighted by Rockwell Corporation      */
/*                                                             */
/* Description:                                                */
/*    This file contains the interrupt handler routine for     */
/*    Bitpump interrupt. The routine scans all active          */
/*    Bitpumps' interrupt status registers, and sets the       */
/*    software interrupt status array accordingly. Active      */
/*    interrupts that are not Timer interrupts are masked,     */
/*    while active Timer interrupts are cleared.               */
/*                                                             */
/* Notes:                                                      */
/*                                                             */
/* User Modifiable Code:                                       */
/*    Interrupt handler routine HEADER.                        */
/*    NOTE: The CONTENTS of the routine should NOT be changed. */
/*    If an interrupt Install function is required by the      */
/*    compiler used, the user should write the Install routine */
/*    and call it on power-up.                                 */
/*                                                             */
/* List of functions included in this module:                  */
/*   External0()                                               */
/*                                                             */
/* Programmer:                                                 */
/*     Dean Rasmussen             March - 1998                 */
/*     Iris Shuker                20-Oct-1993                  */
/*                                                             */
/* Revision History:                                           */
/*     date/name of reviser                                    */
/*                                                             */
/***************************************************************/

/*---------------------------------------------------------*/
/*  Includes                                               */
/*---------------------------------------------------------*/

#include "bthomer.h"

/*---------------------------------------------------------*/
/*  Local Defines                                          */
/*---------------------------------------------------------*/
#define INTR_METER_BIT  0x10
#define INTR_T3_BIT     0x40

/*---------------------------------------------------------*/
/*  Global Variables                                       */
/*---------------------------------------------------------*/

/* Bit_pumps internal interrupt registers */
DECLARE_INT_REG;


#ifdef PDATA_MODE
BP_U_8BIT BP_MSPACE _p2_value;
#endif

/*---------------------------------------------------------*/
/*  Interrupt Handler                                      */
/*---------------------------------------------------------*/

#ifdef C51
/* Using 8051,C51 compiler,Int vector at 0003H */
void _BpInterruptHandler () interrupt 0
#else
    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section btint.1    Begins        <<<*/
    /*----------------------------------------------------------*/
    /* Modification Description:                                */
    /* Write the interrupt handler routine HEADER.              */
    /* This routine should be entered whenever Bitpump          */
    /* interrupt is activated.                                  */
    /* (This interrupt should not be masked).                   */
    /*                                                          */
    /* Reference:                                               */
    /* "Bitpump Software User's Manual", Section ?.?.1.         */
    /*----------------------------------------------------------*/
void _BpInterruptHandler ()
    /*----------------------------------------------------------*/
    /*>>>   User Modifiable Section btint.1    Ends          <<<*/
    /*----------------------------------------------------------*/
#endif
{

    BP_U_8BIT no;
#ifndef INT_BUG
    BP_U_8BIT temp;
#endif

#ifdef PDATA_MODE
    BP_U_8BIT address;
#endif

    DECLARE_PTR;
    DECLARE_INT_PTR;
#ifdef TEMP_ENV
    DECLARE_MODE_PTR;
#endif

    /*------------------------------------------------------------------*/
    /* Read Bitpump#0, #1, #2 status register and set global registers  */
    /* accordingly. Mask active IRQ source interrupts and reset active  */
    /* timer source interrupts.                                         */
    /*------------------------------------------------------------------*/

#ifdef PDATA_MODE
    address = _p2_value;
#endif

    for (no = _BIT_PUMP0; no < _NO_OF_LOOPS; no++) /* Handle bit_pumps interrupt status registers */
        {
        if ( _bp_vars[no].bp_flags.bits.operational
#ifdef BP_MASK_INTERRUPTS
             && _bp_vars[no].bp_flags.bits.interrupt_enabled
#endif
            )
            {

            /*----------------------------------------------------------*/
            /* Initiate bitpump pointers                                */
            /*----------------------------------------------------------*/
            INIT_BP_PTR;
            INIT_INT_PTR;

#ifndef INT_BUG
            temp = ((BP_READ_REG(bp_ptr, timer_source)) & ~(BP_READ_REG(bp_ptr, mask_low_reg)));
            int_ptr -> bytes.timer_source |= temp; /* Read interrupt status */
            BP_WRITE_REG(bp_ptr, timer_source, ~temp); /* Reset active interrupts */
#endif
            int_ptr -> bytes.irq_source |= ((BP_READ_REG(bp_ptr, irq_source)) & ~(BP_READ_REG(bp_ptr, mask_high_reg))); /* Read interrupt status */
            BP_WRITE_REG(bp_ptr, mask_high_reg, BP_READ_REG(bp_ptr, mask_high_reg) | int_ptr -> bytes.irq_source);

#ifdef TEMP_ENV
            INIT_BP_MODE_PTR;

            /*
             * During Temp/Environment, disable the adaptation
             */
            if ( (temp & INTR_T3_BIT) )
                {
                switch ( _bp_vars[no].bp_flags.bits.temp_env_adapt )
                    {
                    default:
                    case TEMP_ENV_NOT_ADAPT:
                        break;

#ifdef HTUR
                    case TEMP_ENV_ADAPT_DAGC:
                        BP_WRITE_BIT(bp_mode_ptr, dagc_modes, adapt_coefficient, OFF);
                        _bp_vars[no].bp_flags.bits.temp_env_adapt = TEMP_ENV_NOT_ADAPT;
                        break;
#endif

#ifdef HTUC

                    case TEMP_ENV_ADAPT_DAGC_DFE:
                        BP_WRITE_BIT(bp_mode_ptr, dagc_modes, adapt_coefficient, OFF);
                        BP_WRITE_BIT(bp_mode_ptr, dfe_modes, adapt_coefficients, OFF);
                        _bp_vars[no].bp_flags.bits.temp_env_adapt = TEMP_ENV_NOT_ADAPT;
                        break;

                    case TEMP_ENV_ADAPT_FFE:
                        BP_WRITE_BIT(bp_mode_ptr, ffe_modes, adapt_coefficients, OFF);
                        _bp_vars[no].bp_flags.bits.temp_env_adapt = TEMP_ENV_NOT_ADAPT;
                        break;
#endif
                    }   /* end switch */
                }   /* end if T3 */
#endif /* TEMP_ENV */


#ifdef BER_METER
            /* Increment counters every meter interval */
            if ( (temp & INTR_METER_BIT) && _bp_vars[no].bp_flags.bits.ber_meter_state )
                {
                temp = BP_READ_REG(bp_ptr, ber_meter_low);
                _bp_vars[no].ber_meter.bit_errors += BYTE2WORD(BP_READ_REG(bp_ptr, ber_meter_high), temp);
                _bp_vars[no].ber_meter.meter_intervals++;
                }
#endif

            } /* END-IF bit pump #no operational */


        } /* END-FOR bit_pump#1, bit_pump#2 and bit_pump#3 */

#ifdef PDATA_MODE
    P2 = address;
    _p2_value = address;
#endif

} /* END external0() */

